define(['jquery'], function($){
	return function() {

		this.canonical_url = '';

		this.Init = function(canonical_url)
		{
			self = this;
			// any initialization goes here
			$('#shareButton').on('click', self.ShowModal);

			// Sets canonical url if passed in by the templater version of Share
			this.canonical_url = canonical_url;
		};

		this.ShowModal = function(e)
		{
			e.preventDefault();

			// Sets canonical url if set as a data attribute by the Angular version of Share
			self.canonical_url = '';
			var canonicalUrl = $('#shareButton').data('canonical-url');
			if (typeof canonicalUrl !== 'undefined')
				self.canonical_url = canonicalUrl;

			// get the modal via GET request then show it
			var modal_id = 'sharelink_modal';
			var modal_selector = '#' + modal_id;

			// check if modal has already been downloaded/created.
			if ($(modal_selector + '_container').length !== 0)
			{
				// Re-init message to handle one-page apps that may use different URLs
				var message = window.location.toString();
				if (self.canonical_url !== '')
					message = self.canonical_url;
				$('#sharelink_message').val(message);

				self.GenerateMailto();

				// modal already exists
				window.jQuery(modal_selector).modal('show');
			}
			else
			{
				// get the modal html from the server and initialize it
				var url = '/share/link';
				$(document.body).append('<div id="' + modal_id + '_container"></div>');

				$(modal_selector + '_container').load(url, function(response, status, xhr){
					if (status === 'success') {

						// set subject and message to be title and url respectively.
						$('#sharelink_subject').val(document.title.toString());

						var message = window.location.toString();
						if (self.canonical_url !== '')
							message = self.canonical_url;
						$('#sharelink_message').val(message);

						self.GenerateMailto();

						$('#sharelink_close').on('click', function(e){
							e.preventDefault();
							window.jQuery('#sharelink_modal').modal('hide');
						});

						$('#sharelink_subject').on('change', function(e){
							self.GenerateMailto()
						});
						$('#sharelink_message').on('change', function(e){
							self.GenerateMailto()
						});

						$('#sharelink_send_message').on('click', function(e){
							e.preventDefault();

							var data = self.GetMessageDataObj();

							if(!self.ValidateForm(data))
							{
								return false;
							}
							else
							{
								self.SendNotification(data);
							}
						});
						// using window version of jquery as bootstrap (for modal)
						// doesn't exist as a plugin for the requirejs version
						window.jQuery('#sharelink_modal').modal('show');
					} else {
						console.error(lmsg('common.file_upload.could_not_get_modal'));
					}
				});
			}
		};

		this.SendNotification = function(formdata)
		{
			$.post(
				'/share/link/send',
				formdata,
				function(data, status, jqXHR){
					// close the modal
					window.jQuery('#sharelink_modal').modal('hide');
					// blank the user select field
					$('#sharelink_send_to').empty();
					if (data.status === 'OK')
					{
						cla.showMessage(data.message, false);
					}
					else
					{
						cla.showMessage(data.message, true);
					}
				},
				'json'
			).fail(
				function(data, status, jqXHR){
					cla.showMessage(data.message, true);
				}
			);
		};

		this.ValidateForm = function(data)
		{
			// hide the error
			var $errorNotification = $('#sharelink_error');
			$errorNotification.hide();
			if (data.send_to == null || data.send_to.length < 1)
			{
				$errorNotification.show();
				return false;
			}
			if (data.subject === '' || data.message === '')
			{
				$errorNotification.show();
				return false;
			}
			return true;
		};

		this.GenerateMailto = function()
		{
			var data = this.GetMessageDataObj();

			// ignore send_to.
			var href = 'mailto:?subject=' + encodeURIComponent(data.subject) + '&body=' + encodeURIComponent(data.message);
			$('#sharelink_mailto').prop('href', href);
		};

		this.GetMessageDataObj = function() {
			return {
				send_to : $('#sharelink_send_to').val(),
				subject : $('#sharelink_subject').val(),
				message : $('#sharelink_message').val()
			};
		};

	}
});
