require('cla_angular');
require('ng.cla.core.icon_picker');
require('cla_select2');

module.exports = {
	init: function (id) {

		// create ng module
		var moduleName = 'iconPickerModule';
		var module;
		try { module = angular.module(moduleName); }
		catch(err) {
			module = angular.module(moduleName, ['cla.core.icon_picker']);
		}

		module.controller('IconPickerController', function IconPickerController() {
			var ctl = this;
			ctl.value = '';
			ctl.init = function (icon) {
				ctl.value = icon;
			}
		});

		// bootstrap ng module
		if (typeof angular.element(id).scope() === 'undefined')
			angular.bootstrap(angular.element('#'+id), [moduleName, 'cla.core.icon_picker']);
	}
};