<?php
namespace Claromentis\Core\Acl\Simple;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"] ?: array()) + array("_70809333a0f254" . "acf7a1ad0c7dadd" . "46b" => base64_decode("O" . "i" . "A" . "="), "_2b97c0c" . "a1bb9e70" . "cb77f4fb" . "f2e523d8" . "d" => base64_decode("Q2FuJ3QgZGVsZXRlIHBl" . "cm1pc3Npb246IHVzZXIg" . "SUQgaXMgbm90IHNwZWNp" . "ZmllZA=="), "_96be32a6f44bf54e635e173" . "6acf7a96c" => base64_decode("c2Vy" . "aWFs" . "aXpl"), "_7e4946b30c" . "25f9bccba6f" . "750950330de" => base64_decode("Q2FuJ3QgZ2V0IHBlcm1pc3Npb25zOiB1c2VyIElEIGlzIG5vdCBzcGV" . "jaWZpZWQ="), "_c244a470df5" . "2d1d5a708513" . "8ec94e393" => base64_decode("dW5zZXJpYWxpem" . "U="), "_7f628626dd1d55c71b1fc09" . "32ffd1d2c" => base64_decode("aXNf" . "YXJy" . "YXk="), "_d706c160e45bf7434fff8" . "2a5976f0e19" => base64_decode("YXJyYXlfa2V5c" . "w=="), "_aed8da0f190912" . "14b78f803510485" . "17c" => base64_decode("c3Ry" . "bGVu"));
use Claromentis\Core\Acl\Exception\InvalidSubjectException;
use Claromentis\Core\Acl\PermOClass;






class SimpleAcl
{
    const STANDARD = 1;
    protected $object_code;
    protected $rights;
    
    
    
    
    
    
    public function __construct(string $_65c616d6ef3c21352d2d44595fdf776b = '')
    {
        $this->object_code = $_65c616d6ef3c21352d2d44595fdf776b;
        $this->Clear();
    }
    public function SetObjectCode(string $_65c616d6ef3c21352d2d44595fdf776b)
    {
        $this->object_code = $_65c616d6ef3c21352d2d44595fdf776b;
    }
    public function GetObjectCode() : string
    {
        return $this->object_code;
    }
    
    
    
    
    public function Clear()
    {
        $this->Hydrate(array());
    }
    
    
    
    
    
    
    public function Hydrate(array $rights)
    {
        $this->rights = $rights;
    }
    
    
    
    
    
    
    
    
    
    public function Grant(int $user_id, int $perms = self::STANDARD)
    {
        if (empty($perms)) {
            return true;
        }
        if (!isset($this->rights[$user_id])) {
            $this->rights[$user_id] = $perms;
        } else {
            $this->rights[$user_id] |= $perms;
        }
        return true;
    }
    
    
    
    
    
    
    
    
    
    public function Permits(int $user_id, int $perms = 0)
    {
        if ($perms === 0) {
            return !empty($this->rights[$user_id]);
        }
        $p = $this->Get($user_id);
        return $p & $perms == $perms;
    }
    
    
    
    
    
    
    
    
    
    public function Set(int $user_id, int $perms = self::STANDARD)
    {
        if (empty($perms)) {
            unset($this->rights[$user_id]);
        } else {
            $this->rights[$user_id] = $perms;
        }
        return true;
    }
    
    
    
    
    
    
    
    public function SetMany(array $_5882c836e9757b405d08e77f1fd2a18b, int $perms = self::STANDARD)
    {
        foreach ($_5882c836e9757b405d08e77f1fd2a18b as $user_id) {
            $this->Set($user_id, $perms);
        }
    }
    
    
    
    
    
    
    
    
    public function Get(int $user_id) : int
    {
        if (empty($user_id)) {
            throw new InvalidSubjectException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_7e4946b30c25f9bcc" . "ba6f750950330de"]);
        }
        if (!isset($this->rights[$user_id])) {
            return 0;
        }
        return $this->rights[$user_id];
    }
    
    
    
    
    
    
    
    public function Delete(int $user_id, int $perms = 0)
    {
        if (empty($user_id)) {
            throw new InvalidSubjectException($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_2b97c0ca1bb9e70cb" . "77f4fbf2e523d8d"]);
        }
        if ($perms === 0) {
            unset($this->rights[$user_id]);
        }
        $this->Set($this->Get($user_id) & ~$perms, $user_id);
    }
    
    
    
    
    
    
    
    
    public function CreateCopy(string $_65c616d6ef3c21352d2d44595fdf776b) : SimpleAcl
    {
        $acl = new SimpleAcl($_65c616d6ef3c21352d2d44595fdf776b);
        $acl->Hydrate($this->GetRights());
        return $acl;
    }
    
    
    
    
    
    
    
    
    public function GetRights(int $perms = 0) : array
    {
        if ($perms === 0) {
            return $this->rights;
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        foreach ($this->rights as $user_id => $p) {
            if (($p & $perms) == $perms) {
                $_1f24efd4735b7a11b391147435e7d35d[$user_id] = $p;
            }
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    
    public function GetIndividualsList(int $perms = 0)
    {
        if ($perms === 0) {
            return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_d706c160e45bf74" . "34fff82a5976f0e1" . "9"]($this->rights);
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        foreach ($this->rights as $user_id => $p) {
            if (($p & $perms) == $perms) {
                $_1f24efd4735b7a11b391147435e7d35d[] = $user_id;
            }
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    public function AsTextStrings() : array
    {
        $_a91f531562c56061228ba02b34c36a79 = [];
        $_5882c836e9757b405d08e77f1fd2a18b = $this->GetIndividualsList();
        foreach ($_5882c836e9757b405d08e77f1fd2a18b as $user_id) {
            $_a91f531562c56061228ba02b34c36a79[] = PermOClass::GetName(PermOClass::INDIVIDUAL) . $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_7080933" . "3a0f254a" . "cf7a1ad0" . "c7dadd46" . "b"] . \User::GetNameById($user_id);
        }
        return $_a91f531562c56061228ba02b34c36a79;
    }
    
    
    
    
    public function Serialize() : string
    {
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_96be32a6f44b" . "f54e635e1736a" . "cf7a96c"]($this->rights);
    }
    
    
    
    
    public function Unserialize(string $_34460bffd3af92da81e46ee15e9e66e3)
    {
        if ($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_aed8da0" . "f1909121" . "4b78f803" . "51048517" . "c"]($_34460bffd3af92da81e46ee15e9e66e3) > 0) {
            $rights = $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_c244a470df52d1d5a70" . "85138ec94e393"]($_34460bffd3af92da81e46ee15e9e66e3);
            if ($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_7f628626dd1d55c71" . "b1fc0932ffd1d2c"]($rights)) {
                $this->Hydrate($rights);
            }
        }
    }
}