/**
 * Helps run ldap searches
 *
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.service('searchService', searchService);

	searchService.$inject = ['connectionService', 'ldapResources'];

	/**
	 *
	 */
	function searchService(connectionService, ldapResources) {
		var service = {
			properties: {
				baseDN: '',
				filter: '',

				results: ''
			},

			search: search,
			isConnected: isConnected,
			mapNames: mapNames
		};

		service.properties.baseDN = connectionService.properties.searchBaseDN;
		return service;

		/**
		 * ldap search
		 */
		function search() {
			var connectionObject = connectionService.mapNames();
			var searchObject = service.mapNames();
			return ldapResources.search(connectionObject, searchObject).$promise;
		}

		/**
		 * checks if ldap is connected
		 * @returns {boolean}
		 */
		function isConnected() {
			return connectionService.connected;
		}

		/**
		 * map js names to expected url params
		 */
		function mapNames() {
			return {
				'base_dn': service.properties.baseDN,
				'query': service.properties.filter
			}
		}
	}
}());