<?php
$_db_migration_to = '28.02'; // 8.2.0-beta
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_news_link_length.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Links can be larger than 255 characters if they have extra info in (e.g. wrapped google search link, email campaign click tracking data)
// From Disco ticket 17045

$db->AlterColumn('news', 'link', 'link', 'VARCHAR(1024) NULL');
DB_UPDATE_FILE
);


$migrations->Run('01_telemetry_payload_data.php', <<<'DB_UPDATE_FILE'
<?php

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();
$table_description = array(
	'id'	=>	"IDENTITY",
	'created'	=>	"INT_DATE",
	'payload' => "CLOB",
	'is_sent' => "BOOL"
);

$db->CreateTable('telemetry_payloads', $table_description, true);

DB_UPDATE_FILE
);


$migrations->Run('08_social_migration.php', <<<'DB_UPDATE_FILE'
<?php

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

list($skype_exists) = $db->query_row("SELECT COUNT(1) FROM metadata_simple WHERE name='usr_skype_id'");
if (!$skype_exists)
	$res = $db->query("UPDATE metadata_simple SET name = 'usr_skype_id' WHERE name='skype'");

list($twitter_exists) = $db->query_row("SELECT COUNT(1) FROM metadata_simple WHERE name='usr_twitter_id'");
if (!$twitter_exists)
	$db->query("UPDATE metadata_simple SET name = 'usr_twitter_id' WHERE name='usr_twitter'");

list($linkedin_exists) = $db->query_row("SELECT COUNT(1) FROM metadata_simple WHERE name='usr_linked_id'");
if (!$linkedin_exists)
	$db->query("UPDATE metadata_simple SET name = 'usr_linkedin_id' WHERE name='usr_linkedin'");

//set default visibility

$profile_social_visible = $migrations->GetConfigFull()->Get('cfg_profile_social_visible');
if ($profile_social_visible)
{

	list($max_order) = $db->query_row("SELECT MAX(view_profile_order) as max FROM users_fields");
	$max_order++;
	$fields = [];
	list($old_skype_exists) = $db->query_row("SELECT COUNT(1) FROM ERMS_metadata_field WHERE name='skype'");
	if ($old_skype_exists)
		$fields = array_merge($fields, array('skype_call', 'skype_chat', 'skype_id'));

	list($old_linkedin_exists) = $db->query_row("SELECT COUNT(1) FROM ERMS_metadata_field WHERE name='usr_linkedin'");
	if ($old_linkedin_exists)
		$fields[] = 'linkedin_id';

	list($old_twitter_exists) = $db->query_row("SELECT COUNT(1) FROM ERMS_metadata_field WHERE name='usr_twitter'");
	if ($old_twitter_exists)
		$fields[] = 'twitter_id';

	foreach ($fields as $field)
	{
		list($field_already_visible) = $db->query_row("SELECT COUNT(1) FROM users_fields WHERE field_name eq:str:name", $field);
		if (!$field_already_visible)
		{
			$db->query("INSERT INTO users_fields (field_name, is_metadata, view_profile_order) VALUES (str:field, 0, int:order)", $field, $max_order);
			$max_order++;
		}
	}

}

list($endorsement_visible) = $db->query_row("SELECT COUNT(1) FROM users_fields WHERE field_name='endorsements'");
if (!$endorsement_visible)
{
	list($max_order) = $db->query_row("SELECT MAX(view_profile_order) as max FROM users_fields");
	$max_order++;

	$db->query("INSERT INTO users_fields (field_name, is_metadata, view_profile_order) VALUES ('endorsements', 0, int:order)", $max_order);
}

//delete old metadata

$db->query("DELETE FROM ERMS_metadata_field WHERE name='usr_linkedin'");
$db->query("DELETE FROM ERMS_metadata_field WHERE name='usr_skype'");
$db->query("DELETE FROM ERMS_metadata_field WHERE name='skype'");
$db->query("DELETE FROM ERMS_metadata_field WHERE name='usr_twitter'");


DB_UPDATE_FILE
);


$migrations->Run('09_publish_plugin.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */

$plugins = $migrations->GetPluginsRepository();
$plugins->Add('publish', '\Claromentis\Publish\PublishApplication');
//$plugins->SetEnabled('publish', false);

DB_UPDATE_FILE
);


$migrations->Run('10_publish_plugin_app.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->query("INSERT INTO db_installed (application, version) VALUES ('publish', '00.00')");

DB_UPDATE_FILE
);


$migrations->Run('11_move_global_style.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$table_descr = array(
	'id'    => "IDENTITY",
	'style'	=> "CLOB NULL"
);

$db->CreateTable('theme_style', $table_descr, true);

list($customization) = $db->query_row("SELECT var_value FROM variables WHERE var_name='customization'");
if ($customization != '')
{
	$db->query("INSERT into theme_style (style) VALUES (clob:value)", $customization);
	$db->query("DELETE FROM variables where var_name='customization'");
}

DB_UPDATE_FILE
);


$migrations->Run('11_webmail_plugin.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */

$plugins = $migrations->GetPluginsRepository();
$plugins->Add('mail', '\Claromentis\Mail\WebMailApplication');
$plugins->SetEnabled('mail', false);

$db = $migrations->GetDb();
$db->query("DELETE FROM db_installed WHERE application='mail'");
$db->query("INSERT INTO db_installed (application, version) VALUES ('mail', '00.00')");

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('28.02');
