<?php
namespace Claromentis\Core\Acl\Simple;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"] = (@$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"] ?: array()) + array("_70809333a0f254acf7a1ad" . "0c7dadd46b" => base64_decode("O" . "i" . "A" . "="), "_96be32a6f44bf54" . "e635e1736acf7a96" . "c" => base64_decode("c2V" . "yaW" . "Fsa" . "Xpl"), "_d706c160e45bf7" . "434fff82a5976f0" . "e19" => base64_decode("YXJyYXlfa2V5" . "cw=="), "_2b97c0ca1bb9e70cb77f4" . "fbf2e523d8d" => base64_decode("Q2FuJ3QgZGVsZXRlIHBlcm1pc3Npb24" . "6IHVzZXIgSUQgaXMgbm90IHNwZWNpZm" . "llZA=="), "_aed8da0f19091214b78f80351" . "048517c" => base64_decode("c3Ry" . "bGVu"), "_c244a470df52d1d5" . "a7085138ec94e393" => base64_decode("dW5zZXJpYWxp" . "emU="), "_7f628626dd1d5" . "5c71b1fc0932ff" . "d1d2c" => base64_decode("aXNfYXJyYX" . "k="), "_7e4946b30c25f9bccba6f750" . "950330de" => base64_decode("Q2FuJ3QgZ2V0IHBlcm1pc3Npb25zO" . "iB1c2VyIElEIGlzIG5vdCBzcGVjaW" . "ZpZWQ="));
use Claromentis\Core\Acl\Exception\InvalidSubjectException;
use Claromentis\Core\Acl\PermOClass;






class SimpleAcl
{
    const STANDARD = 1;
    protected $object_code;
    protected $rights;
    
    
    
    
    
    
    public function __construct(string $_65c616d6ef3c21352d2d44595fdf776b = '')
    {
        $this->object_code = $_65c616d6ef3c21352d2d44595fdf776b;
        $this->Clear();
    }
    public function SetObjectCode(string $_65c616d6ef3c21352d2d44595fdf776b)
    {
        $this->object_code = $_65c616d6ef3c21352d2d44595fdf776b;
    }
    public function GetObjectCode() : string
    {
        return $this->object_code;
    }
    
    
    
    
    public function Clear()
    {
        $this->Hydrate(array());
    }
    
    
    
    
    
    
    public function Hydrate(array $rights)
    {
        $this->rights = $rights;
    }
    
    
    
    
    
    
    
    
    
    public function Grant(int $user_id, int $perms = self::STANDARD)
    {
        if (empty($perms)) {
            return true;
        }
        if (!isset($this->rights[$user_id])) {
            $this->rights[$user_id] = $perms;
        } else {
            $this->rights[$user_id] |= $perms;
        }
        return true;
    }
    
    
    
    
    
    
    
    
    
    public function Permits(int $user_id, int $perms = 0)
    {
        if ($perms === 0) {
            return !empty($this->rights[$user_id]);
        }
        $p = $this->Get($user_id);
        return $p & $perms == $perms;
    }
    
    
    
    
    
    
    
    
    
    public function Set(int $user_id, int $perms = self::STANDARD)
    {
        if (empty($perms)) {
            unset($this->rights[$user_id]);
        } else {
            $this->rights[$user_id] = $perms;
        }
        return true;
    }
    
    
    
    
    
    
    
    public function SetMany(array $_5882c836e9757b405d08e77f1fd2a18b, int $perms = self::STANDARD)
    {
        foreach ($_5882c836e9757b405d08e77f1fd2a18b as $user_id) {
            $this->Set($user_id, $perms);
        }
    }
    
    
    
    
    
    
    
    
    public function Get(int $user_id) : int
    {
        if (empty($user_id)) {
            throw new InvalidSubjectException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_7e4946b" . "30c25f9b" . "ccba6f75" . "0950330d" . "e"]);
        }
        if (!isset($this->rights[$user_id])) {
            return 0;
        }
        return $this->rights[$user_id];
    }
    
    
    
    
    
    
    
    public function Delete(int $user_id, int $perms = 0)
    {
        if (empty($user_id)) {
            throw new InvalidSubjectException($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_2b97c0ca1bb9e70cb77f4fbf" . "2e523d8d"]);
        }
        if ($perms === 0) {
            unset($this->rights[$user_id]);
        }
        $this->Set($this->Get($user_id) & ~$perms, $user_id);
    }
    
    
    
    
    
    
    
    
    public function CreateCopy(string $_65c616d6ef3c21352d2d44595fdf776b) : SimpleAcl
    {
        $acl = new SimpleAcl($_65c616d6ef3c21352d2d44595fdf776b);
        $acl->Hydrate($this->GetRights());
        return $acl;
    }
    
    
    
    
    
    
    
    
    public function GetRights(int $perms = 0) : array
    {
        if ($perms === 0) {
            return $this->rights;
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        foreach ($this->rights as $user_id => $p) {
            if (($p & $perms) == $perms) {
                $_1f24efd4735b7a11b391147435e7d35d[$user_id] = $p;
            }
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    
    public function GetIndividualsList(int $perms = 0)
    {
        if ($perms === 0) {
            return $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_d706c160e45bf7" . "434fff82a5976f0" . "e19"]($this->rights);
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        foreach ($this->rights as $user_id => $p) {
            if (($p & $perms) == $perms) {
                $_1f24efd4735b7a11b391147435e7d35d[] = $user_id;
            }
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    public function AsTextStrings() : array
    {
        $_a91f531562c56061228ba02b34c36a79 = [];
        $_5882c836e9757b405d08e77f1fd2a18b = $this->GetIndividualsList();
        foreach ($_5882c836e9757b405d08e77f1fd2a18b as $user_id) {
            $_a91f531562c56061228ba02b34c36a79[] = PermOClass::GetName(PermOClass::INDIVIDUAL) . $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_70809333" . "a0f254acf" . "7a1ad0c7d" . "add46b"] . \User::GetNameById($user_id);
        }
        return $_a91f531562c56061228ba02b34c36a79;
    }
    
    
    
    
    public function Serialize() : string
    {
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_96be32a6f44bf54e635e1736" . "acf7a96c"]($this->rights);
    }
    
    
    
    
    public function Unserialize(string $_34460bffd3af92da81e46ee15e9e66e3)
    {
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_aed8da0f" . "19091214b" . "78f803510" . "48517c"]($_34460bffd3af92da81e46ee15e9e66e3) > 0) {
            $rights = $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_c244a470df52d1d5a7085138ec94" . "e393"]($_34460bffd3af92da81e46ee15e9e66e3);
            if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_7f628626dd1d55c" . "71b1fc0932ffd1d2" . "c"]($rights)) {
                $this->Hydrate($rights);
            }
        }
    }
}