define(['cla_angular', 'ng.cla.core.growl', 'ng.cla.core.lmsg'], function (ng) {
	// angular defined by imports-loader
	ng.module('cla.ldap.connections', ['cla.core.growl', 'cla.core.lmsg', 'ngResource', 'ngSanitize']);
});

/**
 * sort array by metadata and non metadata
 */
if (!Array.prototype.sortArray) {
	Array.prototype.sortArray = function () {
		return this.sort(function(a, b) {
			return (a.slice(0, 3) === '[m]') - (b.slice(0, 3) === '[m]') || a.localeCompare(b);
		});
	}
}


/**
 * sort array of objects by name
 */
if (!Array.prototype.sortObject) {
	Array.prototype.sortObject = function () {
		return this.sort(function (a, b) {
			return (a.name > b.name) - (a.name < b.name);
		});
	}
}
