jQuery(function ($) {
    // TODO: Incorporate in communication.js or just webpack this
    var viewport = $(document);
    var container   = $('.conversation-messages-wrapper');
    var parametersElement = $('.js-conversation-messages-parameters');

    var messageId = parametersElement.data('messageId') || 0;
    var endpoint = '/communication/messages/' + messageId + '/xhr';
    var request;

    var endReached = false;
    var loadMargin = 300;

    viewport.scroll(function () {
        var target = $(this);

        var scrollTop = target.scrollTop();
        var height = target.height();
        var scrollBottom = scrollTop + $(window).height();

        var nearBottom = scrollBottom > height - loadMargin;

        if (messageId && nearBottom) {
            // Read request parameters from the data element
            var parameters = parametersElement.data();

            // Make a request if there isn't one in progress
            if (!request && !endReached) {
                request = $.get(endpoint, { offset: parameters.offset }).done(function (data) {
                    // Append the messages HTML
                    container.append(data.html);

                    // Update the data element
                    parameters.total = data.total;
                    parameters.offset = data.next;
                    parametersElement.data(parameters);

                    // Take note if we reach the end of the conversation
                    if (parameters.offset >= parameters.total) {
                        endReached = true;
                    }
                }).fail(function () {
                    // TODO: Localize error message
                    cla.showMessage(lmsg('communication.messages.error.load_messages'), null, true);
                }).always(function () {
                    request = null;
                });
            }
        }
    });
});
