# Claromentis Framework Change Log

## 8.7.2 - Unreleased

### Bug fixes

- !392 (CORE-743) Fixed missing in-system notification option in Reset Notifications

### Improvements

- !413 (UIUX-350) Added alert when leaving Infocapture ticket submission form

## 8.7.1 - 9 May 2019

- Merged forward bug fixes and improvements from 8.2.18, 8.3.14, 8.4.12, 8.5.10, 8.6.5.

## 8.7.0 - 26 Apr 2019

### New Features

- !306 Filesystem abstraction - data directory can now be set to a GCS bucket **(EXPERIMENTAL)**
- !290 Admin scripts - Admins can now add their own script inside the head tags, after body tag start and before the end of the body tag.
- !293 People HR user list - Users with HR access can now view blocked users in frontend people list.
- !283 Progressive Collapse Menu - When a system has many menu items, extra menu items are now collapsed with 'More' button appear to reveal.
- !240 (CORE-5) Appdata - Stateless deployment support
- !330 Layout fixes to all of the core components to deal with new slimmer wrappers added by the 6-grid pages branch and improvements to uniform styling of empty components messages.
- !313 Custom localisation is now editable and persistent
  - Custom languages can now be edited from the system admin panel, and will be persisted through upgrades
  - Notification templates and the digest email template can now be edited from the system admin panel
  - The digest email template is now a Twig template
- !317 CKEditor config can now be edited from the system admin panel, and will be persisted through upgrades
- !351 Communication has been updated for a more chat-like experience

### Improvements

- Merged forward bug fixes and improvements from 8.2.17, 8.3.13, 8.4.11, 8.5.9, 8.6.4.
- !322 Improved Gallery List component to add extra sort option which order the album list by which album had the most recent upload. (CORE-130)
- !296 All session handling is now done through the session object
- !319 (UIUX-17) Default home page option in theme editor changed from 'As set in VI' to 'Main'. If Main does not exist the first in the list is used.
- !273 Infocapture notifications are now logged
- !315 (UIUX-94) Calendar event popups are now placed in the center of the browser window
- !326 Redesigned scrollable submenus
- !328 The license can now be set from an environment variable
- !314 Enabled support for team drives in Google document picker.
- !313 Custom localisation, languages, and twig templates are now stored in the data volume
- !317 CKEditor config is now stored in the data volume
- !334 Google documents indexing API failures now reports to the system log once on first failure state and thereafter once each day instead of reporting it every minute.
- !371 (CORE-693) Compatibility fixes for PHP 7.1 and 7.2

### Bug fixes

- !303 (CORE-138) Fixed problem in menu builder item form that generated an erroneous URL
- !341 (CORE-398) Fixed a PHP compatibility warning that could appear on user profiles
- !313 Digest emails now show module names
- !344 (CORE-377) Added a user-friendly error message when attempting to preview a theme if its homepage is a page the user does not have permission to view
- !304 (CORE-231) Guests were being shown the master theme instead of the guest theme if no session cookie was set
- !367 (UIUX-403) Resolved an issue with an underline effect on hover being incorrectly applied to some elements
- !380 (CORE-749) Removed option to set default background when editing theme
- !385 (CORE-762) Fixed console error on webmail admin panel
- !379 (CORE-746) Fixed PHP compatibility issues with InfoCapture Statistics
- !372 (ASD-115) Fixed mail sending when the Filesystem abstraction is configured

### Breaking Changes

- Custom languages will now default to using English pluralisation rules. Previously they used plural forms for all numbers.
- !240 (CORE-5) Appdata - Stateless deployment support
  - `Claromentis\Core\Assets\AssetsConcatenator` constructor signature has changed
  - `Claromentis\Core\CDN\Local` constructor signature has changed
  - `web/intranet/common/get_appdata.php` has been removed, and has been superseded by `fc/appdata.php`
- !331 (CORE-18) Ported core installation from Phing tasks
  - Core installation no longer creates `web/intranet/common/config.php`
  - Installing with an SQLite database does not yet work correctly
- `MySettingsController` and `ThemeSelectDialog` now accepts a `ThemeStyleInterface` instead of a `callable`
- !313 the digest template is now in Twig format
- !339 `DbInterface::GetQueryBuilder()` is a newly introduced method
- !306 `Claromentis\Core\Imager\DriverImageMagick` now must be passed a fallback driver when instantiated (although it can be null), and also an instance of `GetLocalPath`, so that it can translate data-volume paths to local paths. For the second one `$app[GetLocalPath::class]` should be used.
- !351 Added column `imessages.conversation_id`
- !351 `IMessage::Send()` has a new optional `$date_sent` parameter
- Changed all default filesystem character set configurations from ISO-8859-1 to UTF-8
- Changed PHP compatibility constraint to ">=7.1.0 <7.3". PHP 7.0 is no longer supported.

### Developer notes

- !307 Added new Behat steps to perform some simple API tests and introduced some People API tests (CORE-118)
- !332 Added test:run and test:watch to CLC to run/watch PHPUnit tests for individual modules and parts of Core.
- !306 Filesystem abstraction
  - `CLARO_FS_MOUNTS` and `CLARO_FS_PATHS` config variables can be used to configure GCS as the data volume
  - `$cfg_cdn_type = 'filesystem';` and `$DATA_DIR = 'claro-data://data';` should be configured for this to work
  - See documentation for more information
- !240 (CORE-5) Appdata - Stateless deployment support
  - Allowed the `$APPDATA` config variable to be set by the `CLARO_APPDATA` environment variable for stateless
    deployments that are using Local CDN configs
  - Added support for nginx `X-Accel-Redirect` headers to let nginx serve appdata files
      - `CLARO_ACCEL_REDIRECT` config variable enables this
      - `CLARO_ACCEL_REDIRECT_PREFIX` gives an optional prefix for the internal path to use
      - See https://www.nginx.com/resources/wiki/start/topics/examples/xsendfile/ for more information
- !347 Implemented locking for Claromentis install, upgrade and uninstall commands
- !331 (CORE-18) Ported core installation from Phing tasks to the Symfony Console command
  - Implemented support for loading environment variables from a `.env` file in the application root
  - New `Configure` setup task that encapsulates setting up configuration prior to installs
      - Utilises Symfony Console's question prompting
      - Works non-interactively with environment variables using the `--no-interaction` command-line option
      - Writes environment config to a `.env` file when used interactively
      - Writes application config to `data/config/core.json`
      - Config is **no longer written to `config.php`**
  - (CORE-20) Restored cache-clearing when installing or upgrading modules
  - General improvements to existing caching and setup code
  - Implemented installation lock acquisition to prevent conflicts between multiple instances
- !339 Decoupled `QueryBuilder` from the global database instance
  - `QueryBuilder` can now be given a database instance to use
  - `DbInterface::GetQueryBuilder($str)` has been introduced to get a QueryBuilder for that database instance

## 8.6.5

### Improvements

- !390 added more logging for InfoCapture notifications
- !361 Added button to "View in Google Docs" for Google Document Links 

### Bug fixes

- (BT-318) Added a missing file upload button localisation in comments;

## 8.6.4 - 9 Apr 2019

### Bug fixes

- Merged forward bug fixes and improvements from 8.2.17, 8.3.13, 8.4.11, 8.5.9.

#### Improvements

- !348 Adding option to check out document through Document Check Out Utility desktop application for Mac and Windows.
- Adding Styles dropdown to Text Component in Pages.
- Bugfix in core for ICAutomator attachment error (BT-225).
- Fix iframe overflow on Mobile Safari in iOS (UIUX-437).

### Developer notes

- Setting user passwords has been refactored into a `SetUserPassword` use case in the People application (from 8.2.17)
- Added *.tmpl to .gitattributes

## 8.6.3 - 8 Mar 2019

### Bug fixes

- !355 Removing duplicate push notification when user is set to receive email digest in notification settings.
- !356 Fixed bug that prevented a user's username from being changed (CORE-574)
- Fixed SQL error when dispatching an empty set of push notifications
- !358 (CORE-586, Disco 22958) Holiday Planner - Fixed Zones & Groups diagrams updating improperly due to browser caching
- (CORE-589, Disco 23193) InfoCapture - Fixed default values not persisting for date fields
- Merged forward bug fixes and improvements from 8.3.11, 8.4.9, 8.5.7.

### Improvements

- !350 (CORE-501) User search suggestions box on global search results was not visible.
- !349 (CORE-387) Improved performance of the search indexing queue

### Breaking changes

- The session in LoginController is now handled via the $app->session object rather than using PHP session functions directly. This change should be seamless but is mentioned here in case there may be edge-case issues with logins (standard or custom).

### Developer notes

- !316 Configuration switching for Behat (CORE-123)
  This change introduces new Behat functionality that allows an alternative Behat-specific config file to be used.
  The config is loaded on top of the existing configuration so overrides existing settings. The Behat config file is optional and one or many config variables can be overridden.
- !349 (CORE-387) Added indexes to the search indexing queue table to improve performance

## 8.6.2 - 4 Feb 2019

### Bug fixes

- (CORE-289) Removed authentication from Calendar export to allow external access (iCal URL)
- (CORE-373) Comment default and like notifications now use permalink URLs instead of a link to the object.
- Merged forward bug fixes and improvements from 8.3.10, 8.4.8, 8.5.6 

### Improvements

- !346 (UIUX-331) Updates to live preview window including draggability, logo hiding and background updates
- !325 (UIUX-256) Implemented a live preview window when editing themes with the design tool
- !301 (UIUX-246) Improved display and visibility of the pin/unpin buttons in Discuss and Projects modules
- !324 Revert/delete buttons now only show in config editor when they are functional
- !338 Added basic filtering to the config editor
- !340 (UIUX-290) Implemented automatically checking the 'Keep me logged in' checkbox for small screen devices

### Breaking changes

### Developer notes

## 8.6.1 - 11 Jan 2019

### Bug fixes

- !309 (CORE-274) Fixed notifications failing to be sent via SMTP.
- !311 Fixed dates displaying incorrectly in push notifications.

### Improvements

### Breaking changes

### Developer notes

- !305 Updated Behat hooks that set up the environment before running a test to check plugins.json against the
db_installed table and flag a warning if there is a difference (CORE-164)
- !309 (CORE-274) More error messages relating to notification emails may be found in error logs due to legacy third party code.
- !318 Cherry-pick CORE-164 Behat set-up validation improvements (CORE-296)
This change introduces some validation when Behat tests are run to check the content of the data/config/plugins.json file against the db_installed database table. If these are different it can cause problems and errors in the page.
When there is a difference between the plugins.json and db_installed Behat will now output some information advising what information is in each and what appears to be installed normally.

## 8.6.0 - 12 Dec 2018

### New features

- !261 Bookmark page - User can now add link to bookmark easily via Add to Bookmark link from the top navigation bar.
- !265 Menu navigation (Disco 22054) - When top level menu doesn't contain URL, it is no longer clickable but still trigger to show sub level menu.
- !262 Current Interface Indicator - Design panel is now showing which interface that user is currently having so that editing incorrect theme can be avoided.
- !213 Hybrid breadrumb - Allows the user to go back to the referring app when a user lands on an article, document or
  user profile. An arrow is displayed to the left of the breadcrumb with the app referral.
- !251 News comments are now configurable  - Visit the Configuration tab in News Admin to change whether comments can
  be made on News Articles.
- !242 Global font setting  - The design panel now offers a selection of fonts to apply across the system for the
  master design and for individual themes.
- !230 User Import/Export with Manager ID - Users can now be imported and exported with manager IDs.
- !228 Search improvements
  - Search suggestions are shown when using the global search field in the navigation bar
  - Search API version 2 - Search API has been improved considerably
  - Global search and search suggestions now use fuzzy matching
- !272 Application menu colour - Added a design panel option for the colour of application menu items.
- !235 Environment variables - Many configuration options can now be set by environment variables.
- !270 OneSignal Push Notification Integration and Universal Links for mobile devices.
- !225 Redis session handling - Claromentis can now be configured to use redis as a session store, in order to
  share sessions between load-balanced servers. Sessions are locked during use, to avoid race conditions.
  All redis modes other than a single server running in "MASTER" mode are experimental, and should not be used on a production server.
- !217 Gravatar can now be used to show profile images for users that do not have one set. See "Admin -> People -> General Configuration" for the options.
- !298 Comment permalinks exposed the object name in the breadcrumb when the user no longer had permission to view the comment (CORE-190)
- !300 Fixed errors when adding a three menu date field to an InfoCapture form (CORE-151)

### Improvements

- !216 Theme image resizing - Logos and background images are now resized once uploaded
- !241 (Disco 021105) Improved which Holiday group managers are sent notifications for Holiday Requests and Cancellations
- !237 Groups and Role based permissions will update more promptly (caching is smarter and less aggressive)
- !247 (Disco 021717) Optimized the User Export page, mitigating unresponsiveness on systems with many Users and Metadata
- !257 (UIUX-47) Ensured that line-breaks in Calendar invite descriptions are maintained in notifications
- !256 Current theme indicator - In a system with multiple themes, there is now a label in the Design Panel's Themes
  list that indicates which theme you are currently using
- !259 (UIUX-81) Added image archive download buttons to Image Gallery album page
- !274 The card shadow option in the design panel has updated to a toggle with an icon, similar to other options
- !258 Color picker has been localised for the design panel and bright colors have been restricted for Primary, Secondary and Link colors
- !288 (UIUX-132) Added ability to change InfoCapture status highlighting.
- !271 Added the concept of module dependencies, so that disabling Tasks does not crash the system if Discuss is installed

### Bug fixes

- !309 (CORE-274) More error messages relating to notification emails may be found in error logs due to legacy third party code
- !276 Password Policy Fix - Strong passwords now need to include one lower,upper,digit and special char, password minimum length can be set from people admin.
- !218 (Disco 021325) Fixed power user permissions not being applied to the User List in People Admin
- !222 (Disco 021322) Fixed pagination and sort issues in the Power Users tab in People Admin
- !239 Calendar's "show conflicts" button now takes into account common and personal holidays
- Fixed system navbar notifications not working correctly in Calendar due to MooTools conflict
- !258 Fixed warnings in the Design Panel that occurred when entering shorthand or invalid hex codes for colors

### Breaking changes

- PHP compatibility has been changed from version `>=7.0.0 <7.1.0` to `>=7.0.0 <7.2.0`
- ORM dependency (Analogue) has been updated from 5.4.2 to 5.6.12 and its integration has been updated accordingly
- !229 DAL interfaces have been defined in `Claromentis\Core\DAL\Interfaces\*`, and the abstract `DAL\Db` implements them
- A new resize type (`'[*]'`) has been added to `Claromentis\Core\Imager\Driver\Driver` that letterboxes with a
  transparent fill
- The `Claromentis\Core\Templater\TemplateRunner` constructor signature has changed from `__construct($app = null)` to
  `__construct(Claromentis\Design\Facade\ActiveTheme $active_theme, $app = null)`
- `cla.ui_strip_message()` in `cla_lib.js` has been renamed to `cla.ui_strip_keys()`
- !270 IMessage::Send now takes an additional parameter, but it defaults to null.
- !270 Sending of messages now occurs in a transaction, so either all recipients recieve it, or none of them do.
- !228 Search API - The default version of the Search API has been changed to 2
- !271 PluginsRepository now manages the concept of dependencies, and any modules with a hard dependency should be updated to declare one (see the Discuss module for details)
- !271 PluginsRepository::GetStatus can now return PluginsRepository::STATUS_BLOCKED (4)
- !225 - the session is now always started when the framework is bootstrapped. This may affect the behaviour of
custom login handlers. Additionally, usage of php native session functions is now deprecated in favour of using
`$g_application->session`.

### Developer notes

- Added Services::I()->config magic property, for getting the core config object without using global variables.
- Deprecated httpRedirect() in http_functions.php. RedirectResponse::httpRedirect() should be used instead.
- Added PhpStorm code style config (`.idea/codeStyles/Project.xml`) - use it (`Ctrl + Alt + L`) to keep your code style
  consistent across the code-base
- Added GitLab merge request description templates (`.gitlab/merge_request_templates/*`) - use these to fill out and
  auto-tag your merge requests
- !226 Transaction support has been implemented for the DAL
- !125 ORM integration has been improved
  - People entities have been initially implemented and mapped (User, Group, Role, Extranet)
  - ACL plugin has been integrated, allowing mapper queries like `->whereCan($context, PERM_EDIT)` and
    `->wherePermission(PERM_CLASS_NEWS, $context, PERM_VIEW)` (`PERM_VIEW` is the default argument for rights)
  - `UserScope` has been applied to the new User mapper available in the `UserRepository`, allowing mapper queries like
    `->whereContext($app->security)` (Extranet visibility filter, active user only),
    `->withPermission(PERM_CLASS_NEWS, $object_id, PERM_VIEW)` (Users with permissions to a specific object) and
    `->whereInAcl($acl)` (match all users in the given ACL)
- !237 Group, Group Tree and Role session caches are now invalidated when these objects are changed
- !237 A new `user_timestamps` table has been added to track when each user last updated their session caches for Groups,
  Group Trees and Roles
- !238 Icon grid - Added an AngularJS directive to show a grid of icons to pick from as an alternative to the existing
  select-based picker
- All application names for admin panels the the application menu have been localized
- `Claromentis\Core\Config\ConfigDialog` now properly displays default values for config options when calling the
  `ShowOption($key)` method
- System fonts can now be set in the design panel, changing the font of nearly every textual item across the system
- News comments can now be toggled via config variable `$cfg_news_show_comments`
- !243 Behat step definitions have been implemented for interacting with date, time, colour and image pickers
  - `I fill in date picker "selector" with relative date "date" using format "format"`
  - `I fill in time picker "selector" with relative time "" using format ""`
  - `I fill in colour picker "selector" with "colour"`
  - `I press "selector" radio button`
- !248 Behat step definitions have been implemented for importing snapshots, running migrations and checking database tables:
  - `I import snapshot file "file name"`
  - `I execute migration using partial "partial name" or roll-up "roll-up name" for application "application code"`
  - `database table "table" should contain: <Table Data>`
  - `database table "table" should not contain: <Table Data>`
  - `database table "table" should contain "count" records`
- Added new method `ClaText::ProcessAvailableLocalisation()` to process localisation strings using the format `@{lmsg_key|default}`
- !260 Added unique index creation to migration interfaces
  - `$db->CreateUniqueIndex($table_name, $index_name, ...$columns)` is now available when writing migrations
