var gulp    = require('gulp');
var phpunit = require('gulp-phpunit');
var yargs = require('yargs');

var module = 'core';
if (typeof yargs.argv.module !== 'undefined')
	module = yargs.argv.module;

gulp.task('phpunit', function() {
	var options = {
		processIsolation: true
	};
	gulp.src('')
		.pipe(phpunit('./vendor_core/bin/phpunit --colors=always web/intranet/' + module, options, function(err, msg) {

			// null if no error
			// 1 if error
			if(err) {
				console.log('Error' + err);
			}
			console.log(msg);
		}));
});

gulp.task('default', ['phpunit']);

gulp.task('run', ['phpunit']);

gulp.task('watch', ['phpunit'], function() {
	gulp.watch('web/intranet/' + module + '/**/*.php', { debounceDelay: 2000 }, ['phpunit']);
});