@javascript @core @communication
Feature: Verify messages and notifications are handled correctly when a user has been deleted.

  Background:
    Given I am on a Claromentis site
    And the following people exist:
      | username | password | surname  | firstname | email                | manager  |
      | manager1 | password | Manager1 | Dave1     | manager1@example.com |          |
      | project1 | password | Project1 | Maggie1   | project1@example.com |          |
      | user1    | password | User1    | Bob1      | user1@example.com    | manager1 |
      | user2    | password | User2    | Bob2      | user2@example.com    | manager1 |
      | user3    | password | User3    | Bob3      | user3@example.com    | manager1 |
    And the following "user" messages exist:
      | sender   | receiver    | subject         | date               | message |
      | user1    | user2       | Bananas         | 14:10 Jan 2nd 2019 | Did you know bananas are a herb?               |
      | user2    | user1       | Bananas         | 14:11 Jan 2nd 2019 | Shut. Up.                                      |
      | user1    | user2       | Bananas         | 14:12 Jan 2nd 2019 | It's true.                                     |
      | user2    | user1       | Bananas         | 14:13 Jan 2nd 2019 | [Slams front door]                             |
      | user1    | user2       | Tomatoes        | 14:14 Jan 2nd 2019 | Did you know tomatoes are a fruit?             |
      | admin    | user1,user2 | Login Passwords | 16:08 Jan 3rd 2019 | Please remember to reset your login passwords. |
      | user1    | admin,user2 | Login Passwords | 09:14 Jan 4th 2019 | Remind me why we're doing this again...?       |
      | admin    | user1,user2 | Login Passwords | 09:18 Jan 4th 2019 | Bob2 wrote his password on a post-it and left it on the fridge. |
      | user1    | admin,user2 | Login Passwords | 10:26 Jan 5th 2019 | Great idea! How embarrassing! Haha.            |
      | user2    | user1,admin | Login Passwords | 10:31 Jan 5th 2019 | I swear it wasn't me.                          |
      | admin    | user1,user2 | Login Passwords | 10:33 Jan 5th 2019 | We're resetting password as a precaution.      |
    And the following "user" messages exist:
      | sender   | receiver                | subject          | date                | message |
      | project1 | manager1,user1,user2    | Prototype update | 10:15 Jan 10th 2019 | Hi Dave1. Any news on the Communication prototype?                 |
      | manager1 | project1,user1,user2    |                  | 10:30 Jan 10th 2019 | Yes, one of the Bobs was working on it. I get an update.           |
      | user1    | manager1,project1,user2 |                  | 10:40 Jan 10th 2019 | Just sent it over.                                                 |
      | project1 | manager1,user1,user2    |                  | 11:25 Jan 11th 2019 | Great, thanks. Give me half and hour to look over it.              |
      | project1 | manager1,user1,user2    |                  | 11:50 Jan 11th 2019 | Looks great. Let's look at more options with the team.             |
      | manager1 | project1,user1,user2    |                  | 11:55 Jan 11th 2019 | Good idea.                                                         |
      | user1    | manager1,project1,user2 |                  | 12:00 Jan 11th 2019 | I had another idea about and improvement for the bobbins.          |
      | user1    | manager1,project1,user2 |                  | 12:05 Jan 11th 2019 | https://thisissomething.com                                        |
      | user2    | manager1,project1,user1 |                  | 12:20 Jan 11th 2019 | I was thinking about that too. I've got a slightly different idea. |
      | manager1 | project1,user1,user2    |                  | 12:30 Jan 11th 2019 | Great work guys. Let's discuss in the meeting later.               |

  Scenario: Verify when a user is deleted the thread is still accessible.
  
    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "sent"
    And I logout
    
    When I login as an admin user
    And I am on "/intranet/panels/peopleadmin.php"
    And I click element with "(//input[@name='user_id[]'])[2]"
    And I follow "Delete selected"
    Then I should see "Users to delete"
    And I should see "Bob2 User2 (user2)"
    
    When I press "Submit"
    Then I should see "User was deleted successfully"
    But I should not see "Bob2 User2"
    And I logout
    
    When I login as user "user1" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "sent"
    And I should see "Deleted User"
    But I should not see "Bob2 User2"
    
    When I follow "Did you know tomatoes are a fruit?"
    Then I should see "Deleted User" in the ".users" element
    And I should see user message thread:
      | name         | subject  | date         | message                            |
      |              | Tomatoes | Jan 2nd 2019 | Did you know tomatoes are a fruit? |
      | Deleted User | Bananas  |              | [Slams front door]                 |
      |              |          |              | It's true.                         |
      | Deleted User |          |              | Shut. Up.                          |
      |              |          |              | Did you know bananas are a herb?   |
  
  Scenario: Verify when a user is deleted only notifications deleted by all participating users are deleted.
  
    # Given permission for Dave1 Manager1 to send notifications.
    Given I login as an admin user
    When I am on "/intranet/communication/admin.php"
    And I set permissions for "User: Dave1 Manager1"
    And I press "Apply permissions"
    Then I should see "Permissions Updated"
    And I logout
    
    # Login as Dave1 Manager1 to send a notification.
    When I login as user "manager1" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    
    When I click element with "#compose-message"
    And I wait to see "Compose New Message"
    And I press "Notification" radio button
    And I click element with "#my-team" using jQuery
    And I fill in "Subject" with "Company Announcement"
    And I fill in field "new_message_text" with rich content:
    """
    <p>Unfortunately, due to cuts, the company will no longer provide paper-clips.</p>
    """
    And I press "Send"
    Then I should see "Your message was sent"
    
    # Create a calendar event to generate a notification.
    When I open the calendar
    And I click element with ".fc-today"
    And I follow "More options"
    Then I should see "Add/Edit event"
    
    When I fill in "Name" with "Meeting 1"
    And I fill in "Description" with "This is a description of Meeting 1"
    And I press "Add user"
    Then I should see "Pick user"
    
    When I check element "#pu_keyword_0" exists
    And I fill in "Keyword" with "User"
    Then I wait to see "Bob1 User1"
    
    When I select "Bob1 User1" from "pu_select_0"
    And I additionally select "Bob2 User2" from "pu_select_0"
    And I press "Add selected"
    And I press "Submit"
    Then I wait to see "Event saved successfully"
    And I wait to see "Meeting 1"
    And I logout
    
    # Login as Bob1 User1 and mark the messages as deleted.
    When I login as user "user1" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    
    # Read the notifications.
    When I am on "/intranet/communication/imessageread.php"
    And I follow "Calendar Event Invitation: Meeting 1"
    And I pause for a second
    And I follow "Company Announcement"
    And I pause for a second
    And I click element with "(//input[@name='selected[]'])[1]"
    And I click element with "(//input[@name='selected[]'])[2]"
    And I press "Delete selected"
    And I pause for a second
    And I press "Submit"
    Then I should see "Deleted"
    And I logout
    
    # Login as admin and delete Bob1 User 1.
    When I login as an admin user
    And I am on "/intranet/panels/peopleadmin.php"
    And I click element with "(//input[@name='user_id[]'])[5]"
    And I follow "Delete selected"
    Then I should see "Users to delete"
    And I should see "Dave1 Manager1 (manager1)"
    
    When I press "Submit"
    Then I should see "User was deleted successfully"
    But I should not see "Dave1 Manager1"
    And I logout
    
    # Verify this user's messages are not affected.
    When I login as user "user2" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "unread"
    
    # Verify this users notifications are not affected.
    When I am on "/intranet/communication/imessageread.php"
    Then I should see "Calendar Event Invitation: Meeting 1"
    And I should see "Company Announcement"

  Scenario: Verify starting a conversation from a notification where the user has been deleted is handled correctly.
    
    # Given permission for Dave1 Manager1 to send notifications.
    Given I login as an admin user
    When I am on "/intranet/communication/admin.php"
    And I set permissions for "User: Dave1 Manager1"
    And I press "Apply permissions"
    Then I should see "Permissions Updated"
    And I logout

    # Login as Dave1 Manager1 to send a notification.
    When I login as user "manager1" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I wait to see "Compose New Message"
    And I press "Notification" radio button
    And I click element with "#my-team" using jQuery
    And I fill in "Subject" with "Company Announcement"
    And I fill in field "new_message_text" with rich content:
    """
    <p>Unfortunately, due to cuts, the company will no longer provide drink coasters.</p>
    """
    And I press "Send"
    Then I should see "Your message was sent"
    And I logout

    # Login as admin and delete Bob1 User 1.
    When I login as an admin user
    And I am on "/intranet/panels/peopleadmin.php"
    And I click element with "(//input[@name='user_id[]'])[5]"
    And I follow "Delete selected"
    Then I should see "Users to delete"
    And I should see "Dave1 Manager1 (manager1)"

    When I press "Submit"
    Then I should see "User was deleted successfully"
    But I should not see "Dave1 Manager1"
    And I logout

    # Verify this user's messages are not affected.
    When I login as user "user1" with password "password"
    And I open the notifications menu
    Then I should see a "communication" notification from "" with subject "Company Announcement" containing:
    """
    <p>Unfortunately, due to cuts, the company will no longer provide drink coasters.</p>
    """
    And I should see "Start conversation"

    When I follow "Start conversation"
    And I pause for a second
    Then I should see "Compose New Message"
    And the "new_message_subject" field should contain "Company Announcement"

    When I press "Send"
    Then I should see "Add at least 1 recipient"
