<?php
namespace Claromentis\Config\Tests\Unit;

$GLOBALS["__747345b14dfb85fd894a44969c" . "c28ee8"] = (@$GLOBALS["__747345b14dfb85fd894a44969cc28ee" . "8"] ?: array()) + array("_208892c0" . "6a52ff62b" . "baa777060" . "ff5c79" => base64_decode("JF9FTlYgbm90IGRlZmluZWQsIHNraXBwaW5nIHR" . "lc3RzIHRoYXQgcmVxdWlyZSBpdA=="), "_87daa84e346f6420a3f3426e05d16" . "a7b" => base64_decode("Lw" . "=="), "_63e4dbd0d3f48380888753a5" . "52891634" => base64_decode("RW52aXJvbm1l" . "bnRzIGFyZSBp" . "bW11dGFibGU="), "_8e09c58" . "0f3951d0" . "a65a8025" . "dbef2631" . "4" => base64_decode("Q0xBUk" . "9f"), "_4d707fab93bebb00bbe69e8" . "159697c90" => base64_decode(""), "_8a36a84baeffc0085672f" . "9bf9c064f67" => base64_decode("ZmlsZV9wdXR" . "fY29udGVudH" . "M="), "_c61584fc3580dd88e33" . "b6fb5cfbc0325" => base64_decode("bWt" . "kaX" . "I="), "_666c743b2c0bf8c9253c" . "fb368bb16fbb" => base64_decode("X0ZJT" . "EU="), "_f67a7d77bc" . "266c012bc96" . "b81153a32e1" => base64_decode("dW5sa" . "W5r"), "_1fdd8f9b667088592aae1b98" . "bc28b864" => base64_decode("cm1kaX" . "I="), "_b2ed704ac3f86a8" . "160456dd14c44328" . "0" => base64_decode("c3lzX2dldF90ZW1wX2R" . "pcg=="), "_a8c494d8a687400d860d06" . "4c77d7f215" => base64_decode("LnR" . "tcA" . "=="));
use Claromentis\Core\Config\Environment;
use Claromentis\Core\Util\RandomUtil;
class EnvironmentTest extends \PHPUnit_Framework_TestCase
{
protected static $has_env;
public function __construct(string $name = null, array $data = array(), string $_07d54f9ffc86f5299cb34ee1627e8301 = '')
{
parent::__construct($name, $data, $_07d54f9ffc86f5299cb34ee1627e8301);
}
public static function setUpBeforeClass()
{
static::$has_env = isset($_ENV);
}
protected function setUp()
{
Environment::ResetEnvironment();
}
public function testGettingASetEnvironmentVariable()
{
$_878cefab5f34c46398cf9e4f527fc76b = $this->RandomArrayWithPrefix(5, $GLOBALS["__747345b14dfb85fd894a44969cc28e" . "e8"]["_8e09c580f3951d0a6" . "5a8025dbef26314"]);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testGettingAnEnvironmentVariableWithoutPrefixIsNull()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(5);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertNull($_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testUsingAPrefixWorksAsExpected()
{
$prefix = RandomUtil::RandomString(10);
$_fd6cd118374f31ddb80d1343275189c2 = $this->RandomArrayWithPrefix(5, $prefix);
$_a22bd43e79b7fd9513c938beaf9a2d61 = RandomUtil::RandomArray(5);
$_878cefab5f34c46398cf9e4f527fc76b = $_fd6cd118374f31ddb80d1343275189c2 + $_a22bd43e79b7fd9513c938beaf9a2d61;
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $prefix);
foreach ($_fd6cd118374f31ddb80d1343275189c2 as $key => $value) {
self::assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
foreach ($_a22bd43e79b7fd9513c938beaf9a2d61 as $key => $value) {
self::assertNull($_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testUsingABlankPrefixWorksAsExpected()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(10);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__747345b14dfb85fd894a4" . "4969cc28ee8"]["_4d707fab93" . "bebb00bbe69" . "e8159697c90"]);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testClearingEnvironmentWorks()
{
$this->CheckEnv();
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(10);
$_ENV = $_878cefab5f34c46398cf9e4f527fc76b;
Environment::ClearGlobals();
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertNull($_ENV[$key] ?? null);
}
}
public function testCreatingFromGlobalsAfterClearingGlobals()
{
$this->CheckEnv();
$_878cefab5f34c46398cf9e4f527fc76b = $this->RandomArrayWithPrefix(10, $GLOBALS["__747345b14dfb85fd894a44969cc28e" . "e8"]["_8e09c580f3951d0a65a8025db" . "ef26314"]);
$_ENV = $_878cefab5f34c46398cf9e4f527fc76b;
Environment::ClearGlobals();
$_54fa8523f2845872533bfb14523f79ed = Environment::CreateFromGlobals();
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testCreateAndClearWorksAsExpected()
{
$this->CheckEnv();
$_878cefab5f34c46398cf9e4f527fc76b = $this->RandomArrayWithPrefix(10, $GLOBALS["__747345b14dfb85fd894a44969cc28ee" . "8"]["_8e09c580f3951d" . "0a65a8025dbef26" . "314"]);
$_ENV = $_878cefab5f34c46398cf9e4f527fc76b;
$_54fa8523f2845872533bfb14523f79ed = Environment::CreateAndClear();
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
$this->assertNull($_ENV[$key] ?? null);
$this->assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testGettingAnUnsetEnvironmentVariableIsNull()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(5);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__747345b14dfb" . "85fd894a44969c" . "c28ee8"]["_4d707fab93bebb00bbe69e8159697c9" . "0"]);
$this->assertNull($_54fa8523f2845872533bfb14523f79ed->Get(RandomUtil::RandomString(25)));
}
public function testUsingArrayAccessWorks()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(5);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__747345b14dfb85fd894a44969c" . "c28ee8"]["_4d707fab93beb" . "b00bbe69e81596" . "97c90"]);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
$this->assertEquals($value, $_54fa8523f2845872533bfb14523f79ed[$key]);
}
$this->assertNull($_54fa8523f2845872533bfb14523f79ed[RandomUtil::RandomString(25)]);
}
public function testSettingAnEnvironmentVariableFails()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(1);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__747345b14dfb8" . "5fd894a44969cc2" . "8ee8"]["_4d707fa" . "b93bebb0" . "0bbe69e8" . "159697c9" . "0"]);
$this->setExpectedException(\LogicException::class, $GLOBALS["__747345b14dfb85fd894a44969cc28e" . "e8"]["_63e4dbd0d3f48380888753a5528916" . "34"]);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
$_54fa8523f2845872533bfb14523f79ed[$key] = RandomUtil::RandomString(25);
}
}
public function testUnsettingAnEnvironmentVariableFails()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(1);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__747345b14dfb85fd894a4496" . "9cc28ee8"]["_4d707fab9" . "3bebb00bbe" . "69e8159697" . "c90"]);
$this->setExpectedException(\LogicException::class, $GLOBALS["__747345b14dfb85fd" . "894a44969cc28ee8"]["_63e4dbd0d3f48380888753a5" . "52891634"]);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
unset($_54fa8523f2845872533bfb14523f79ed[$key]);
}
}
public function testGettingAFileBasedKey()
{
$_bd6c5af75f2d077802c58e7b8ca0dbe5 = RandomUtil::RandomString(100);
$_201a9d78bb118788803a451b506587df = RandomUtil::RandomString();
$_0ffe47b8d085d3dd889c49a616fabfb1 = $GLOBALS["__747345b14dfb85fd894a" . "44969cc28ee8"]["_b2ed704ac3f86a8160456d" . "d14c443280"]();
$_0ffe47b8d085d3dd889c49a616fabfb1 .= $GLOBALS["__747345b14d" . "fb85fd894a44" . "969cc28ee8"]["_87daa84e" . "346f6420a" . "3f3426e05" . "d16a7b"] . RandomUtil::RandomString(10);
$GLOBALS["__747345b14dfb85fd894a4" . "4969cc28ee8"]["_c61584fc3580dd88e33b6fb5cfbc032" . "5"]($_0ffe47b8d085d3dd889c49a616fabfb1);
$_095e37c5e2614300a0402b5bbcd7fb8d = RandomUtil::RandomString(10) . $GLOBALS["__747345b14dfb85fd894a449" . "69cc28ee8"]["_a8c494d8a68740" . "0d860d064c77d7f" . "215"];
$_93469c9375390f862eebb779f8b740e4 = $_0ffe47b8d085d3dd889c49a616fabfb1 . $GLOBALS["__747345b14dfb85fd894a44969cc" . "28ee8"]["_87daa84e346f6420a3f3426e05d16a" . "7b"] . $_095e37c5e2614300a0402b5bbcd7fb8d;
$GLOBALS["__747345b14d" . "fb85fd894a44" . "969cc28ee8"]["_8a36a84bae" . "ffc0085672f" . "9bf9c064f67"]($_93469c9375390f862eebb779f8b740e4, $_bd6c5af75f2d077802c58e7b8ca0dbe5);
$_54fa8523f2845872533bfb14523f79ed = new Environment([$_201a9d78bb118788803a451b506587df . $GLOBALS["__747345b14df" . "b85fd894a4496" . "9cc28ee8"]["_666c743b2c0bf8c9253cf" . "b368bb16fbb"] => $_93469c9375390f862eebb779f8b740e4], $GLOBALS["__747345b14dfb85fd89" . "4a44969cc28ee8"]["_4d707fab93bebb00bbe69e815969" . "7c90"]);
self::assertEquals($_bd6c5af75f2d077802c58e7b8ca0dbe5, $_54fa8523f2845872533bfb14523f79ed->Get($_201a9d78bb118788803a451b506587df));
$GLOBALS["__747345b14dfb85fd894a4496" . "9cc28ee8"]["_f67a7d77bc266c01" . "2bc96b81153a32e1"]($_93469c9375390f862eebb779f8b740e4);
$GLOBALS["__747345b14df" . "b85fd894a4496" . "9cc28ee8"]["_1fdd8f9b667088592aae1b98bc" . "28b864"]($_0ffe47b8d085d3dd889c49a616fabfb1);
}
public static function RandomArrayWithPrefix(int $_827a4ce5f334e525c32838c58787f831, string $prefix)
{
$_5043281dccab7305623dcecfd2fb2b63 = RandomUtil::RandomArray($_827a4ce5f334e525c32838c58787f831);
$_e8180e518b009dc0ea8c578fe193c4ae = [];
foreach ($_5043281dccab7305623dcecfd2fb2b63 as $key => $value) {
$_e8180e518b009dc0ea8c578fe193c4ae[$prefix . $key] = $value;
}
return $_e8180e518b009dc0ea8c578fe193c4ae;
}
protected function CheckEnv()
{
if (!static::$has_env) {
$this->markTestSkipped($GLOBALS["__747345b14dfb85" . "fd894a44969cc28e" . "e8"]["_208892c06a52ff62bbaa777" . "060ff5c79"]);
}
}
}