<?php
namespace Claromentis\Design\Facade;

$GLOBALS["__823390e6c6" . "b270e1aa1714" . "1ab4a89ab8"] = (@$GLOBALS["__823390e6c6b270e1" . "aa17141ab4a89ab8"] ?: array()) + array();
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Design\Model\Theme;
use Claromentis\Design\Repository\ThemeRepository;
use Claromentis\Design\Style\StyleOptions;
use Claromentis\Design\ThemeStyleInterface;
use Symfony\Component\HttpFoundation\Session\SessionInterface;





class ActiveTheme
{
protected $session;
protected $theme_repo;
const SESSION_VI_KEY = 'SESSION_skin';
const SESSION_THEME_KEY = 'SESSION_theme';
protected $theme_style;
protected $local_theme;
protected $local_vi;
protected $guest_theme;
public function __construct(ThemeRepository $theme_repo, SessionInterface $session, ThemeStyleInterface $theme_style, string $_792c8af5d2613494a683b28207c00b5b)
{
$this->session = $session;
$this->theme_repo = $theme_repo;
$this->theme_style = $theme_style;
$this->guest_theme = $_792c8af5d2613494a683b28207c00b5b;
}
public function SetTheme(Theme $theme)
{
$this->local_theme = null;
$this->local_vi = null;
$this->session->set(self::SESSION_VI_KEY, $theme->base_vi);
$this->session->set(self::SESSION_THEME_KEY, $theme->GetCode());
}





public function SetLocalTheme(Theme $theme)
{
$this->local_vi = $theme->base_vi;
$this->local_theme = $theme->GetCode();
}
public function SetThemeByCode($theme_code)
{
try {
$theme = $this->theme_repo->GetByCode($theme_code);
$this->SetTheme($theme);
} catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
}
}
public function GetThemeCode()
{
$theme_code = $this->session->get(self::SESSION_THEME_KEY);



if ($theme_code === null) {
$theme_code = $this->guest_theme;
}
return $this->local_theme ?? $theme_code;
}
public function GetVi()
{
return $this->local_vi ?? $this->session->get(self::SESSION_VI_KEY);
}




public function GetThemeStyle()
{
try {
$theme = $this->theme_repo->GetByCode($this->GetThemeCode());
} catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
$theme = new Theme();
}
return $this->theme_style->GetStyle($theme);
}
}