require(
    [
        '/intranet/documents/js/editor/protocolcheck.js',
        '/intranet/documents/js/editor/platform.js'
    ],
    function (protocolCheck, platform) {
        var appName = 'Claromentis Document Check Out Utility';
        var appDownloadBaseUrl = 'https://apps.claromentis.net/checkout/';


        function checkIfClaromentisEditorIsInstalled() {
            var as = document.getElementsByTagName('a');
            var r = new RegExp('^\s*claromentis', 'i');
            for (var i = 0; i < as.length; i++) {
                var m = as[i].href.match(r);
                if (m) {
                    as[i].addEventListener('click', function (e) {
                        protocolCheck(this.getAttribute('href'),
                            function (q) {
                                if (!confirm('To perform this action, you need to install ' + appName + ' application on your computer. Would you like to proceed with it?'))
                                    return;
                                var os = platform.os.family + ' ' + platform.os.version;
                                //alert(os);
                                var downloadUrl;
                                if (os.match(/windows/i))
                                    downloadUrl = 'ClaromentisCheckOutUtility.Setup.exe';
                                else if (os.match(/^OS\s/i))
                                    downloadUrl = 'ClaromentisCheckOutUtility.pkg';
                                else {
                                    alert('Unfortunately, ' + (os ? os : 'the OS on your computer') + ' seems not to be supported yet. Please contact the site administrator to resolve the issue.');
                                    return;
                                }
                                downloadUrl = appDownloadBaseUrl + downloadUrl;
                                document.location = downloadUrl;
                            }
                        );
                        e.preventDefault ? e.preventDefault() : e.returnValue = false;
                    });
                }
            }
        }

        checkIfClaromentisEditorIsInstalled();
    }
);
