/**
 * View for list of documents for approval
 */
var ApprovalsView = Backbone.View.extend({

	el : '#awaiting_approval',
	collection : new ApprovalsCollection(),

	initialize : function() {
		this.setCollection(new ApprovalsCollection());


	},

	events : {
		"click a[name='publish']" : "approve",
		"click a[name='reject']": "reject"
	},

	approve : function(element){
		var doc = this.collection.get($(element.currentTarget).data('doc-id'));
		if (confirm(lmsg('documents.misc.doc_approve_confirm'))){
			// show working spinner
			element.target.childNodes[0].classList = 'loading_bg';
			var url = '/intranet/rest/documents/document/' + doc.get('doc_id') + '/' + doc.get('version_num') + '/approve/?parent_id=' + doc.get('parent_id');
			$.ajax({
				type: 'PUT',
				url: url,
				success: function(data){
					cla.showMessage(lmsg('documents.misc.doc_approve_success'), '', 'info');
					list_view.load(docs_list_state.get('folder_id'), 0, list_view.pagesize);
					element.target.childNodes[0].classList = 'glyphicons glyphicons-check';
					refreshDraftViews();
				},
				error: function(jqXHR, message, thrown){
					element.target.childNodes[0].classList = 'glyphicons glyphicons-check';
					cla.showMessage(message, '', true);
				}
			});
		}
		return false;
	},

	reject : function(element){
		var doc = this.collection.get($(element.currentTarget).data('doc-id'));
		var url = '/intranet/rest/documents/document/' + doc.get('doc_id') + '/' + doc.get('version_num') + '/?draft=1&is_rejection=1';
		if (confirm(lmsg('documents.misc.doc_delete_confirm'))) {
			element.target.childNodes[0].classList = 'loading_bg';
			$.ajax({
				type: 'DELETE',
				url: url,
				success: function (data) {
					cla.showMessage(lmsg('documents.misc.doc_delete_success'), '', 'info');
					list_view.load(docs_list_state.get('folder_id'), 0, list_view.pagesize);
					element.target.childNodes[0].classList = 'glyphicons glyphicons-remove';
					refreshDraftViews();
				},
				error: function (jqXHR, message, thrown) {
					element.target.childNodes[0].classList = 'glyphicons glyphicons-remove';
					cla.showMessage(message, '', true);
				}
			});
		}
	},

	render : function() {
		if (!this.collection.is_loaded || this.collection.length == 0){
			this.setVisible(false);
		}
		else
		{
			$('#drafts_listings').show();
			this.$el.show();
			var template = _.template($('#approvals_template').html());
			this.$('#approval_items').empty();
			this.collection.each(function(doc, index) {
				var data = {};
				data.parent_id = doc.get('parent_id');
				data.doc_id = doc.get('doc_id');
				data.file_name = doc.get('title');
				data.can_approve = doc.get('can_approve');
				data.can_delete = doc.get('can_delete');
				data.icon = claIcon(doc.get('title'));
				this.$('#approval_items').append(template(data));
			}, this);
		}
	},


	setVisible : function(visible) {
		if (visible) {
			if (!this.collection.is_loaded)
				this.collection.load();
			this.render();
		} else
			this.$el.hide();
	},

	setCollection : function(collection) {
		if (this.collection) {
			this.collection.unbind('change', this.render, this);
			this.collection.unbind('reset', this.render, this);
			this.collection.unbind('remove', this.render, this);
			this.collection.unbind('add', this.render, this);
		}

		this.collection = collection;
		this.collection.bind('change', this.render, this);
		this.collection.bind('reset', this.render, this);
		this.collection.bind('remove', this.render, this);
		this.collection.bind('add', this.render, this);
	}
});
