// ==============================================================================================

var ListActionsView = Backbone.View.extend({
	el: '#docsListOtherActions',
	docs_list_state: null,


	events: {
		'click #otherActionsAddFolder' : 'otherActionsAddFolder',
		'click #otherActionsAddDoc' : 'otherActionsAddDoc',
		'click #otherActionsAddGDocLink' : 'otherActionsAddGDocLink',
		'click #otherActionsAddOneDriveLink' : 'otherActionsAddOneDriveLink',
	},

	initialize : function() {
	    ui_settings.permission.bind('change', this.render, this);
	},

	render: function ()
	{
		this.$el.empty();
		var template = _.template($('#other_actions_template').html());
		var add_doc = ui_settings.permission.get('add_doc');
		var add_folder = ui_settings.permission.get('add_folder');
		var add_gdoc = ui_settings.permission.get('add_folder') && ui_settings.permission.get('add_doc');
		var add_onedrive = add_gdoc;
		var draft_only = ui_settings.permission.get('draft_only');
		var is_root = ui_settings.permission.get('is_root');
		this.$el.append(template({
			id: this.docs_list_state.get('folder_id'),
			can_add_doc: add_doc,
			can_add_folder: add_folder,
			can_add_gdoc: add_gdoc,
			can_add_onedrive: add_onedrive,
			is_root: is_root
		}));

		$('#addDocument input[name=fid]').val(this.docs_list_state.get('folder_id'));

	},

	setDocsListStateModel: function (docs_list_state)
	{
		this.docs_list_state = docs_list_state;
		docs_list_state.bind('change', this.render, this);
	},


	otherActionsAddFolder: function()
	{
		if (this.docs_list_state.get('folder_id') == 0)
		{
			window.location.href = '/intranet/documents/add_folder.php?parent_id=0';
			return false;
		}

		if (ui_settings.permission.get('mandatory_metadata') == 1)
		{
			// forward to detailed folder creation page
			window.location.href = '/intranet/documents/add_folder.php?parent_id=' + this.docs_list_state.get('folder_id');
			return false;
		}

		var el = $('#addFolderPopup');
		el.on('hidden.bs.modal', function () {$('#confirmAddFolder', el).off('click');el.off('hide');});

		$('#modal-body', el).find('span').remove();
		$('input[name=parent_id]', el).val(this.docs_list_state.get('folder_id'));
		$('input[name=folder_title]', el).val('');
		$('#otherActionsAddFolderResponse').hide();

		el.modal('show');

		$('#confirmAddFolder', el).on('click', function() {
			var el = $('#addFolderPopup');
			var parent_id = $('input[name=parent_id]', el).val();
			var data = {};
			data.title = $('input[name=folder_title]', el).val();
			data = JSON.stringify(data);

			$.post('/intranet/rest/documents/folder/' + parent_id + '/folders/', data).complete(function(response) {
				if (response.status >= 200 && response.status < 300)
				{
					list_view.load(parent_id, 0, list_view.pagesize);
					$('#addFolderPopup').modal('hide');
					docsShowMessage(lmsg('documents.list_actions_view.folder_created'), 'success');
				} else
				{
					$('#otherActionsAddFolderResponse').text(response.responseText).show();
				}
			});
			return false;
		});
		return false;
	},

	otherActionsAddDoc: function(event)
	{
		// If there are required metadata and this function was not called from the ajax uploader then 
		// set this variable to 1 so the user will be prompted by the detailed upload page after clicking add document
		var detail_upload = 0;
		if (dms_options['show_full_metadata'] && jQuery(event.element).attr("id") != "ajax_uploader") {
			detail_upload = 1;
		}

		var el = $('#addDocumentPopup');
		$('input[name=fid]', el).val(this.docs_list_state.get('folder_id'));
		// show or hide based on permissions here.
		var draft_only = ui_settings.permission.get('draft_only');
		$('input[name=detail_upload]', el).val(detail_upload);

		if(draft_only)
		{
			$('#draft_only_notify').show();
			$('#fg_draft_select').hide();
		}
		else
		{
			$('#draft_only_notify').hide();
			$('#fg_draft_select').show();
		}
		el.modal('show');

		return false;
	},

	otherActionsAddGDocLink: function(event)
	{
		$(event.target).parent().parent().parent().removeClass('open');

		var el = $('#addGDocLinkPopup');
		$('input[name=fid]', el).val(this.docs_list_state.get('folder_id'));
		$('#add_gdoc_link_form').validate();
		el.modal('show');

		return false;
	},
	
	otherActionsAddOneDriveLink: function(event)
	{
		$(event.target).parent().parent().parent().removeClass('open');

		/*var el = $('#addOneDriveLinkPopup');
		$('input[name=fid]', el).val(this.docs_list_state.get('folder_id'));
		$('#add_gdoc_link_form').validate();
		el.modal('show');*/

		//return false;
	}

});