jQuery(document).ready(function(){
	jQuery('#day_part').on('change', toggleHalfDayNotification);
	hpDayTypeChanged();
});

end_date_is_entered_by_user = false;
HpStartDateChanged = function()
{
	if (!jQuery('#end_date').prop('disabled') && (jQuery('#end_date').val() == '' || !end_date_is_entered_by_user))
	{
		jQuery('#end_date').val(jQuery('#start_date').val());
		end_date_is_entered_by_user = false;
	}
};

HpDurationSelected = function(days)
{
	if (days > 0)
	{
		jQuery("#end_date").prop('disabled', true).val('N/A')
	}
	else
	{
		jQuery("#end_date").prop('disabled', false).val(jQuery('#start_date').val());
	}
};

toggleHalfDayNotification = function()
{
	var hideNotification = jQuery('#day_part').find('option:selected').val() == 1;

	jQuery("#halfDayNotification").toggleClass('hide', hideNotification);
};

hpDayTypeChanged = function()
{
	if (day_type_data === null || day_type_data.length === 0) return;

	var day_data = day_type_data[jQuery('#day_type').val()];
	if (!day_data)
		day_data = [1,1];

	if (day_data[0]) { // half days allowed
		jQuery("#day_part_").show();
	}
	else {
		jQuery("#day_part_").hide();
		jQuery("#day_part").val(1);
	}

	toggleHalfDayNotification();

	if (day_data[1]) { // user comment is mandatory
		jQuery("#comment").attr('required', 'true');
		jQuery("#comment_mand_ind").show();
	}
	else {
		jQuery("#comment").removeAttr('required');
		jQuery("#comment_mand_ind").hide();
	}
};

HpEditRequest = function(id, link)
{
	var f = document.forms["edit_request"];
	f.elements["id"].value = id;
	f.elements["start_date"].value=real_values[id]["date_start"];
	f.elements["end_date"].value=real_values[id]["date_end"];
	f.elements["day_type"].value=real_values[id]["leave_type"];
	f.elements["day_type"].disabled=true;
	f.elements["comment"].value=real_values[id]["comment_text"];
	f.elements["user_id"].value=real_values[id]["user_id"];
	f.elements["day_part"].value=real_values[id]["day_part"];
	jQuery('#holiday_request_popup').modal();
	hpDayTypeChanged();
	return false;
};

HpDeleteRequest = function(id, link)
{
	if (confirm(lmsg('common.areyousure'))) return SendByPost(link);
	else return false;
};

HpCancelRequest = function(id, link)
{
	if (confirm(lmsg('common.areyousure'))) return SendByPost(link);
	else return false;
};
