@javascript @core @infocapture
Feature: Verify an InfoCapture project can be created and populated.

  Background:
	Given I am on a Claromentis site
	And the following people exist:
	  | username   | password | surname    | firstname | email                |
	  | user1      | password | User1      | Bob1      | user1@example.com    |
	  | user2      | password | User2      | Bob2      | user2@example.com    |
	  | user3      | password | User3      | Bob3      | user3@example.com    |
	  | user4      | password | User4      | Bob4      | user4@example.com    |
	  | manager1   | password | Manager1   | Dave1     | manager1@example.com |
	  | project1   | password | Project1   | Maggie1   | project1@example.com |
	And the following InfoCapture project exists:
	  | Name   			      | My InfoCapture Project                     |
	  | Status            | Active                                     |
	  | Purpose           | This is the purpose of the project.        |
	  | Short description | A short description.                       |
	  | Full description  | This is a full description of the project. |
	  | Icon 			        | glyphicons-exclamation-sign                |
	  | Icon colour		    | #ff0000                                    |
	  | Codename		      | myproject                                  |
	And the following form for InfoCapture project "My InfoCapture Project" exists:
	  | Name         | Type                | Default                         | Required | Other | Items |
	  | Name         | medium string       | {user:firstname} {user:surname} | Yes      | text  |       |
	  | Email        | medium string       | {user:emailad}                  | Yes      | email |       |
	  | Department   | select              |                                 | Yes      |       | Human Resources, Design, Product, Support, Sales, Marketing |
	  | Ticket type  | radio               | Question                        | Yes      |       | Problem, Question, Request |
	  | Urgency      | radio               | Low                             | Yes      |       | Critical, High, Medium, Low |
	  | Summary      | medium string       |                                 | Yes      |       |       |
	  | Description  | long text           |                                 |          |       |       |
	  | Related URL  | medium string       |                                 |          |       |       |
	  | Problem area | multiple checkboxes |                                 | Yes      |       | Technical fault, Usability, Documentation, Performance |
	And the following tickets for InfoCapture project "My InfoCapture Project" exist:
	  | Created       | Updated  | Status   | Name             | Email                | Department      | Ticket type | Urgency | Summary                      | Problem area               |
	  | 1st Jan       | 2nd Jan  | New      | Bob1 User1       | user1@example.com    | Human Resources | Problem     | High    | Unable to do something       | Technical fault            |
	  | 3rd Feb       | 9th Feb  | Progress | Bob2 User2       | user2@example.com    | Design          | Request     | Medium  | Information Missing          | Documentation              |
	  | 5th Mar       | 8th Mar  | Closed   | Bob3 User3       | user3@example.com    | Support         | Problem     | High    | Slow Page Load               | Usability, Performance     |
	  | 7th Apr       |          | Progress | Bob4 User4       | user4@example.com    | Marketing       | Question    | Low     | How do you make an intranet? | Documentation              |
	  | 9th May       |          | Progress | Dave1 Manager1   | manager1@example.com | Support         | Question    | High    | Can I turn it on and off?    | Technical fault            |
	  | 11th Jun      | 12th Jun | Closed   | Maggie1 Project1 | project1@example.com | Product         | Problem     | Medium  | Difficult to use             | Usability                  |
	  | 13th Jul      |          |          | Dave1 Manager1   | manager1@example.com | Support         | Request     | Low     | Thing Refuses to Start       | Technical fault, Usability |

	When I login as an admin user
	And I open the modules menu
	And I follow "InfoCapture"
	And I follow "My InfoCapture Project"

  Scenario: Verify data has populated correctly.

	Given I follow "000001"

	# Check the standard fields are correct.
	Then I should see "000001" in the ".main-panel" element
	And I should see "New" in the ".main-panel" element
	# Don't test the year in the date as it's a relative date (and therefore year).
	And I should see "01-01-" in the ".main-panel" element
	And I should see "02-01-" in the ".main-panel" element

	# Check the custom fields are correct.
	And I should see "Bob1 User1" in the ".main-panel" element
	And I should see "user1@example.com" in the ".main-panel" element
	And I should see "Human Resources" in the ".main-panel" element
	And I should see "Problem" in the ".main-panel" element
	And I should see "High" in the ".main-panel" element
	And I should see "Unable to do something" in the ".main-panel" element
	And I should see "Technical fault" in the ".main-panel" element

	When I move backward one page
	And I follow "000002"
	Then I should see "000002" in the ".main-panel" element

	And I should see "03-02-" in the ".main-panel" element
	And I should see "09-02-" in the ".main-panel" element
	And I should see "Progress" in the ".main-panel" element
	And I should see "Bob2 User2" in the ".main-panel" element
	And I should see "user2@example.com" in the ".main-panel" element
	And I should see "Design" in the ".main-panel" element
	And I should see "Request" in the ".main-panel" element
	And I should see "Medium" in the ".main-panel" element
	And I should see "Information Missing" in the ".main-panel" element
	And I should see "Documentation" in the ".main-panel" element

	When I move backward one page
	And I follow "000003"
	Then I should see "000003" in the ".main-panel" element
	And I should see "05-03-" in the ".main-panel" element
	And I should see "08-03-" in the ".main-panel" element
	And I should see "Closed" in the ".main-panel" element
	And I should see "Bob3 User3" in the ".main-panel" element
	And I should see "user3@example.com" in the ".main-panel" element
	And I should see "Support" in the ".main-panel" element
	And I should see "Problem" in the ".main-panel" element
	And I should see "High" in the ".main-panel" element
	And I should see "Slow Page Load" in the ".main-panel" element
	And I should see "Usability, Performance" in the ".main-panel" element

	When I move backward one page
	And I follow "000004"
	Then I should see "000004" in the ".main-panel" element
	And I should see "07-04-" in the ".main-panel" element
	And I should see "In Progress" in the ".main-panel" element
	And I should see "Bob4 User4" in the ".main-panel" element
	And I should see "user4@example.com" in the ".main-panel" element
	And I should see "Marketing" in the ".main-panel" element
	And I should see "Question" in the ".main-panel" element
	And I should see "Low" in the ".main-panel" element
	And I should see "How do you make an intranet?" in the ".main-panel" element
	And I should see "Documentation" in the ".main-panel" element

	When I move backward one page
	And I follow "000005"
	Then I should see "000005" in the ".main-panel" element
	And I should see "09-05-" in the ".main-panel" element
	And I should see "In Progress" in the ".main-panel" element
	And I should see "Dave1 Manager1" in the ".main-panel" element
	And I should see "manager1@example.com" in the ".main-panel" element
	And I should see "Support" in the ".main-panel" element
	And I should see "Question" in the ".main-panel" element
	And I should see "High" in the ".main-panel" element
	And I should see "Can I turn it on and off?" in the ".main-panel" element
	And I should see "Technical fault" in the ".main-panel" element

	When I move backward one page
	And I follow "000006"
	Then I should see "000006" in the ".main-panel" element
	And I should see "11-06-" in the ".main-panel" element
	And I should see "12-06-" in the ".main-panel" element
	And I should see "Closed" in the ".main-panel" element
	And I should see "Maggie1 Project1" in the ".main-panel" element
	And I should see "project1@example.com" in the ".main-panel" element
	And I should see "Product" in the ".main-panel" element
	And I should see "Problem" in the ".main-panel" element
	And I should see "Medium" in the ".main-panel" element
	And I should see "Difficult to use" in the ".main-panel" element
	And I should see "Usability" in the ".main-panel" element

	When I move backward one page
	And I follow "000007"
	Then I should see "000007" in the ".main-panel" element
	And I should see "13-07-" in the ".main-panel" element
	And I should see "New" in the ".main-panel" element
	And I should see "Dave1 Manager1" in the ".main-panel" element
	And I should see "manager1@example.com" in the ".main-panel" element
	And I should see "Support" in the ".main-panel" element
	And I should see "Request" in the ".main-panel" element
	And I should see "Low" in the ".main-panel" element
	And I should see "Thing Refuses to Start" in the ".main-panel" element
	And I should see "Technical fault, Usability" in the ".main-panel" element
