document.pu_array = [];
pu_toggle_window = function(id, counter){
	var div = $(id);
	popup_wrap_window(jQuery('#'+id));
	if (!div.hasClass('invisible'))
		return div.toggleClass('invisible');

	if (!$defined(document.pu_array[counter])){
		document.pu_array[counter] = {};
		div.inject(document.body);
		pu_position_window(div, counter);
		pu_init_first_time(counter);
	}
	div.toggleClass('invisible');
	//div.setStyle('display', 'block');
	if ($defined($('pu_keyword_'+counter))) $('pu_keyword_'+counter).focus();
}

pu_position_window = function(div, counter){
	var coord = $('pu_button_' + counter).getCoordinates();
	div.setStyles({
		top: coord.top + coord.height,
		left: coord.left
	});
}

pu_show_filter = function(counter){
	jQuery(this).toggleClass('active');

	if (!$defined(document.pu_array[counter].filter)){
		document.pu_array[counter].filter = new Fx.Elements($$('.pu_filter_'+counter));
	}
	var filterHeight = $('pu_filter_sub_'+counter).offsetHeight;
	if ($('pu_filter_'+counter).getStyle('height').toInt() == 0){
		document.pu_array[counter].filter.start({
				'0': { //let's change the first element's opacity and width
				'height': [0, filterHeight]
		    },
				'1': { //and the fifth one's opacity
		    	'height': [230, 230 - filterHeight]
		    }
		});
	}else{
		document.pu_array[counter].filter.start({
		    '0': { //let's change the first element's opacity and width
			'height': [filterHeight,0]
		    },
		    '1': { //and the fifth one's opacity
		    	'height': [230 - filterHeight, 230]
		    }
		});
	}
}

pu_keyword_change = function (counter)
{
	document.pu_array[counter].timer = $clear(document.pu_array[counter].timer);
	document.pu_array[counter].timer = pu_start_search.delay(300, {'counter': counter});
}

pu_start_search = function(){
	document.pu_array[this.counter].timer = $clear(document.pu_array[this.counter].timer);
	var select = $('pu_select_'+this.counter);
	select.empty();
	var el = new Element('option').setHTML("...LOADING...").setProperty('value', 0).inject(select);
	pu_get_result.delay(10, this, [xajax.getFormValues($('pu_form_'+this.counter)), this.counter] );
}

pu_finish_search = function(users_arr, counter){
	var select = $('pu_select_'+counter);
	select.empty();
	select.addEvent('dblclick', function(e){pu_add(counter);});

	users_arr.each(function(user){
		var el = new Element('option').setHTML(user[1]).setProperty('value', user[0]).setProperty('data-profile', user[2]).inject(select);
	});

	if (users_arr.length == 101){
		var el = new Element('option').setHTML('...more users match...').setProperty('disabled', 'disabled').inject(select);
	}

	if (users_arr.length < 1){
		var el = new Element('option').setHTML('...no results...').setProperty('disabled', 'disabled').inject(select);
	}
}

pu_add = function(counter){
	var arr = [];
	$$('#pu_select_'+counter+' option').each(function(option){
		if (option.selected){
			arr.push({'id': option.value, 'name': option.innerHTML, 'profile': option.getProperty('data-profile')});
		}
	});
	window[$('pu_callback_'+counter).value](arr);
}

pu_add_all = function(counter){
	var arr = [];
	if ($$('#pu_select_'+counter+' option').length == 102){
		alert("There are too many users to add. Reduce result list length.");
		return;
	}
	$$('#pu_select_'+counter+' option').each(function(option){
		if (!option.disabled && option.value > 1){
			arr.push({'id': option.value, 'name': option.innerHTML, 'profile': option.getProperty('data-profile')});
		}
	});
	window[$('pu_callback_'+counter).value](arr);
}
