require(['domReady','jquery'], function (domReady, $) {
  domReady(function(){
    $.fn.orderChildren = function(order) {
      this.each(function() {
        var el = $(this);
        for(var i = order.length; i >= 0; i--) {
          el.prepend(el.children(order[i]));
        }
      });
      return this;
    };

    function rearrangeNav() {
      if($(window).width() <= 767){
        $('#claroNav').orderChildren(['#head_searchbox', '.navbar-nav']);
        $('.navbar-nav')
        .orderChildren(['.topbar-profile', '#navCompanyLinks', '#navPersonalLinks', '#appMenuWrapper', '.topbar-loggedon', '.navClockWrapper']);
      }
      else if ($(window).width() >= 767){

        $('#claroNav').orderChildren(['.navbar-nav', '#head_searchbox']);
        $('.navbar-nav')
        .orderChildren(['.navClockWrapper', '#navCompanyLinks', '#navPersonalLinks', '#appMenuWrapper',  '#notifications', '.topbar-loggedon', '#topbar-profile'])
      }
    }


    //remove transition on window resize
    $(window).resize(function(){
      $(".nav-toggle, .nav-wrapper").addClass('no-transition');
    })

    //restore transition after window resize
    $(window).resize(_.debounce(function(){
      $(".nav-toggle, .nav-wrapper").removeClass('no-transition');
    }, 1000));

    $(document).ready(function () {

      rearrangeNav();
      mobiletitles();
      desktopSidemenu();
      openSubs();


      var $window = $(window);
      var lastWindowWidth = $window.width();

      $window.resize(function () {
        var windowWidth = $window.width();
        if (lastWindowWidth !== windowWidth) {
          rearrangeNav();
          mobiletitles();
          desktopSidemenu();
          openSubs();
          lastWindowWidth = windowWidth;
        }
      });





      // Opens navigation menu
      $(".nav-toggle").click(function(){
        $(".nav-toggle, .nav-wrapper, .back-close").toggleClass("in");
        $("li").removeClass("open-mobile");
        $(".notification-toggle").toggleClass("fade-out");
        $("html").toggleClass("no-scroll");
      });

      // Opens notifications
      $(".mobile-notification .notification-toggle").click(function(){
        $(".nav-toggle, .nav-wrapper").removeClass("in");
        $("li").removeClass("open-mobile");
        $("#notifications, .back-close").toggleClass("in");
        $(".nav-toggle").toggleClass("fade-out");
        $("html").toggleClass("no-scroll");
      });

      // Opens sub menus
      function openSubs() {

        if($(window).width() <= 767){
          $( ".nav-wrapper > ul > li a, .nav-wrapper > .header-menu-container > .main_menu__inner > ul > li a" ).click(function() {
            $(this).parent("li").addClass( "open-mobile" );
          });
        }

      }

      // Adds top title li placeholder to sub menus
      $(".nav-wrapper ul ul").prepend($('<li class="top"><span class=" back-menu glyphicons glyphicons-chevron-left"></span><span class="link-wrap"></span></li>'));

      function mobiletitles() {

        if($(window).width() <= 767){
          $("li").removeClass("open-mobile");
          // Adds title of previously clicked item to submenu title
          var menu = $('.nav-wrapper ul');
          $('a', menu).on('click', function(){
            var menutitle = $(this).text();
            var menulink = $(this).attr('href');
            var menuappend = $(this).next('ul').children('li').first('.top').children('.link-wrap');

            menuappend.html('<a href="' + menulink + '"' + '>'  + menutitle + '</a>');

          });
          $('ul > li.has-sub > a').click(function (event) {
            event.preventDefault();
          });
        }
      }

      function desktopSidemenu() {

        if($(window).width() >= 767){
          if (! $('button').hasClass('desktop-toggle')){
            $(".desktop-sideview .header-menu-container li.has-sub, .header-menu-container ul.main_menu__list ul li.has-sub").prepend('<button class="desktop-toggle"><span class="glyphicons glyphicons-chevron-right"></span></button>');
          }
        }
      }

      $('.desktop-sideview .header-menu-container li.has-sub > button, .header-menu-container ul.main_menu__list ul li.has-sub > button').on('click', function(){
        $(this).parent('.has-sub').toggleClass('open-mobile');
      });

      // Closes sub-menus individually
      $( ".back-menu" ).click(function() {
        $(this).parent('.top').parent("ul").parent("li").removeClass("open-mobile");
      });




      // Back fade out
      $(".back-close").click(function(){
        $(".nav-toggle, .nav-wrapper, .back-close, #notifications").removeClass("in");
        $("li").removeClass("open-mobile");
        $(".nav-toggle,.notification-toggle ").removeClass("fade-out");
        $("html").removeClass("no-scroll");
      });


    });

    $(".nav-toggle").click(function(){
      $(".head_nav").toggleClass("open");
    });

    $(".back-close").click(function(){

      $(".head_nav").removeClass("open");
    });

  });
});
