@javascript @core @login
Feature: Verify login and logout.

  Background:
    Given I am on a Claromentis site
    And the following people exist:
      | username | password | surname | firstname | email             |
      | user1    | password | User1   | Bob1      | user1@example.com |
      | user2    | password | User2   | Bob2      | user2@example.com |
      | user3    | password | User3   | Bob3      | user3@example.com |

  Scenario: Check the user becomes locked when too many invalid username and password combination are used at login.

    # Attempt 1.
    Given I am on "/login"
    When I fill in "Username" with "user1"
    And I fill in "Password" with "invalidpassword"
    And I press "Sign-in"
    Then I should see "Invalid username or password given"

    # Attempt 2.
    When I fill in "Username" with "user1"
    And I fill in "Password" with "anotherinvalidpassword"
    And I press "Sign-in"
    Then I should see "Invalid username or password given"

    # Attempt 3.
    When I fill in "Username" with "user1"
    And I fill in "Password" with "yetanotherinvalidpassword"
    And I press "Sign-in"
    Then I should see "You have entered an incorrect username and/or password 3 times. Please contact your Claromentis administrator to unblock your account."

  Scenario: Check the user can login with a valid username and password combination.

    Given I am on "/login"
    When I fill in "Username" with "user2"
    And I fill in "Password" with "password"
    And I press "Sign-in"
    And I open the profile menu
    Then I should see "Bob2 User2"

  Scenario: Check login and logout step definitions.

    Given I login as user "user3" with password "password"
    When I open the profile menu
    Then I should see "Bob3 User3"

    When I logout
    Then I should see "Powered by Claromentis Digital Workplace"
