define(['jquery'], function($)
{
	var ClaPeopleOrgchart = function(){
	};

	ClaPeopleOrgchart.prototype.currentOrgchartVersion = 'photo';

	ClaPeopleOrgchart.prototype.init = function(datasource, filename)
	{
		if (datasource != null)
		{
			var chartContainer = $('#chart-container');

			// only display orgchart if there's data to show.
			var opts = {
				'data' : datasource,
				'nodeTitle': 'nodeTitlePro',
				'nodeContent' : 'nodeContentPro',
				'pan': true,
				'zoom': true,
				'zoominLimit': 3.5,
				'exportButton': false,
				'exportFilename': filename
			};

			window.oc_test = chartContainer.orgchart(opts);

			$('.orgchart').addClass('noncollapsable'); // deactivate collapsability

			var chartOuterContainer = $('#chart-container-outer');

			var chartOuterWidth = chartOuterContainer.width();
			var chartOuterHeight = chartOuterContainer.height();
			var chartTable = chartContainer.find('table').first();
			var chartTableWidth = chartTable.width();
			var chartTableHeight = chartTable.height();

			chartContainer.css('width', '100%');
			chartContainer.css('height', '100%');

			//center Orgchart upon open and zoom in/out
			$('.orgchart').css('width', chartTableWidth);
			chartContainer.scrollLeft((chartContainer[0].scrollWidth - chartContainer.width())/2);

			if (!orgchart_is_preview)
			{
				if (chartTableHeight > chartOuterHeight)
					chartContainer.css('height', chartTableHeight + 'px');
			}

			// create our own export button. This is mainly a copy-paste of the code in the orgchart
			// library with the addition of a temporary change to the height/width of
			// #orgchart-outer-container to get around an annoying bug with the html2canvas library
			// cutting off the image when exporting. - tezmc
			var $exportBtn = $('<button>', {
				'class': 'oc-export-btn' + (opts.chartClass !== '' ? ' ' + opts.chartClass : ''),
				'text': 'Export',
				'click': function(e) {
					// temporarily set the dimensions of outer container to size of orgchart table
					var outerChart = $('#chart-container-outer');
					outerChart.css('width', chartTable.width());
					outerChart.css('height', chartTable.height());
					e.preventDefault();
					if ($(this).children('.spinner').length) {
						return false;
					}
					var $mask = chartContainer.find('.mask');
					if (!$mask.length) {
						chartContainer.append('<div class="mask"><i class="fa fa-circle-o-notch fa-spin spinner"></i></div>');
					} else {
						$mask.removeClass('hidden');
					}
					var sourceChart = chartContainer.addClass('canvasContainer').find('.orgchart:visible').get(0);
					var flag = opts.direction === 'l2r' || opts.direction === 'r2l';
					html2canvas(sourceChart, {
						//'logging': true,
						'useCORS': true,
						'width': flag ? sourceChart.clientHeight : sourceChart.clientWidth,
						'height': flag ? sourceChart.clientWidth : sourceChart.clientHeight,
						'onclone': function(cloneDoc) {
							$(cloneDoc).find('.canvasContainer').css('overflow', 'visible')
								.find('.orgchart:visible:first').css('transform', '');
						},
						'onrendered': function(canvas) {
							chartContainer.find('.mask').addClass('hidden');
							if (opts.exportFileextension && opts.exportFileextension.toLowerCase() === 'pdf') {
								var doc = {};
								var docWidth = Math.floor(canvas.width * 0.2646);
								var docHeight = Math.floor(canvas.height * 0.2646);
								if (docWidth > docHeight) {
									doc = new jsPDF('l', 'mm', [docWidth, docHeight]);
								} else {
									doc = new jsPDF('p', 'mm', [docHeight, docWidth]);
								}
								doc.addImage(canvas.toDataURL(), 'png', 0, 0);
								doc.save(opts.exportFilename + '.pdf');
							} else {
								var isWebkit = 'WebkitAppearance' in document.documentElement.style;
								var isFf = !!window.sidebar;
								var isEdge = navigator.appName === 'Microsoft Internet Explorer' || (navigator.appName === "Netscape" && navigator.appVersion.indexOf('Edge') > -1);

								if ((!isWebkit && !isFf) || isEdge) {
									window.navigator.msSaveBlob(canvas.msToBlob(), opts.exportFilename + '.png');
								}
								else {
									chartContainer.find('.oc-download-btn').attr('href', canvas.toDataURL())[0].click();
								}
							}
						}
					})
						.then(function() {
							chartContainer.removeClass('canvasContainer');
						}, function() {
							chartContainer.removeClass('canvasContainer');
						});
					// reset dimensions of outer container
					outerChart.css('width', '100%');
					outerChart.css('height', '100%');
				}
			});
			chartContainer.append($exportBtn);
			if (!opts.exportFileextension || opts.exportFileextension.toLowerCase() !== 'pdf') {
				var downloadBtn = '<a class="oc-download-btn' + (opts.chartClass !== '' ? ' ' + opts.chartClass : '') + '"'
					+ ' download="' + opts.exportFilename + '.png"></a>';
				$exportBtn.after(downloadBtn);
			}

			// set the onclick behaviour for buttons in the UI

			$('#showPhotoVersionButton').click(function(){
				$('.orgchart-user-photo').css('display', 'block');
				cla_orgchart_view_mode = 'photo';
				return false;
			});

			$('#showTextVersionButton').click(function(){
				$('.orgchart-user-photo').css('display', 'none');
				cla_orgchart_view_mode = 'text';
				return false;
			});

		}
		else
		{
			console.error('cla_orgchart: datasource not defined');
		}
	};
	return ClaPeopleOrgchart;
});
