@javascript @core @people
Feature: Verify basic functionality of People API.

	Background:
		Given I am on a Claromentis site
		When the following people exist:
			| username   | password | surname    | firstname | email              |
			| user1      | password | User1      | Bob1      | user1@example.com  |
			| user2      | password | User2      | Bob2      | user2@example.com  |
			| user3      | password | User3      | Bob3      | user3@example.com  |
			| user4      | password | User4      | Bob4      | user4@example.com  |
			| user5      | password | User5      | Bob5      | user5@example.com  |
			| user6      | password | User6      | Bob6      | user6@example.com  |
			| user7      | password | User7      | Bob7      | user7@example.com  |
			| user8      | password | User8      | Bob8      | user8@example.com  |
			| user9      | password | User9      | Bob9      | user9@example.com  |
			| user10     | password | User10     | Bob10     | user10@example.com |
		And the following user roles exist:
			| title  |
			| Role 1 |
			| Role 2 |
		And the following users are assigned to these roles:
			| username | role   |
			| user2    | Role 1 |
			| user3    | Role 2 |
			| user4    | Role 1 |
			| user5    | Role 2 |
		And the following user groups exist:
			| name    | parent |
			| Group 1 |        |
			| Group 2 |        |
		And the following users are assigned to these groups:
			| username | group   |
			| user6    | Group 1 |
			| user7    | Group 1 |
			| user8    | Group 2 |
			| user9    | Group 2 |
		And I login as an admin user

	Scenario: Verify retrieving a list of users.

		Given I make a simple API request to "/intranet/rest/people/users/"
		Then the simple API request should return "json" matching:
		"""
{
    "data": [
        {
            "id": 2,
            "firstname": "Bob1",
            "surname": "User1",
            "email": "user1@example.com"
        },
        {
            "id": 11,
            "firstname": "Bob10",
            "surname": "User10",
            "email": "user10@example.com"
        },
        {
            "id": 3,
            "firstname": "Bob2",
            "surname": "User2",
            "email": "user2@example.com"
        },
        {
            "id": 4,
            "firstname": "Bob3",
            "surname": "User3",
            "email": "user3@example.com"
        },
        {
            "id": 5,
            "firstname": "Bob4",
            "surname": "User4",
            "email": "user4@example.com"
        },
        {
            "id": 6,
            "firstname": "Bob5",
            "surname": "User5",
            "email": "user5@example.com"
        },
        {
            "id": 7,
            "firstname": "Bob6",
            "surname": "User6",
            "email": "user6@example.com"
        },
        {
            "id": 8,
            "firstname": "Bob7",
            "surname": "User7",
            "email": "user7@example.com"
        },
        {
            "id": 9,
            "firstname": "Bob8",
            "surname": "User8",
            "email": "user8@example.com"
        },
        {
            "id": 10,
            "firstname": "Bob9",
            "surname": "User9",
            "email": "user9@example.com"
        },
        {
            "id": 1,
            "firstname": "Claromentis",
            "surname": "Administrator",
            "email": "rob.tyler@claromentis.com"
        }
    ],
    "paging": {
        "offset": 0,
        "limit": 50,
        "total": 11,
        "prev": "",
        "next": ""
    }
}
		"""

	Scenario: Verify retrieving a paginated list of users.

		Given I make a simple API request to "/intranet/rest/people/users/?limit=5&offset=5"
		Then the simple API request should return "json" matching:
		"""
{
    "data": [
        {
            "id": 6,
            "firstname": "Bob5",
            "surname": "User5",
            "email": "user5@example.com"
        },
        {
            "id": 7,
            "firstname": "Bob6",
            "surname": "User6",
            "email": "user6@example.com"
        },
        {
            "id": 8,
            "firstname": "Bob7",
            "surname": "User7",
            "email": "user7@example.com"
        },
        {
            "id": 9,
            "firstname": "Bob8",
            "surname": "User8",
            "email": "user8@example.com"
        },
        {
            "id": 10,
            "firstname": "Bob9",
            "surname": "User9",
            "email": "user9@example.com"
        }
    ],
    "paging": {
        "offset": 5,
        "limit": 5,
        "total": 11,
        "prev": "http://claromentis.local/intranet/rest/people/users/?&limit=5&offset=0",
        "next": "http://claromentis.local/intranet/rest/people/users/?&limit=5&offset=10"
    }
}
		"""

	Scenario: Verify retrieving a list of users and filtered by name.

		Given I make a simple API request to "/intranet/rest/people/users/?name_filter=Claromentis"
		Then the simple API request should return "json" matching:
		"""
{
    "data": [
        {
            "id": 1,
            "firstname": "Claromentis",
            "surname": "Administrator",
            "email": "rob.tyler@claromentis.com"
        }
    ],
    "paging": {
        "offset": 0,
        "limit": 50,
        "total": 1,
        "prev": "",
        "next": ""
    }
}
		"""

	Scenario: Verify retrieving a list of users and filtered by name using a wild card.

		Given I make a simple API request to "/intranet/rest/people/users/?name_filter=Bob1*"
		Then the simple API request should return "json" matching:
		"""
{
    "data": [
        {
            "id": 2,
            "firstname": "Bob1",
            "surname": "User1",
            "email": "user1@example.com"
        },
        {
            "id": 11,
            "firstname": "Bob10",
            "surname": "User10",
            "email": "user10@example.com"
        }
    ],
    "paging": {
        "offset": 0,
        "limit": 50,
        "total": 2,
        "prev": "",
        "next": ""
    }
}
"""

	Scenario: Verify retrieving a filtered list of users by group.

		Given I make a simple API request to "/intranet/rest/people/users/?groups=2"
		Then the simple API request should return "json" matching:
		"""
{
    "data": [
        {
            "id": 9,
            "firstname": "Bob8",
            "surname": "User8",
            "email": "user8@example.com"
        },
        {
            "id": 10,
            "firstname": "Bob9",
            "surname": "User9",
            "email": "user9@example.com"
        }
    ],
    "paging": {
        "offset": 0,
        "limit": 50,
        "total": 2,
        "prev": "",
        "next": ""
    }
}
"""

	Scenario: Verify retrieving a filtered list of users by role.

		Given I make a simple API request to "/intranet/rest/people/users/?roles=1"
		Then the simple API request should return "json" matching:
		"""
{
    "data": [
        {
            "id": 3,
            "firstname": "Bob2",
            "surname": "User2",
            "email": "user2@example.com"
        },
        {
            "id": 5,
            "firstname": "Bob4",
            "surname": "User4",
            "email": "user4@example.com"
        }
    ],
    "paging": {
        "offset": 0,
        "limit": 50,
        "total": 2,
        "prev": "",
        "next": ""
    }
}
		"""

	Scenario: Verify retrieving a single user.

		Given I make a simple API request to "/intranet/rest/people/users/2"
		Then the simple API request should return "json" matching:
		"""
{
    "id": 2,
    "firstname": "Bob1",
    "surname": "User1",
    "email": "user1@example.com"
}
		"""

		When I make a simple API request to "/intranet/rest/people/users/6?fields=username,firstname,surname"
		Then the simple API request should return "json" matching:
		"""
{
    "username": "user5",
    "firstname": "Bob5",
    "surname": "User5"
}
		"""

	Scenario: Verify retrieving a list of groups.

		Given I make a simple API request to "/intranet/rest/people/groups"
		Then the simple API request should return "json" matching:
		"""
{
    "data": [
        {
            "id": 1,
            "name": "Group 1"
        },
        {
            "id": 2,
            "name": "Group 2"
        }
    ],
    "paging": {
        "offset": 0,
        "limit": 50,
        "total": 2,
        "prev": "",
        "next": ""
    }
}
		"""

	Scenario: Verify retrieving a list of roles.

		Given I make a simple API request to "/intranet/rest/people/roles"
		Then the simple API request should return "json" matching:
		"""
{
    "data": [
        {
            "id": 1,
            "name": "Role 1"
        },
        {
            "id": 2,
            "name": "Role 2"
        }
    ],
    "paging": {
        "offset": 0,
        "limit": 50,
        "total": 2,
        "prev": "",
        "next": ""
    }
}
		"""
