<?php

use Claromentis\Core\Behat\BehatHelper;

/**
 * "behat" mail driver that outputs email in a format for Behat automated testing
 */
class Mail_behat extends Mail {

    /**
     * Any arguments to pass to the mail() function.
     * @var string
     */
    var $_params = '';

    /**
     * Constructor.
     *
     * @param array $params Extra arguments for the mail() function.
     */
    function __construct($params = null)
    {
		$this->_params = $params;

        if (defined('PHP_EOL')) {
            $this->sep = PHP_EOL;
        } else {
            $this->sep = (strpos(PHP_OS, 'WIN') === false) ? "\n" : "\r\n";
        }
    }

	/**
     * Implements Mail_mail::send() function using php's built-in mail()
     * command.
     *
     * @param mixed $recipient Either a comma-seperated list of recipients
     *              (RFC822 compliant), or an array of recipients,
     *              each RFC822 valid. This may contain recipients not
     *              specified in the headers, for Bcc:, resending
     *              messages, etc.
     *
     * @param array $headers The array of headers to send with the mail, in an
     *              associative array, where the array key is the
     *              header name (ie, 'Subject'), and the array value
     *              is the header value (ie, 'test'). The header
     *              produced from those values would be 'Subject:
     *              test'.
     *
     * @param string $body The full text of the message body, including any
     *               Mime parts, etc.
     *
     * @return mixed Returns true on success, or a PEAR_Error
     *               containing a descriptive error message on
     *               failure.
     *
     * @access public
     */
    function send($recipient, $headers, $body)
    {
		global $g_application;

        $this->_sanitizeHeaders($headers);

		// Get the directory to output the email data.
		$cfg_mail_send_params = $g_application->config->Get('cfg_mail_send_params');
		$mail_dir = $cfg_mail_send_params['path'];

		if (!file_exists($mail_dir)) {
			if (!@mkdir($mail_dir)) {
				return PEAR::raiseError("Could not create mail directory '{$mail_dir}'.");
			}
		}

		$mail_dir .= '/current';

		if (!file_exists($mail_dir)) {
			if (!@mkdir($mail_dir)) {
				return PEAR::raiseError("Could not create mail directory '{$mail_dir}'.");
			}
		}

		$mail_dir .= '/';

		// Us eth subject for the directory name, but clean it up.
		if (!empty($headers['Subject'])) {
			$subject = str_replace(['/', ':', '..', '"', "'"], '', $headers['Subject']);
			$subject = preg_replace('/\s+/', ' ', $subject);
			$mail_dir .= $subject;
		} else {
			// This should never happen as an email should alwasy have a subject. But, just in case...
			$mail_dir .= 'subject_missing';
		}

		//var_dump($mail_dir);
		//throw new \RuntimeException('Boo');

		if (!file_exists($mail_dir)) {
			if (!@mkdir($mail_dir)) {
				return PEAR::raiseError("Could not create mail directory '{$mail_dir}'.");
			}
		}

		// Update the recipients list for this email subject.
		$recipients = [];
		$recipients_file = $mail_dir . '/recipients.json';

		if (file_exists($recipients_file)) {
			$recipients = (array) json_decode(file_get_contents($recipients_file));
		}

		$recipients[] = $recipient;
		file_put_contents($recipients_file, json_encode($recipients));

		// Now we want to create an directory using the email address as this will contain
		// the email content just for the single recipient we're sending the mail to.
		$mail_dir .= '/' . $recipient;

		if (!file_exists($mail_dir)) {
			if (!@mkdir($mail_dir)) {
				return PEAR::raiseError("Could not create mail recipient directory '{$mail_dir}'.");
			}
		}

		$text = '';
		foreach ($headers as $h => $v)
		{
			$text .= "$h: $v" . $this->sep;
		}
		$text .= $this->sep;
		$text .= $body;

		$message_file = 'message.eml';
		$headers_file = 'headers.json';
		$body_file = 'body.text';

		// Output the full email message with the headers, content etc.
		if (!@file_put_contents($mail_dir . '/' . $message_file, $text)) {
			return PEAR::raiseError("Couldn't write the email message file '$message_file'");
		}

		// Output the headers JSON encoded.
		if (!@file_put_contents($mail_dir . '/' . $headers_file, json_encode($headers))) {
			return PEAR::raiseError("Couldn't write the email file '$headers_file'");
		}

		// Output the email body.
		if (!@file_put_contents($mail_dir . '/' . $body_file, $body)) {
			return PEAR::raiseError("Couldn't write the email file '$body_file'");
		}

		return true;
    }

}