var path = require('path');
var webpack = require('webpack');
var chalk = require('chalk');

var outputPath = path.join(__dirname, 'web/components');

var stdLoaders = [
    { test: /\.html$/, exclude: /tmp/, loader: "ngtemplate-loader?relativeTo=" + __dirname + "!html-loader" },
    //{ test: /\.jsx?$/, exclude: /(node_modules|tmp)/, loader: 'babel-loader' },
    { test: /\.css$/, use: [
        { loader: "style-loader", options: { minimize: true } },
        { loader: "css-loader", options: { minimize: true } }] },
    { test: /\.(png|jpg|woff|woff2|eot|ttf|otf|gif)/, loader: 'url-loader' },
    //{ test: /\.svg/, loader: 'file?name=/img/[hash].[ext]?' },
    //{ test: /\.less/, loader: "style-loader!css-loader!less-loader" },
    { test: /\.s[a|c]ss/, use: [
        { loader: "style-loader", options: { minimize: true } },
        { loader: "css-loader", options: { minimize: true } },
        { loader: "sass-loader" }] },
    { test: /\.tmpl$/, loader: "underscore-template-loader" },
    { test: /\.svg$/, use: [
        { loader: "svg-url-loader", options: {stripdeclarations: true}} ] }
];

var stdExternals = {
    jquery: { amd: 'jquery' },
    'jquery.validate': { amd: 'jquery.validate' },
    moment: { amd: 'moment' },
    cla_angular: { amd: 'cla_angular' },
    lightbox: { amd: 'lightbox' },
    cla_select2: { amd: 'cla_select2' },
    fileuploader: { amd: 'fileuploader' },
    'bootstrap-datetimepicker': { amd: 'bootstrap-datetimepicker'}
};

var stdResolve = {
    modules: [path.join(__dirname, "web/intranet/js"), path.join(__dirname, 'src/js'), "node_modules"]
};

var stdAmdOutput = {
    path: outputPath,
    filename: '[name].js',
    publicPath: '/components/',
    library: '[name]',
    libraryTarget: 'amd'
};

var uglifyPlugin = new webpack.optimize.UglifyJsPlugin({
    sourceMap: true,
    compress: {
        warnings: false,
        drop_console: false,
        drop_debugger: false
    }
});

var webpackTimeStamp = function() {
	this.plugin('watch-run', function(watching, callback) {
		// Only display when something is changed, not when webpack starts
		if (Object.keys(watching.compiler.fileTimestamps).length > 0)
			console.log('\n\n' + chalk.bold.green('Compile started: ') + chalk.bold.white(new Date()));
		callback();
	})
};

var angular_components2 = {
    context: __dirname,
    //devtool: "source-map",
    entry: {
        'ng.cla.core.breadcrumb': './src/js/angular/cla/breadcrumb/breadcrumb.directive.js',
        'ng.cla.core.date_picker': './src/js/angular/cla/date_picker/date_picker.directive.js',
        'ng.cla.core.group_picker': './src/js/angular/cla/group_picker/group_picker.directive.js',
        'ng.cla.core.role_picker': './src/js/angular/cla/role_picker/role_picker.directive.js',
        'ng.cla.core.sugre_picker': './src/js/angular/cla/sugre_picker/sugre_picker.directive.js',
        'ng.cla.core.user_picker': './src/js/angular/cla/user_picker/user_picker.directive.js',
        'ng.cla.core.folder_picker': './src/js/angular/cla/folder_picker/folder_picker.directive.js',
        'ng.cla.core.image_picker': './src/js/angular/cla/image_picker/image_picker.directive.js',
        'ng.cla.core.html_editor': './src/js/angular/cla/html_editor/html_editor.directive.js',
        'ng.cla.core.icon_picker': './src/js/angular/cla/icon_picker/icon_picker.directive.js',
        'ng.cla.core.icon_grid': './src/js/angular/cla/icon_picker/icon_grid.directive.js',
        'ng.cla.core.permissions_picker': './src/js/angular/cla/permissions_picker/permissions_picker.directive.js',
        'ng.cla.core.lmsg': './src/js/angular/cla/lmsg.directive.js',
        'ng.cla.core.growl': './src/js/angular/cla/growl.service.js',
	    'ng.cla.core.dropbox': './src/js/angular/cla/dropbox/dropbox.directive.js',
	    'ng.cla.core.share': './src/js/angular/cla/share/share.directive.js',
	    'ng.cla.core.colour_picker': './src/js/angular/cla/colour_picker/colour_picker.directive.js',
	    'ng.cla.core.time_picker': './src/js/angular/cla/time_picker/time_picker.directive.js',
	    'ng.cla.core.datetime_picker': './src/js/angular/cla/datetime_picker/datetime_picker.directive.js',
        'ng.cla.core.tag_picker': './src/js/angular/cla/tag_picker/tag_picker.directive.js'
    },
    output: stdAmdOutput,
    resolve: stdResolve,
    externals: stdExternals,
    module: {
        loaders: stdLoaders
    },
    plugins: [
        new webpack.NamedModulesPlugin(),
        uglifyPlugin,
        webpackTimeStamp
    ]
};

for (var index in angular_components2.entry) {
    if( angular_components2.entry.hasOwnProperty(index) ) {
        stdExternals[index] = {amd: index};
    }
}

var libraries = {
    //context: path.join(__dirname, 'web/intranet/js'),
    context: __dirname,
    devtool: "source-map",
    entry: {
        'backbone': './src/js/backbone.js',
        'bootstrap-datetimepicker': [
            './node_modules/eonasdan-bootstrap-datetimepicker/src/js/bootstrap-datetimepicker.js',
            './node_modules/eonasdan-bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css'],
        'cla_highcharts': './src/js/cla_highcharts.js',
        'cla_select2': './src/js/cla_select2.js',
        'fileuploader': './src/js/fileuploader.js',
        'folder_picker': './src/js/folder_picker.js',
        'document_picker': './src/js/document_picker.js',
		'icon_picker': './src/js/icon_picker.js',
        'full_calendar': './src/js/full_calendar.js',
        'lightbox': './src/js/lightbox.js',
        'colour_picker': './src/js/colour_picker.js',
        'calendar/minicalendar': './src/js/calendar/minicalendar.js',
        'infocapture/field_groups': './src/js/infocapture/field_groups.js',
        'infocapture/field_rights': './src/js/infocapture/field_rights.js',
        //'infocapture/dynamic_field_changes': './src/js/infocapture/dynamic_field_changes.js',
        'mootools': './src/js/mootools.js',
        'user_picker': './src/js/user_picker.js',
        'image_dialog': './src/js/image_dialog.js',
        'old_image_crop': './src/js/old_image_crop.js',
        'news/news.slider': './src/js/news/news.slider.js',
        'admin/integration_edit': './src/js/admin/integration_edit.js',
        'search/autocomplete': './src/js/search/search.autocomplete.js',
        'page_top': './src/js/page_top.js',
        'onedrive': './src/js/onedrive/onedrive-sdk.min.js',
        'main_menu': './src/js/main_menu.js'
    },
    output: stdAmdOutput,
    resolve: stdResolve,
    externals: stdExternals,
    module: {
        loaders: stdLoaders
    },
    plugins: [
        new webpack.NamedModulesPlugin(),
        uglifyPlugin,
        webpackTimeStamp
    ]
};

var claRequireJs = {
    //context: path.join(__dirname, 'web/intranet/js'),
    context: __dirname,
    //devtool: "source-map",
    entry: {
        'core': './src/js/core.js',
        'vendor': './src/js/vendor.js'
    },
    output: {
        path: outputPath,
        filename: '[name].js',
        publicPath: '/components/'
    },
    resolve: stdResolve,
    externals: stdExternals,
    module: {
        loaders: stdLoaders
    },
    plugins: [
        new webpack.NamedModulesPlugin(),
        uglifyPlugin,
        webpackTimeStamp
    ]
};

var angular = {
    context: __dirname,
    //devtool: "source-map",
    entry: {
        'cla_angular': './src/js/cla_angular'
    },
    output: stdAmdOutput,
    resolve: {
        alias: {
            angular: path.resolve(__dirname, './src/js/angular/angular'),
            angularAMD: path.resolve(__dirname, './src/js/lib/angular/angularAMD')
        }
    },
    externals: stdExternals,
    module: {
        loaders: stdLoaders
    },
    plugins: [
        new webpack.NamedModulesPlugin(),
        uglifyPlugin,
        webpackTimeStamp
    ]
};

var locales = [ // is changed, the same list needs to be updated in DatesSupport.php
    'ar-tn',
    'cs',
    'de',
    'el',
    'en-gb',
    'es',
    'fr',
    'nl',
    'pl',
    'pt-br',
    'ru'
];
var moment_entries = {};
var locale;
for (var i = 0; i < locales.length; i++) {
    locale = locales[i];
    moment_entries['moment_' + locale] = ['./node_modules/moment/locale/' + locale + '.js', 'moment'];
}

var moment = {
    //context: path.join(__dirname, 'web/intranet/js'),
    context: __dirname,
    //devtool: "source-map",
    entry: moment_entries,
    output: stdAmdOutput,
    resolve: stdResolve,
    externals: {
        jquery: {
            //amd: 'jquery',
            global: 'jQuery'
        }
    },
    module: {
        loaders: stdLoaders
    },
    plugins: [
        new webpack.NamedModulesPlugin(),
        new webpack.ContextReplacementPlugin(/moment[\/\\]locale$/, /non-existing/),
        uglifyPlugin,
        webpackTimeStamp
    ]
};



var angular_components = {
    context: __dirname,
    devtool: "source-map",
    entry: {
	    'acl_roles': './src/js/acl_roles.js',
        'comments': './web/intranet/comments/js/comments.js',
        'datatable': './src/js/datatable.js',
        'datatable_form': './src/js/datatable_form.js',
        'ldap_connection': './src/js/ldap/ldap_connection.js',
        'config_editor': './src/js/config-editor/config_editor.js',
        'add_language': './src/js/localization/add_language.js'
    },
    output: stdAmdOutput,
    resolve: stdResolve,
    externals: stdExternals,
    module: {
        loaders: stdLoaders
    },
    plugins: [
        new webpack.NamedModulesPlugin(),
        uglifyPlugin,
        webpackTimeStamp
    ]
};

var orgchart = {
	context: __dirname,
	devtool: "source-map",
	entry: {
		'cla_orgchart': './src/js/cla_orgchart.js'
	},
	output: stdAmdOutput,
	resolve: {
	    modules: ["node_modules/orgchart/node_modules", path.join(__dirname, "web/intranet/js"), path.join(__dirname, 'src/js'), "node_modules"]
    },
	module: {
		loaders: stdLoaders
	},
	plugins: [
		new webpack.NamedModulesPlugin(),
		uglifyPlugin,
        webpackTimeStamp
	]
};

var sharelink = {
	context: __dirname,
	devtool: "source-map",
	entry: {
		'sharelink': './src/js/sharelink.js'
	},
	output: stdAmdOutput,
	resolve: stdResolve,
	module: {
		loaders: stdLoaders
	},
	plugins: [
		new webpack.NamedModulesPlugin(),
		uglifyPlugin,
        webpackTimeStamp
	]
};

module.exports = [
    libraries, claRequireJs, angular, moment, angular_components, angular_components2, orgchart, sharelink
];
