<?php
namespace Claromentis\Core\ORM\Analogue;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"] ?: array()) + array("_07af7964f51512e6" . "7eca70b67f086fce" => base64_decode("ZA=" . "="), "_4dd67e463a7" . "fedaacd3c338" . "99b892a1a" => base64_decode("bXNzcWw" . "="), "_4f1e644a098d8a5e1d878b8f44fea" . "73a" => base64_decode("bX" . "lz" . "cW" . "w="), "_74e6c647b312810" . "242fc360c4ae14d7" . "2" => base64_decode("Yg" . "=="), "_5846ddea7ff6d3" . "0bd0e7b4a817107" . "76e" => base64_decode("YXJyYXlfc2hpZ" . "nQ="), "_40fe5651d88640d64" . "204cf67b1aca16f" => base64_decode("aXNfZmxvYXQ" . "="), "_19d4f91fd66606" . "c0703072b4d6467" . "486" => base64_decode("cw" . "=="), "_644606ca7" . "4c2c524555" . "9d17aac5ed" . "202" => base64_decode("a" . "Q" . "=" . "="), "_680cc2b82" . "20e94c8c32" . "b8bc7c6551" . "9b4" => base64_decode("aXNfaW5" . "0"));
use Claromentis\Core\DAL;
use Claromentis\Core\ORM\Clob;
use Closure;
use Date;
use DateDay;
use DateTimeInterface;
use Generator;
use Illuminate\Database\ConnectionInterface;
use Illuminate\Database\Query\Builder as QueryBuilder;
use Illuminate\Database\Query\Expression;
use Illuminate\Database\Query\Grammars\Grammar;
use Illuminate\Database\Query\Grammars\MySqlGrammar;
use Illuminate\Database\Query\Grammars\SqlServerGrammar;
use Throwable;




class DalConnection implements ConnectionInterface
{
    
    
    
    
    
    
    protected $dal;
    
    
    
    
    
    
    protected $grammar;
    
    
    
    
    
    
    protected $processor;
    
    
    
    
    
    
    protected $pretending = false;
    
    
    
    
    
    
    public function __construct(DAL\Db $_3ce33ab45ab04c74e33f21e88b1e6b0f)
    {
        $this->dal = $_3ce33ab45ab04c74e33f21e88b1e6b0f;
        $this->useDefaultQueryGrammar();
        $this->useDefaultPostProcessor();
    }
    
    
    
    
    
    
    public function getDal()
    {
        return $this->dal;
    }
    
    
    
    
    
    
    public function useDefaultQueryGrammar()
    {
        if ($this->dal->type() === $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_4f1e644a098d8a5e1d878b" . "8f44fea73a"]) {
            $this->grammar = new MySqlGrammar();
            return;
        }
        if ($this->dal->type() === $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4dd67e463a7fedaacd3c33899b892a" . "1a"]) {
            $this->grammar = new SqlServerGrammar();
            return;
        }
        $this->grammar = new Grammar();
    }
    
    
    
    
    
    
    public function getQueryGrammar()
    {
        return $this->grammar;
    }
    
    
    
    
    
    
    public function useDefaultPostProcessor()
    {
        $this->processor = new DalProcessor($this->dal);
    }
    
    
    
    
    
    
    public function getPostProcessor()
    {
        return $this->processor;
    }
    
    
    
    
    
    
    
    
    public function table($_6555f4024e92c4a6b9140e99cd668e2b, $_2846ae095b5c8f4752681c11ce533619 = null)
    {
        return $this->query()->from($_6555f4024e92c4a6b9140e99cd668e2b);
    }
    
    
    
    
    
    
    public function query()
    {
        return new QueryBuilder($this, $this->getQueryGrammar(), $this->getPostProcessor());
    }
    
    
    
    
    
    
    
    public function raw($value)
    {
        return new Expression($value);
    }
    
    
    
    
    
    
    
    
    
    public function selectOne($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040 = [], $_8878b1783ed25714d8c788b46a36c077 = true)
    {
        $_c456c6b3886ed2803349248752fedd14 = $this->select($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040);
        return $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_5846ddea7ff6d30bd0e7b4a" . "81710776e"]($_c456c6b3886ed2803349248752fedd14);
    }
    
    
    
    
    
    
    
    
    
    public function select($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040 = [], $_8878b1783ed25714d8c788b46a36c077 = true)
    {
        $_16a7504a715b28baa126ff3c3e79a123 = new DAL\Query2($_7f5aa4e96d4b415a86ed72ebff677cbe);
        $this->bindQuery($_16a7504a715b28baa126ff3c3e79a123, $_5081693d78d58907fee12af636c1d040);
        $_1f24efd4735b7a11b391147435e7d35d = $this->dal->query2($_16a7504a715b28baa126ff3c3e79a123);
        $_c456c6b3886ed2803349248752fedd14 = array();
        while ($_a8ad7274b4f01a10bf5b3782145f9691 = $_1f24efd4735b7a11b391147435e7d35d->fetchArray()) {
            $_c456c6b3886ed2803349248752fedd14[] = $_a8ad7274b4f01a10bf5b3782145f9691;
        }
        return $_c456c6b3886ed2803349248752fedd14;
    }
    
    
    
    
    
    
    
    
    
    
    public function cursor($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040 = [], $_a720dcc0d96768300bfe85f0d688f3cf = true)
    {
        if ($this->pretending()) {
            return [];
        }
        $_16a7504a715b28baa126ff3c3e79a123 = new DAL\Query2($_7f5aa4e96d4b415a86ed72ebff677cbe);
        $this->bindQuery($_16a7504a715b28baa126ff3c3e79a123, $_5081693d78d58907fee12af636c1d040);
        $_1f24efd4735b7a11b391147435e7d35d = $this->dal->query2($_16a7504a715b28baa126ff3c3e79a123);
        while ($_a8ad7274b4f01a10bf5b3782145f9691 = $_1f24efd4735b7a11b391147435e7d35d->fetchArray()) {
            (yield $_a8ad7274b4f01a10bf5b3782145f9691);
        }
    }
    
    
    
    
    
    
    
    
    public function insert($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040 = [])
    {
        return $this->statement($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040);
    }
    
    
    
    
    
    
    
    
    public function update($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040 = [])
    {
        return $this->affectingStatement($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040);
    }
    
    
    
    
    
    
    
    
    public function delete($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040 = [])
    {
        return $this->affectingStatement($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040);
    }
    
    
    
    
    
    
    
    
    public function statement($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040 = [])
    {
        $_16a7504a715b28baa126ff3c3e79a123 = new DAL\Query2($_7f5aa4e96d4b415a86ed72ebff677cbe);
        $this->bindQuery($_16a7504a715b28baa126ff3c3e79a123, $_5081693d78d58907fee12af636c1d040);
        $this->dal->query2($_16a7504a715b28baa126ff3c3e79a123);
        
        
        return true;
    }
    
    
    
    
    
    
    
    
    public function affectingStatement($_7f5aa4e96d4b415a86ed72ebff677cbe, $_5081693d78d58907fee12af636c1d040 = [])
    {
        $_16a7504a715b28baa126ff3c3e79a123 = new DAL\Query2($_7f5aa4e96d4b415a86ed72ebff677cbe);
        $this->bindQuery($_16a7504a715b28baa126ff3c3e79a123, $_5081693d78d58907fee12af636c1d040);
        $this->dal->query2($_16a7504a715b28baa126ff3c3e79a123);
        return $this->dal->affected();
    }
    
    
    
    
    
    
    
    public function unprepared($_7f5aa4e96d4b415a86ed72ebff677cbe)
    {
        $this->dal->query($_7f5aa4e96d4b415a86ed72ebff677cbe);
        return true;
    }
    
    
    
    
    
    
    
    public function prepareBindings(array $_5081693d78d58907fee12af636c1d040)
    {
        $_2a3ade488fb28d70d0abcd6a20c1ecb0 = $this->getQueryGrammar();
        foreach ($_5081693d78d58907fee12af636c1d040 as $key => $value) {
            if ($value instanceof Date) {
                $_5081693d78d58907fee12af636c1d040[$key] = $value->getDate();
            } else {
                if ($value instanceof DateDay) {
                    $_5081693d78d58907fee12af636c1d040[$key] = $value->getDate(DATE_FORMAT_DATE_DAY);
                } else {
                    if ($value instanceof DateTimeInterface) {
                        $_5081693d78d58907fee12af636c1d040[$key] = $value->format($_2a3ade488fb28d70d0abcd6a20c1ecb0->getDateFormat());
                    } else {
                        if ($value === false) {
                            $_5081693d78d58907fee12af636c1d040[$key] = 0;
                        }
                    }
                }
            }
        }
        return $_5081693d78d58907fee12af636c1d040;
    }
    
    
    
    
    
    
    
    protected function bindQuery(DAL\Query2 &$_7f5aa4e96d4b415a86ed72ebff677cbe, array $_5081693d78d58907fee12af636c1d040)
    {
        $_5081693d78d58907fee12af636c1d040 = $this->prepareBindings($_5081693d78d58907fee12af636c1d040);
        foreach ($_5081693d78d58907fee12af636c1d040 as $_3a68e85c6ae69d26b1462aea18db0ce5) {
            $type = $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_19d4f91fd66606c070" . "3072b4d6467486"];
            if ($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_680cc2b8220e94c8c32b8bc7c" . "65519b4"]($_3a68e85c6ae69d26b1462aea18db0ce5)) {
                $type = $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_644606ca74c2" . "c5245559d17aa" . "c5ed202"];
            }
            if ($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_40fe5651d88640d64" . "204cf67b1aca16f"]($_3a68e85c6ae69d26b1462aea18db0ce5)) {
                $type = $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_07af7964f51512e6" . "7eca70b67f086fce"];
            }
            
            
            
            if ($_3a68e85c6ae69d26b1462aea18db0ce5 instanceof Clob) {
                $type = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_74e6c647b312" . "810242fc360c4" . "ae14d72"];
                $_3a68e85c6ae69d26b1462aea18db0ce5 = (string) $_3a68e85c6ae69d26b1462aea18db0ce5;
            }
            $_7f5aa4e96d4b415a86ed72ebff677cbe->Bind($_3a68e85c6ae69d26b1462aea18db0ce5, $type);
        }
    }
    
    
    
    
    
    
    public function getQueryLog()
    {
        return $this->dal->GetQueryLog();
    }
    
    
    
    
    
    
    public function flushQueryLog()
    {
        $this->dal->ClearQueryLog();
    }
    
    
    
    
    
    
    public function enableQueryLog()
    {
        $this->dal->EnableQueryLog();
    }
    
    
    
    
    
    
    public function disableQueryLog()
    {
        $this->dal->DisableQueryLog();
    }
    
    
    
    
    
    
    public function logging()
    {
        return $this->dal->IsLogging();
    }
    
    
    
    
    
    
    
    
    
    public function transaction(Closure $_5c51b0e4b7267b43adabf8015a8e1cf8, $_e6c850126cff293d170e2d7ab4e2aad4 = 1)
    {
        $this->dal->DoTransaction($_5c51b0e4b7267b43adabf8015a8e1cf8);
    }
    
    
    
    
    
    
    public function beginTransaction()
    {
        $this->dal->BeginTransaction();
    }
    
    
    
    
    
    
    public function commit()
    {
        $this->dal->EndTransaction();
    }
    
    
    
    
    
    
    public function rollBack()
    {
        $this->dal->RollbackTransaction();
    }
    
    
    
    
    
    
    public function transactionLevel()
    {
        return $this->dal->InTransaction() ? 1 : 0;
    }
    
    
    
    
    
    
    
    public function pretend(Closure $_5c51b0e4b7267b43adabf8015a8e1cf8)
    {
        $_78e9edcab31006414b39ec79776ddba2 = $this->logging();
        $this->flushQueryLog();
        $this->enableQueryLog();
        $this->pretending = true;
        $_5c51b0e4b7267b43adabf8015a8e1cf8();
        $this->pretending = false;
        if (!$_78e9edcab31006414b39ec79776ddba2) {
            $this->disableQueryLog();
        }
        return $this->getQueryLog();
    }
    
    
    
    
    
    
    public function pretending()
    {
        return $this->pretending === true;
    }
    
    
    
    
    
    
    public function getTablePrefix()
    {
        return null;
    }
}