var $ = require('jquery');
require('../../web/intranet/js/kolorpicker/jquery.kolorpicker.js');
require('../../web/intranet/js/kolorpicker/style/kolorpicker.css');

function setBackgroundColor(elem){
	var value = elem.val();
	if ((value.charAt(0) == '#') && (value.length >= 3)) {
		elem.css('background-color', elem.val());
		elem.css('color', getContrastYIQ(elem.val()));
	}
}
function setBackgroundColors() {
	$('.kolorPicker').each(function () {
		setBackgroundColor($(this));
	});
}
function getContrastYIQ(hexcolor){
	//
	if(hexcolor.charAt(0) == '#'){
		hexcolor = hexcolor.substr(1);
	}
	var r = parseInt(hexcolor.substr(0,2),16);
	var g = parseInt(hexcolor.substr(2,2),16);
	var b = parseInt(hexcolor.substr(4,2),16);
	var yiq = ((r*299)+(g*587)+(b*114))/1000;
	return (yiq >= 128) ? 'black' : 'white';
}
setBackgroundColors();

$('body').on('kolorPickerUpdate', '.kolorPicker', function(evt)
{
	setBackgroundColors();
});

module.exports = null;
