define([], function () {

    /**
     * @class Trigger
     * @construtor
     * @property {Number} id - trigger id
     * @property {String} name - trigger name
     */
    var Trigger = function (trigger) {
        this.model = new Trigger.Model(trigger);
        this.view = new Trigger.View();

        this.model.setView(this.view);
        this.view.setModel(this.model);
    };

    Trigger.Model = function (trigger) {
        this.view = null;
        /**
         * Trigger id
         * @private
         * @type {Number}
         */
        this.id = null;

        /**
         * Trigger name
         * @private
         * @type {String}
         */
        this.name = null;

        this.init(trigger);
    };

    Trigger.Model.prototype = (function () {
        var setView = function (view) {
            this.view = view;
        };

        /**
         * Set object data
         * @public
         * @memberOf Trigger
         * @param {Object} data
         * @returns Trigger
         */
        var setData = function (data) {
            setId.call(this, data.id);
            setName.call(this, data.name);
            return this;
        };

        var setId = function (id) {
            this.id = parseInt(id, 10);
        };

        /**
         * Get trigger id
         * @private
         * @memberOf Trigger
         */
        var getId = function () {
            if (_.isNumber(this.id)) {
                return parseInt(this.id, 10);
            } else {
                return NaN;
            }
        };

        var setName = function (name) {
            this.name = name;
        };

        /**
         * Get trigger name
         * @private
         * @memberOf Trigger
         */
        var getName = function () {
            if (_.isString(this.name)) {
                return this.name;
            } else {
                return '';
            }
        };

        return {
            setView: setView,
            /**
             * @public
             * @memberOf Trigger
             */
            init: setData,

            /**
             * Trigger id
             * @public
             * @memberOf Trigger
             */
            id: getId,

            /**
             * Trigger name
             * @public
             * @memberOf Trigger
             */
            name: getName
        };
    })();

    Trigger.View = function () {
        this.model = null;
        this.el = null;
    };

    Trigger.View.prototype = (function () {
        var setModel = function (model) {
            this.model = model;
        };

        /**
         * @private
         * @memberOf Trigger
         * @returns Trigger
         */
        var render = function () {
            $('#trigger-select').append(_.template($('#trigger-select-tmpl').html())(this.model));
            return this;
        };
        return {
            setModel: setModel,
            /**
             * @public
             * @memberOf Trigger
             */
            render: render
        };
    })();

    return Trigger;
});