define(['./field.js'], function (Field) {
    /**
     * Field model
     * @constructor
     * @property {String} symName - field symbolic name
     * @property {String} label - field label
     * @property {Number} postiton - field postition
     */
    var Fields = function(fields, groupId) {"use strict";
        this.collection = new Fields.Collection(fields, groupId);
        this.view = new Fields.View();
        this.collection.setView(this.view);
        this.view.setCollection(this.collection);
    };

    Fields.Collection = function(fields, groupId) {"use strict";
        this.view = null;

        this.fields = [];

        this.groupId = null;

        this.setFields(fields);

        this.setGroupId(groupId);
    };

    Fields.Collection.prototype = (function() {"use strict";

        var setView = function(view) {
            this.view = view;
        };

        var setFields = function(fields) {
            var self = this;
            _.each(fields, function(field) {
                var instance = new Field(field);
                self.fields.push(instance);
            });
        };

        var getFields = function() {
            return this.fields;
        };

        var setGroupId = function(groupId) {
            this.groupId = groupId;
        };

        var getGroupId = function() {
            return this.groupId;
        };

        var getBySymName = function(symName) {
            var field = _.find(this.fields, function(field) {
                return field.model.symName === symName;
            });
            return field;
        };

        var getIndexBySymName = function(symName) {
            var index = _.findIndex(this.fields, function(field) {
                return field.model.symName === symName;
            });
            return parseInt(index, 10);
        };

        return {
            getBySymName : getBySymName,

            getIndexBySymName : getIndexBySymName,

            setView : setView,

            setFields : setFields,

            setGroupId : setGroupId,

            fields : getFields,

            groupId : getGroupId
        };
    })();

    Fields.View = function() {"use strict";
        this.collection = null;
    };

    Fields.View.prototype = (function() {"use strict";
        var setCollection = function(collection) {
            this.collection = collection;
        };

        /**
         * Print the field label
         * @private
         * @memberOf Field.View
         * @returns {Object}
         */
        var render = function(el) {
            var fieldList = el.find('.field-list');
            _.each(this.collection.fields, function(field) {
                fieldList.append(field.view.render());
            });
        };

        return {
            setCollection : setCollection,

            render : render
        };
    })();

    return Fields;
});
