/**
 * View for bookmarks list.
 * Displays data from global boolmarks collection (BookmarksCollection class, "bookmarks" global variable)
 */
var BookmarksView = DocsListViewBase.extend({
	el: $('#bookmarksList'),
	statusMessage: lmsg('documents.bookmarks_view.documents_bookmarks'),

//	render: function ()
//	{
//		$(".main-content-block").hide();
//		this.$el.show();
//	},

	setVisible: function (visible)
	{
		DocsListViewBase.prototype.setVisible.call(this, visible);
		if (visible)
		{
			this.render();
			this.collection.sort();
		}
	},

	toTemplateData: function (bookmark)
	{
		var doc = bookmark.getDocument();
		if (!doc)
		{
			bookmark.loadFull();
			return null;
		}
		var data = doc.toJSON();
		//data.fsize = '-';
		data.obj_id = doc.getObjId();
		return data;
	}
});

