//Some jQuery bits

jQuery.fn.fieldValue = function(successful) {
	for (var val=[], i=0, max=this.length; i < max; i++) {
		var el = this[i];
		var v = jQuery.fieldValue(el, successful);
		if (v === null || typeof v == 'undefined' || (v.constructor == Array && !v.length))
			continue;
		v.constructor == Array ? jQuery.merge(val, v) : val.push(v);
	}
	return val;
};

jQuery.fieldValue = function(el, successful) {
	var n = el.name, t = el.type, tag = el.tagName.toLowerCase();
	if (typeof successful == 'undefined') successful = true;

	if (successful && (!n || el.disabled || t == 'reset' || t == 'button' ||
		(t == 'checkbox' || t == 'radio') && !el.checked ||
		(t == 'submit' || t == 'image') && el.form && el.form.clk != el ||
		tag == 'select' && el.selectedIndex == -1))
			return null;

	if (tag == 'select') {
		var index = el.selectedIndex;
		if (index < 0) return null;
		var a = [], ops = el.options;
		var one = (t == 'select-one');
		var max = (one ? index+1 : ops.length);
		for(var i=(one ? index : 0); i < max; i++) {
			var op = ops[i];
			if (op.selected) {
				var v = op.value;
				if (!v) // extra pain for IE...
					v = (op.attributes && op.attributes['value'] && !(op.attributes['value'].specified)) ? op.text : op.value;
				if (one) return v;
				a.push(v);
			}
		}
		return a;
	}
	return el.value;
};

jQuery.fn.clearForm = function() {
	return this.each(function() {
		jQuery('input,select,textarea', this).clearFields();
		jQuery('input,select,textarea', this).enable();
	});
};

jQuery.fn.clearFields = jQuery.fn.clearInputs = function() {
	return this.each(function() {
		var t = this.type, tag = this.tagName.toLowerCase();
		if (t == 'text' || t == 'password' || tag == 'textarea')
			this.value = '';
		else if (t == 'checkbox' || t == 'radio')
			this.checked = false;
		else if (tag == 'select')
			this.selectedIndex = -1;
	});
};

jQuery.fn.enable = function(b) {
	if (b == undefined) b = true;
	return this.each(function() {
		this.disabled = !b;
	});
};

function ajax_component(sElementId, sAttributes, oData)
{
	if (sElementId != undefined && sAttributes != undefined)
	{
		var el = jQuery('#' . sElementId);
		if (el)
		{
			el.addClass("ajax_loading");
			if(oData)
				oData['attr'] = sAttributes;
			else
				oData = {attr: sAttributes};
			jQuery.ajax({
				type: 'POST',
				url: '/intranet/common/ajax_remote.php',
				data: oData,
				success: function(resp) {
					jQuery('#' + sElementId).html(resp);
					jQuery('#' + sElementId).removeClass("ajax_loading");
					//Lets hook onto form submissions
					jQuery('#' + sElementId).find('form').unbind('submit').submit(function() {
						//We unbind then re-bind to prevent multiple calls on submit (incase reloaded multiples of times);
						el = jQuery('#' + sElementId);
						el.html('');
						el.addClass("ajax_loading");
						var sData = {};
						var els = jQuery(this).find('input,select,textarea');
						for (var i=0, max=els.length; i < max; i++)
						{
							var el = els[i];
							var n = el.name;
							if(!n) continue;
							var v = jQuery.fieldValue(el, true);
							if(v && v.constructor == Array)
							{
								for(var j=0, jmax=v.length; j < jmax; j++)
								if(sData[n].length > 0)
									sData[n] = sData[n] + ", ";
								sData[n] = sData[n] + v[j];
							}
							else if (v !== null && typeof v != 'undefined')
								sData[n] = v;
							
							if(sData[n] == undefined)
								sData[n] = '';
						}
						ajax_component(sElementId, sAttributes, sData);
						return false;
					});
				}
			});
		}
	}
}