define(['mootools', 'moment'], function ($$, moment) {

	var ClnDate = new Class({
		initialize: function(arg){
			if (!$defined(arg)) arg = '';
			var arg = new String(arg);
			switch(arg.length)
			{
				case 19:
					this.date = this.getDateByISO(arg);
				break;
				case 0:
					this.date = new Date();
				break;
				default:
					this.date = new Date(arg);
			}
			this.date.setMilliseconds(0);

		},
		getDateByISO: function(arg){
			var str = new String(arg);
			var matches = str.match(/^(\d\d\d\d)-(\d\d)-(\d\d) (\d\d):(\d\d):(\d\d)$/);
			var date = new Date(matches[1], matches[2]-1, matches[3], matches[4], matches[5], matches[6], 0);
			return date;
		},
		getMinutes: function(){
			return this.makeTwoDigit(this.date.getMinutes());
		},
		setMinutes: function(minutes){
			this.date.setMinutes(minutes);
		},
		setMonth: function(month){
			this.date.setMonth(month-1);
		},
		getSeconds: function(){
			return this.makeTwoDigit(this.date.getSeconds());
		},
		setSeconds: function(seconds){
			this.date.setSeconds(seconds);
		},
		getHours: function(){
			return this.makeTwoDigit(this.date.getHours());
		},
		setHours: function(hours){
			this.date.setHours(hours);
		},
		getDay: function(){
			return this.makeTwoDigit(this.date.getDate() );
		},
		setDay: function(day){
			this.date.setDate(day);
		},
		getWeekDay: function(){
			return (this.date.getDay()+6) % 7;
		},
		toGMTString: function(){
			return this.date.toGMTString();
		},
		getMonth: function(){
			return this.makeTwoDigit(this.date.getMonth()+1);
		},
		getYear: function(){
			return this.date.getFullYear();
		},
		formatMoment: function (format) {
			return moment(this.date).format(format)
		},
		format: function(format)
		{
		    console.log("Old format() method called");
			var momentjs_format;
			if (format === 'Y-m-d H:i:s') {
				momentjs_format = 'YYYY-MM-DD HH:mm:ss';
			} else if (format === 'Ymd') {
				momentjs_format = 'YYYYMMDD';
			} else if (format === 'Ym') {
				momentjs_format = 'YYYYMM';
			} else if (format === 'M Y') {
				momentjs_format = 'MMM Y';
			} else if (format === 'Hi') {
				momentjs_format = 'HHmm';
			} else if (format === 'H:i') {
				momentjs_format = 'HH:mm';
			} else if (format === 'd f') {
				momentjs_format = 'DD MMMM';
			}  else if (format ==='d f H:i'){
				momentjs_format = 'DD MMMM HH:mm';
			}  else if (format ==='I/d'){
				momentjs_format = 'dddd/DD';
			}  else if (format ==='d-m-Y'){
				momentjs_format = 'DD-MM-YYYY';
			}else if (format ==='j f Y'){
				momentjs_format = 'DD MMMM YYYY';
			}else if (format ==='j f'){
				momentjs_format = 'DD MMMM';
			}else if (format ==='j'){
				momentjs_format = 'DD';
			}  else {
				console.log('Unsupported date format ' + format);
			}

			return this.formatMoment(momentjs_format)
		},
		makeTwoDigit: function(numVal) {
			if (numVal < 10) return("0" + numVal);
			return numVal;
		},
		serialize: function(){
			return this.formatMoment("YYYY-MM-DD HH:mm:ss");

		},
		addDays: function(num){
			this.setDay(this.getDay() - -num);
			return this;
		},
		// compare two dates and return <0, ==0, >0
		compare: function(cln_date){
			return diff = this.date.valueOf() - cln_date.date.valueOf();
		},
		getIndex: function(fix_end_date){
			if (fix_end_date && this.formatMoment('hhmm') == '0000'){
				var date = new ClnDate(this.serialize());
				date.addDays(-1);
				return date.getMonth()+''+date.getDay();
			}
			return this.getMonth()+''+this.getDay();
		}
	});

	return ClnDate;
});