<?php
$_db_migration_to = '23.10'; // 7.2.1
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_delete_bookshelf.php', <<<'DB_UPDATE_FILE'
<?php


/** @var $db MySQLDB */
$db->DropTable('bs_archive');
$db->DropTable('bs_archive_queue');
$db->DropTable('bs_autoupdate_notification');
$db->DropTable('bs_book');
$db->DropTable('bs_chapter');
$db->DropTable('bs_chapter_pages');
$db->DropTable('bs_page');
$db->DropTable('bs_page_files');
$db->DropTable('bs_pages_autoupdate_log');
$db->DropTable('bs_reference');
$db->DropTable('bs_structure');
$db->DropTable('bs_tag');
$db->DropTable('bs_tag_link');


$db->query("DELETE FROM permissions WHERE class_id IN in:int:classes", array(53, 59, 55, 56));

$db->query("DELETE FROM tags WHERE aggregation IN in:int:aggr", array(23, 24, 25));

$db->query("DELETE FROM trash_can WHERE aggregation IN in:int:aggr", array(23, 24, 25));

$db->query("DELETE FROM metadata_simple WHERE aggregation IN in:int:aggr", array(23, 24, 25));

list($mdset_id) = $db->query_row("SELECT id FROM metadata_set WHERE set_type=47");
if ($mdset_id)
{
	$db->query("DELETE FROM metadata_set WHERE set_type=47");
	$db->query("DELETE FROM metadata_set_fields WHERE set_id=int:id", $mdset_id);
	$db->query("DELETE FROM ERMS_metadata_field_values WHERE metadata_id NOT IN (SELECT id FROM ERMS_metadata_field)");
}

$db->query("DELETE FROM panels WHERE symname eq:str:code", 'bookshelf');
$db->query("DELETE FROM administrators WHERE panelid NOT IN (SELECT id FROM panels)");


$db->DropColumn('compliances', 'bs_aggr');
$db->DropColumn('compliances', 'bs_id');

require_once('../common/filesystem.php');
global $DATA_DIR;
rmdir_r($DATA_DIR."/bs_data");
global $INTRANET;
rmdir_r($INTRANET.'/bookshelf');

DB_UPDATE_FILE
);


$migrations->Run('02_delete_webcat.php', <<<'DB_UPDATE_FILE'
<?php


/** @var $db MySQLDB */
$db->DropTable('wc_currencies');
$db->DropTable('wc_products');
$db->DropTable('wc_publish_set');
$db->DropTable('wc_tree');


$db->query("DELETE FROM permissions WHERE class_id IN in:int:classes", array(53, 59, 55, 56));


//define('AGGREGATION_WC_CATEGORY',	7);
//define('AGGREGATION_WC_PRODUCT',	8);
//define('AGGREGATION_WC_CATALOG',	9);

$db->query("DELETE FROM tags WHERE aggregation IN in:int:aggr", array(7,8,9));
$db->query("DELETE FROM trash_can WHERE aggregation IN in:int:aggr", array(7,8,9));

$db->query("DELETE FROM ERMS_metadata_inherit WHERE aggregation IN in:int:aggr", array(7,8,9));
$db->query("DELETE FROM ERMS_metadata_element WHERE id IN (SELECT element_id FROM ERMS_metadata_link WHERE aggregation IN in:int:aggr)", array(7,8,9));
$db->query("DELETE FROM ERMS_metadata_link WHERE aggregation IN in:int:aggr", array(7,8,9));


//define('METADATA_SET_WEBCATALOG', 35);
//define('METADATA_SET_WC_CATEGORY', 36);
//define('METADATA_SET_WC_PRODUCT', 37);

list($mdsets_exist) = $db->query_row("SELECT COUNT(1) FROM metadata_set WHERE set_type IN in:int:stypes", array(35, 36, 37));
if ($mdsets_exist)
{
	$db->query("DELETE FROM metadata_set WHERE set_type IN in:int:stypes", array(35, 36, 37));
	$db->query("DELETE FROM metadata_set_fields WHERE set_id NOT IN (SELECT id FROM metadata_set)");
	$db->query("DELETE FROM ERMS_metadata_field_values WHERE metadata_id NOT IN (SELECT id FROM ERMS_metadata_field)");
}


$db->query("DELETE FROM panels WHERE symname eq:str:code", 'webcatalogue');
$db->query("DELETE FROM administrators WHERE panelid NOT IN (SELECT id FROM panels)");


require_once('../common/filesystem.php');
global $DATA_DIR;
rmdir_r($DATA_DIR."/wc_data");
global $INTRANET;
rmdir_r($INTRANET.'/products');

DB_UPDATE_FILE
);


$migrations->Run('03_hide_dashboard_panel.php', <<<'DB_UPDATE_FILE'
<?php

$db->query("DELETE FROM panels WHERE symname eq:str:code", 'diagram');
$db->query("DELETE FROM administrators WHERE panelid NOT IN (SELECT id FROM panels)");

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('23.10');
