<?php
$_db_migration_to = '26.08';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('04_add_obj_type.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('users','whats_new_list',"VARCHAR(1000) DEFAULT NULL");
$obj_types = array(
	2 => 'pub_page',
	8 => 'folder',
	32 => 'document',
	64 => 'forum_message'
);

$result = $db->query("SELECT DISTINCT whats_new_mask FROM users");
while($row = $result->fetchArray())
{
	$string_types = array();
	foreach ($obj_types as $key => $value)
	{
		if(($key & $row['whats_new_mask']) > 0)
		{
			$string_types[] = $value;
		}

	}
	//if the array is empty then leave whats_new_list as NULL default
	if(count($string_types) > 0)
	{
		$string_types = join(',', $string_types);
		$db->unsafe_query = 1;
		$db->query("UPDATE users SET whats_new_list = str:string_type WHERE whats_new_mask = int:id", $string_types, $row['whats_new_mask']);
	}
}
DB_UPDATE_FILE
);


$migrations->Run('05_delete_whats_new_mask.php', <<<'DB_UPDATE_FILE'
<?php

$db = $migrations->GetDb();
$db->DropColumn('users','whats_new_mask');
DB_UPDATE_FILE
);


$migrations->Run('06_change_whats_new_mask_user_field.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();
$db->query("UPDATE users_fields SET field_name=str:list WHERE field_name eq:str:mask", 'whats_new_list', 'whats_new_mask');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('26.08');
