<?php
$_db_migration_to = '40.01'; // 9.0.0-alpha
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_clean_up_mail_queue.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// As far as I can tell these columns are not used and/or never change so the functionality can be hard-coded instead
$db->DropColumn('mail_queue', 'time_to_send');          // To send a mail at some point in the future
$db->DropColumn('mail_queue', 'id_user');               // The user who sent the mail, we always saved -1 (MAILQUEUE_SYSTEM from PEAR)
$db->DropColumn('mail_queue', 'delete_after_send');     // Keep the email, we always set this to 1

DB_UPDATE_FILE
);


$migrations->Run('02_custom_localization_reorder_domains.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * Migration for moving Custom Localizations from the common Localization Domain into their own respective
 * LocalizationDomains, now served via new Localization Providers.
 *
 * @var Claromentis\Setup\SetupFacade $migrations
 */

use Claromentis\Core\Services;

$newDomains = [
	'blog',
	'calendar',
	'communication',
	'design',
	'documents',
	'gallery',
	'mail',
	'mailgun',
	'menu',
	'news',
	'oauth2',
	'orgchart',
	'panels',
	'people',
	'publish',
	'rooms',
	'search',
	'stat',
	'whatsnew'
];

$localizationFileExtension = 'txt';
$commonDomain              = 'common';
$keyDelimiters             = ['lm' => '.', 'lt' => ':'];

$filesystemUtil                = Services::I()->GetFilesystemUtil();
$dataDir                       = $filesystemUtil->realpath($migrations->GetDataDir());
$customLocalizationsPath       = $dataDir . "/i18n";
$commonCustomLocalizationsPath = "$customLocalizationsPath/$commonDomain";

if (is_dir($commonCustomLocalizationsPath)) {
	$fileIterator = new FilesystemIterator($commonCustomLocalizationsPath);

	$customLocalizations = [];
	foreach ($fileIterator as $file) {
		/** @var SplFileInfo $file */

		if ($file->isDir()) {
			continue;
		}

		$language = $file->getBasename(".$localizationFileExtension");
		$file     = $file->openFile('r');

		while ($line = $file->fgets()) {
			$lineArray = explode("\t", $line);

			if (!isset($keyDelimiters[$lineArray[0]])) {
				continue;
			}
			$keyDelimiter = $keyDelimiters[$lineArray[0]];

			$delimitedKey = explode($keyDelimiter, $lineArray[1]);
			$domain       = $delimitedKey[0];

			if (!in_array($domain, $newDomains)) {
				$domain = $commonDomain;
			}

			$languageHeader = ".\t.\t.\t$language\n";

			if (!isset($customLocalizations[$domain][$language])) {
				$customLocalizations[$domain][$language] = $languageHeader;
			}
			$customLocalizations[$domain][$language] .= $line;

			// Make sure the common domain exists so that phrases aren't left behind in the edge-case
			// that it contains no `common.*` phrase translations
			if (!isset($customLocalizations[$commonDomain][$language])) {
				$customLocalizations[$commonDomain][$language] = $languageHeader;
			}
		}
	}

	foreach ($customLocalizations as $domain => $languages) {
		$customLocalizationDirectory = $customLocalizationsPath . "/" . $domain;

		if (!is_dir($customLocalizationDirectory) && !mkdir($customLocalizationDirectory, 0775, true)) {
			throw new \Exception("Failed to create Custom Localization directory '$customLocalizationsPath'");
		}

		foreach ($languages as $language => $content) {
			$file = new SplFileObject("$customLocalizationDirectory/$language.$localizationFileExtension", 'w+');
			$file->fwrite($content);
		}
	}
}

DB_UPDATE_FILE
);


$migrations->Run('02_remove_webmail.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$migrations->GetAdminPanelCreator()->Delete('mail');
$migrations->GetPluginsRepository()->Remove('mail');

DB_UPDATE_FILE
);


$migrations->Run('03_custom_notification_templates_reorder_domains.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * Migration for moving Custom Localizations from the common Localization Domain into their own respective
 * LocalizationDomains, now served via new Localization Providers.
 *
 * @var Claromentis\Setup\SetupFacade $migrations
 */

use Claromentis\Core\Services;

$newDomains = [
	'blog',
	'blogs',    //Not a new domain, but will cover renaming matching Notification Templates to 'blog.'
	'calendar',
	'communication',
	'design',
	'documents',
	'gallery',
	'mail',
	'mailgun',
	'menu',
	'news',
	'oauth2',
	'orgchart',
	'panels',
	'people',
	'publish',
	'rooms',
	'search',
	'stat',
	'whatsnew'
];

$localizationFileExtension = 'txt';
$commonDomain              = 'common';
$keyDelimiters             = ['lm' => '.', 'lt' => ':'];

$filesystemUtil                = Services::I()->GetFilesystemUtil();
$dataDir                       = $filesystemUtil->realpath($migrations->GetDataDir());
$customNotificationsPath       = $dataDir . "/i18n";
$customCommonNotificationsPath = "$customNotificationsPath/$commonDomain/notifications";

if (is_dir($customCommonNotificationsPath)) {
	$directoryIterator   = new RecursiveDirectoryIterator(
		$customCommonNotificationsPath,
		RecursiveDirectoryIterator::SKIP_DOTS
	);
	$fileIterator        = new RecursiveIteratorIterator($directoryIterator);
	$customNotifications = [];

	foreach ($fileIterator as $file) {
		/** @var SplFileInfo $file */
		$pathname  = $file->getPathname();
		$pathArray = explode('/', $pathname);
		$filename  = array_pop($pathArray);
		$language  = array_pop($pathArray);

		$filenameArray = explode('.', $filename);
		$domain        = array_shift($filenameArray);

		if (in_array($domain, $newDomains)) {
			$customNotifications[$domain][$language][] = $filename;
		}
	}

	foreach ($customNotifications as $domain => $languages) {
		// blogs domain does not exist, and should be replaced by blog.
		if ($domain === 'blogs') {
			$domain = 'blog';
		}

		$domainNotificationPath = "$customNotificationsPath/$domain/notifications";

		if (!is_dir($domainNotificationPath) && !mkdir($domainNotificationPath, 0775, true)) {
			throw new \Exception("Failed to create custom notification template directory '$domainNotificationPath'");
		}

		foreach ($languages as $language => $templates) {
			$languageCommonNotificationPath = "$customCommonNotificationsPath/$language";
			$languageDomainNotificationPath = "$customNotificationsPath/$domain/notifications/$language";

			if (!is_dir($languageDomainNotificationPath) && !mkdir($languageDomainNotificationPath, 0775, true)) {
				throw new \Exception("Failed to create custom notification template directory '$languageDomainNotificationPath'");
			}

			foreach ($templates as $template) {
				// Rename any files beginning with 'blogs' to 'blog'.
				$filenameArray = explode('.', $template);
				if ($filenameArray[0] === 'blogs') {
					$filenameArray[0] = 'blog';
					$newTemplate      = implode(".", $filenameArray);
				} else {
					$newTemplate = $template;
				}
				rename(
					"$languageCommonNotificationPath/$template",
					"$languageDomainNotificationPath/$newTemplate"
				);
			}
		}
	}
}

DB_UPDATE_FILE
);


$migrations->Run('03_remove_more_webmail.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->DropTable('mail_folders');
$db->DropTable('mail_filters');
$db->DropTable('mail_account_filters');
$db->DropTable('mail_filter_strings');
$db->DropTable('mail_filter_substrings');

DB_UPDATE_FILE
);


$migrations->Run('04_blog_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$coreConfig = $migrations->GetConfigFull('core');
$blogConfig = $migrations->GetConfigFull('blog');

$cfg_blog_image_height     = $coreConfig->Get('cfg_blog_image_height');
$cfg_blog_image_height_big = $coreConfig->Get('cfg_blog_image_height_big');
$cfg_blog_image_width      = $coreConfig->Get('cfg_blog_image_width');
$cfg_blog_image_width_big  = $coreConfig->Get('cfg_blog_image_width_big');
$cfg_blog_sanitize_options = $coreConfig->Get('cfg_blog_sanitize_options');

if (isset($cfg_blog_image_height)) {
	$blogConfig->Set('cfg_blog_image_height', $cfg_blog_image_height);
}
if (isset($cfg_blog_image_height_big)) {
	$blogConfig->Set('cfg_blog_image_height_big', $cfg_blog_image_height_big);
}
if (isset($cfg_blog_image_width)) {
	$blogConfig->Set('cfg_blog_image_width', $cfg_blog_image_width);
}
if (isset($cfg_blog_image_width_big)) {
	$blogConfig->Set('cfg_blog_image_width_big', $cfg_blog_image_width_big);
}
if (isset($cfg_blog_sanitize_options)) {
	$blogConfig->Set('cfg_blog_sanitize_options', $cfg_blog_sanitize_options);
}

$coreConfig->Delete('cfg_blog_image_height');
$coreConfig->Delete('cfg_blog_image_height_big');
$coreConfig->Delete('cfg_blog_image_width');
$coreConfig->Delete('cfg_blog_image_width_big');
$coreConfig->Delete('cfg_blog_sanitize_options');

$coreConfig->Save();
$blogConfig->Save();

DB_UPDATE_FILE
);


$migrations->Run('05_calendar_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$coreConfig     = $migrations->GetConfigFull('core');
$calendarConfig = $migrations->GetConfigFull('calendar');

$cfg_calendar_default_view_mode = $coreConfig->Get('cfg_calendar_default_view_mode');
$cfg_calendar_export_ical_from  = $coreConfig->Get('cfg_calendar_export_ical_from');
$cfg_calendar_export_ical_to    = $coreConfig->Get('cfg_calendar_export_ical_to');
$cfg_cln_system_calendars       = $coreConfig->Get('cfg_cln_system_calendars');

if (isset($cfg_calendar_default_view_mode)) {
	$calendarConfig->Set('cfg_calendar_default_view_mode', $cfg_calendar_default_view_mode);
}
if (isset($cfg_calendar_export_ical_from)) {
	$calendarConfig->Set('cfg_calendar_export_ical_from', $cfg_calendar_export_ical_from);
}
if (isset($cfg_calendar_export_ical_to)) {
	$calendarConfig->Set('cfg_calendar_export_ical_to', $cfg_calendar_export_ical_to);
}
if (isset($cfg_cln_system_calendars)) {
	$calendarConfig->Set('cfg_cln_system_calendars', $cfg_cln_system_calendars);
}

$coreConfig->Delete('cfg_calendar_default_view_mode');
$coreConfig->Delete('cfg_calendar_export_ical_from');
$coreConfig->Delete('cfg_calendar_export_ical_to');
$coreConfig->Delete('cfg_cln_system_calendars');

$coreConfig->Save();
$calendarConfig->Save();

DB_UPDATE_FILE
);


$migrations->Run('06_documents_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$coreConfig = $migrations->GetConfigFull('core');
$docsConfig = $migrations->GetConfigFull('documents');

$cfg_checkout_with_version_number     = $coreConfig->Get('cfg_checkout_with_version_number');
$cfg_check_document_name_unique       = $coreConfig->Get('cfg_check_document_name_unique');
$cfg_check_folder_name_unique         = $coreConfig->Get('cfg_check_folder_name_unique');
$cfg_docs_admin_can_view              = $coreConfig->Get('cfg_docs_admin_can_view');
$cfg_docs_allow_desktop_editor        = $coreConfig->Get('cfg_docs_allow_desktop_editor');
$cfg_docs_allow_renew                 = $coreConfig->Get('cfg_docs_allow_renew');
$cfg_docs_auto_monitoring             = $coreConfig->Get('cfg_docs_auto_monitoring');
$cfg_docs_forbidden_types             = $coreConfig->Get('cfg_docs_forbidden_types');
$cfg_docs_geo_tagging_google_link_key = $coreConfig->Get('cfg_docs_geo_tagging_google_link_key');
$cfg_docs_geo_tagging_latitude_key    = $coreConfig->Get('cfg_docs_geo_tagging_latitude_key');
$cfg_docs_geo_tagging_longitude_key   = $coreConfig->Get('cfg_docs_geo_tagging_longitude_key');
$cfg_docs_geo_tagging_record_type_key = $coreConfig->Get('cfg_docs_geo_tagging_record_type_key');
$cfg_docs_list_default_view           = $coreConfig->Get('cfg_docs_list_default_view');
$cfg_docs_list_opens_details          = $coreConfig->Get('cfg_docs_list_opens_details');
$cfg_docs_recent_views_enabled        = $coreConfig->Get('cfg_docs_recent_views_enabled');
$cfg_docs_viewers_see_perms           = $coreConfig->Get('cfg_docs_viewers_see_perms');
$cfg_docview_default                  = $coreConfig->Get('cfg_docview_default');
$cfg_docview_no_paging_until          = $coreConfig->Get('cfg_docview_no_paging_until');
$cfg_docview_page_size                = $coreConfig->Get('cfg_docview_page_size');
$cfg_fuu_cleanup_time                 = $coreConfig->Get('cfg_fuu_cleanup_time');
$cfg_google_viewer_enabled            = $coreConfig->Get('cfg_google_viewer_enabled');
$cfg_marker_auto_generation_prefix    = $coreConfig->Get('cfg_marker_auto_generation_prefix');
$cfg_public_host                      = $coreConfig->Get('cfg_public_host');

if (isset($cfg_checkout_with_version_number)) {
	$docsConfig->Set('cfg_checkout_with_version_number', $cfg_checkout_with_version_number);
}
if (isset($cfg_check_document_name_unique)) {
	$docsConfig->Set('cfg_check_document_name_unique', $cfg_check_document_name_unique);
}
if (isset($cfg_check_folder_name_unique)) {
	$docsConfig->Set('cfg_check_folder_name_unique', $cfg_check_folder_name_unique);
}
if (isset($cfg_docs_admin_can_view)) {
	$docsConfig->Set('cfg_docs_admin_can_view', $cfg_docs_admin_can_view);
}
if (isset($cfg_docs_allow_desktop_editor)) {
	$docsConfig->Set('cfg_docs_allow_desktop_editor', $cfg_docs_allow_desktop_editor);
}
if (isset($cfg_docs_allow_renew)) {
	$docsConfig->Set('cfg_docs_allow_renew', $cfg_docs_allow_renew);
}
if (isset($cfg_docs_auto_monitoring)) {
	$docsConfig->Set('cfg_docs_auto_monitoring', $cfg_docs_auto_monitoring);
}
if (isset($cfg_docs_forbidden_types)) {
	$docsConfig->Set('cfg_docs_forbidden_types', $cfg_docs_forbidden_types);
}
if (isset($cfg_docs_geo_tagging_google_link_key)) {
	$docsConfig->Set('cfg_docs_geo_tagging_google_link_key', $cfg_docs_geo_tagging_google_link_key);
}
if (isset($cfg_docs_geo_tagging_latitude_key)) {
	$docsConfig->Set('cfg_docs_geo_tagging_latitude_key', $cfg_docs_geo_tagging_latitude_key);
}
if (isset($cfg_docs_geo_tagging_longitude_key_number)) {
	$docsConfig->Set('cfg_docs_geo_tagging_longitude_key', $cfg_docs_geo_tagging_longitude_key);
}
if (isset($cfg_docs_geo_tagging_record_type_key)) {
	$docsConfig->Set('cfg_docs_geo_tagging_record_type_key', $cfg_docs_geo_tagging_record_type_key);
}
if (isset($cfg_docs_list_default_view)) {
	$docsConfig->Set('cfg_docs_list_default_view', $cfg_docs_list_default_view);
}
if (isset($cfg_docs_list_opens_details)) {
	$docsConfig->Set('cfg_docs_list_opens_details', $cfg_docs_list_opens_details);
}
if (isset($cfg_docs_recent_views_enabled)) {
	$docsConfig->Set('cfg_docs_recent_views_enabled', $cfg_docs_recent_views_enabled);
}
if (isset($cfg_docs_viewers_see_perms)) {
	$docsConfig->Set('cfg_docs_viewers_see_perms', $cfg_docs_viewers_see_perms);
}
if (isset($cfg_docview_default)) {
	$docsConfig->Set('cfg_docview_default', $cfg_docview_default);
}
if (isset($cfg_docview_no_paging_until)) {
	$docsConfig->Set('cfg_docview_no_paging_until', $cfg_docview_no_paging_until);
}
if (isset($cfg_docview_page_size)) {
	$docsConfig->Set('cfg_docview_page_size', $cfg_docview_page_size);
}
if (isset($cfg_fuu_cleanup_time)) {
	$docsConfig->Set('cfg_fuu_cleanup_time', $cfg_fuu_cleanup_time);
}
if (isset($cfg_google_viewer_enabled)) {
	$docsConfig->Set('cfg_google_viewer_enabled', $cfg_google_viewer_enabled);
}
if (isset($cfg_marker_auto_generation_prefix)) {
	$docsConfig->Set('cfg_marker_auto_generation_prefix', $cfg_marker_auto_generation_prefix);
}
if (isset($cfg_public_host)) {
	$docsConfig->Set('cfg_public_host', $cfg_public_host);
}

$coreConfig->Delete('cfg_checkout_with_version_number');
$coreConfig->Delete('cfg_check_document_name_unique');
$coreConfig->Delete('cfg_check_folder_name_unique');
$coreConfig->Delete('cfg_docs_admin_can_view');
$coreConfig->Delete('cfg_docs_allow_desktop_editor');
$coreConfig->Delete('cfg_docs_allow_renew');
$coreConfig->Delete('cfg_docs_auto_monitoring');
$coreConfig->Delete('cfg_docs_forbidden_types');
$coreConfig->Delete('cfg_docs_geo_tagging_google_link_key');
$coreConfig->Delete('cfg_docs_geo_tagging_latitude_key');
$coreConfig->Delete('cfg_docs_geo_tagging_longitude_key');
$coreConfig->Delete('cfg_docs_geo_tagging_record_type_key');
$coreConfig->Delete('cfg_docs_list_default_view');
$coreConfig->Delete('cfg_docs_list_opens_details');
$coreConfig->Delete('cfg_docs_recent_views_enabled');
$coreConfig->Delete('cfg_docs_viewers_see_perms');
$coreConfig->Delete('cfg_docview_default');
$coreConfig->Delete('cfg_docview_no_paging_until');
$coreConfig->Delete('cfg_docview_page_size');
$coreConfig->Delete('cfg_fuu_cleanup_time');
$coreConfig->Delete('cfg_google_viewer_enabled');
$coreConfig->Delete('cfg_marker_auto_generation_prefix');
$coreConfig->Delete('cfg_public_host');

$coreConfig->Save();
$docsConfig->Save();

DB_UPDATE_FILE
);


$migrations->Run('07_gallery_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$coreConfig    = $migrations->GetConfigFull('core');
$galleryConfig = $migrations->GetConfigFull('gallery');

$cfg_gallery_default_resolution = $coreConfig->Get('cfg_gallery_default_resolution');
$cfg_gallery_thumb_height       = $coreConfig->Get('cfg_gallery_thumb_height');
$cfg_gallery_thumb_width        = $coreConfig->Get('cfg_gallery_thumb_width');

if (isset($cfg_gallery_default_resolution)) {
	$galleryConfig->Set('cfg_gallery_default_resolution', $cfg_gallery_default_resolution);
}
if (isset($cfg_gallery_thumb_height)) {
	$galleryConfig->Set('cfg_gallery_thumb_height', $cfg_gallery_thumb_height);
}
if (isset($cfg_gallery_thumb_width)) {
	$galleryConfig->Set('cfg_gallery_thumb_width', $cfg_gallery_thumb_width);
}

$coreConfig->Delete('cfg_gallery_default_resolution');
$coreConfig->Delete('cfg_gallery_thumb_height');
$coreConfig->Delete('cfg_gallery_thumb_width');

$coreConfig->Save();
$galleryConfig->Save();

DB_UPDATE_FILE
);


$migrations->Run('08_infocapture_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$migratedConfigKeys = [
	'cfg_ic_allow_save_as_pdf', 'cfg_ic_attach_preview_max_size', 'cfg_ic_attach_size_limit', 'cfg_ic_issue_pad',
	'cfg_ic_issue_prefix_pad', 'cfg_ic_notification_from', 'cfg_ic_status_color_highlighting'
];

$coreConfig = $migrations->GetConfigFull('core');
$icConfig   = $migrations->GetConfigFull('infocapture');

foreach ($migratedConfigKeys as $configKey) {
	$coreValue = $coreConfig->Get($configKey);
	if (isset($coreValue)) {
		$icConfig->Set($configKey, $coreValue);
	}
	$coreConfig->Delete($configKey);
}

$coreConfig->Save();
$icConfig->Save();

DB_UPDATE_FILE
);


$migrations->Run('09_news_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$migratedConfigKeys = [
	'cfg_headline_news_image_height', 'cfg_headline_news_image_height_big', 'cfg_headline_news_image_width',
	'cfg_headline_news_image_width_big',
	'cfg_headline_news_items_per_page', 'cfg_headline_news_number', 'cfg_headline_news_text_truncate',
	'cfg_news_sanitize_options', 'cfg_news_show_comments'
];

$coreConfig = $migrations->GetConfigFull('core');
$newsConfig = $migrations->GetConfigFull('news');

foreach ($migratedConfigKeys as $configKey) {
	$coreValue = $coreConfig->Get($configKey);
	if (isset($coreValue)) {
		$newsConfig->Set($configKey, $coreValue);
	}
	$coreConfig->Delete($configKey);
}

$coreConfig->Save();
$newsConfig->Save();

DB_UPDATE_FILE
);


$migrations->Run('10_orgchart_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$migratedConfigKeys = [
	'cfg_orgchart_image_height', 'cfg_orgchart_image_width'
];

$coreConfig     = $migrations->GetConfigFull('core');
$orgchartConfig = $migrations->GetConfigFull('orgchart');

foreach ($migratedConfigKeys as $configKey) {
	$coreValue = $coreConfig->Get($configKey);
	if (isset($coreValue)) {
		$orgchartConfig->Set($configKey, $coreValue);
	}
	$coreConfig->Delete($configKey);
}

$coreConfig->Save();
$orgchartConfig->Save();

DB_UPDATE_FILE
);


$migrations->Run('11_orgchart_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$migratedConfigKeys = [
	'cfg_default_room_booking_view'
];

$coreConfig  = $migrations->GetConfigFull('core');
$roomsConfig = $migrations->GetConfigFull('rooms');

foreach ($migratedConfigKeys as $configKey) {
	$coreValue = $coreConfig->Get($configKey);
	if (isset($coreValue)) {
		$roomsConfig->Set($configKey, $coreValue);
	}
	$coreConfig->Delete($configKey);
}

$coreConfig->Save();
$roomsConfig->Save();

DB_UPDATE_FILE
);


$migrations->Run('12_holidays_config_migration.php', <<<'DB_UPDATE_FILE'
<?php
/** @var Claromentis\Setup\SetupFacade $migrations */

$migratedConfigKeys = [
	'cfg_holidays_ical_notification', 'cfg_holidays_report_pagesize_group', 'cfg_holidays_show_calendar_days',
	'cfg_holidays_team_by_group', 'cfg_holidays_view_team_details', 'holidays_bradford_days',
	'holidays_bradford_enabled', 'holidays_bradford_half_day'
];

$coreConfig     = $migrations->GetConfigFull('core');
$holidaysConfig = $migrations->GetConfigFull('holidays');

foreach ($migratedConfigKeys as $configKey) {
	$coreValue = $coreConfig->Get($configKey);
	if (isset($coreValue)) {
		$holidaysConfig->Set($configKey, $coreValue);
	}
	$coreConfig->Delete($configKey);
}

$coreConfig->Save();
$holidaysConfig->Save();

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('40.01');
