<?php
namespace Claromentis\Core\Ai\Adapters\Vertex;

$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"] ?: array()) + array("_6ee75f9" . "f44b14f2" . "40fc54f3" . "e19e7084" . "a" => base64_decode("UmVjZWl2ZWQgYW4gdW5leH" . "BlY3RlZCBlcnJvciBmcm9t" . "IHRoZSBzZXJ2ZXI="), "_38021ae38952751baca9f63ac2bf72" . "3b" => base64_decode("LWFpcGxhdGZ" . "vcm0uZ29vZ2" . "xlYXBpcy5jb" . "20vdjE="), "_7681c2a2b7e1bdf69c2" . "3c6cd64114ad3" => base64_decode("anNvb" . "l9kZW" . "NvZGU" . "="), "_8ec8f26c7" . "42278f9061" . "5f50d682ee" . "a79" => base64_decode("UE9T" . "VA=="), "_043583fc6" . "e4063be6ec" . "4a31bf9516" . "16c" => base64_decode("L3Byb2plY3" . "RzLw=="), "_0cb031e3cd6ff0075d3bccfcfd" . "b999a6" => base64_decode("LCBjb25" . "0ZW50Oi" . "A="), "_f24852a7b2e8" . "c180d1f7ab216" . "c8e8222" => base64_decode("QmVhcmVy" . "IA=="), "_1cc5aa2f679" . "b575f82786a7" . "3f0da28f8" => base64_decode("c3" . "Ry" . "ZW" . "Ft"), "_7c819f403b31525f384e3" . "3c0142be9f4" => base64_decode("L3B1Ymxpc2hlcnMvZ29v" . "Z2xlL21vZGVscy8="), "_b673c9549489ba1916" . "c266f60dc846a8" => base64_decode("cHJlZGljdA" . "=="), "_e2cad529b5b2b661032342010c" . "496554" => base64_decode("L2xvY2F0aW9ucy8" . "="), "_bef1236f88db6b34bcb87" . "8fe48142cb6" => base64_decode("aHR0cF" . "9lcnJv" . "cnM="), "_67a3498b1e8fe5" . "3ddf39e400a59bc" . "91f" => base64_decode("cmVnaW9" . "uX25hbW" . "U="), "_e9181de682eebf636bae0512" . "695b2a95" => base64_decode("QXV0aG9yaXphdGlvbg=" . "="), "_47ee521cf79c60b97cda9e" . "cd9c595c95" => base64_decode("U2VydmVyIHJldHVybmVkIGFuIHVuZXhwZWN0ZWQg" . "cmVzcG9uc2UuIEhUVFAgY29kZTog"), "_3e258c4e6163007d8094c396" . "47602e7a" => base64_decode("aGVh" . "ZGVy" . "cw=="), "_db618ca" . "8e79f97b" . "4dff753e" . "c837942c" . "f" => base64_decode("cHJvamVjd" . "F9pZA=="), "_7215c118ad8698360" . "2db0b431cb9a1e9" => base64_decode("Z2VuZXJhdGVDb250Z" . "W50"), "_86e718deafc5b7c8" . "6aa63799a9e024d0" => base64_decode("aHR0cH" . "M6Ly8="), "_29225c3f2cb4b5bb8cdfecad11c6f49" . "1" => base64_decode("O" . "g" . "=" . "="), "_63a6ec2f2044028" . "5232bed955be3326" . "6" => base64_decode("c3RyZWFtR2VuZXJ" . "hdGVDb250ZW50"));
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Image\VertexAiImageRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Text\VertexAiTextRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\VertexAiClientAuthentication;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Image\VertexAiGenerateImageResponse;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Text\VertexAiGenerateTextResponse;
use Claromentis\Core\Ai\Exceptions\AiException;
use Claromentis\Core\Ai\Exceptions\AiInvalidRequestException;
use Claromentis\Core\Ai\Exceptions\AiServerResponseException;
use Claromentis\Core\Ai\Exceptions\VertexAiPromptException;
use Claromentis\Core\Ai\JsonParser;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Stream\StreamInterface;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Symfony\Component\HttpFoundation\Response;






class VertexAiClient implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    
    
    
    
    
    
    
    
    
    public const ERROR_INVALID_ARGUMENT = Response::HTTP_BAD_REQUEST;
    public const ERROR_UNAUTHENTICATED = Response::HTTP_UNAUTHORIZED;
    public const ERROR_PERMISSION_DENIED = Response::HTTP_FORBIDDEN;
    public const ERROR_NOT_FOUND = Response::HTTP_NOT_FOUND;
    public const ERROR_RESOURCE_EXHAUSTED = Response::HTTP_TOO_MANY_REQUESTS;
    public const ERROR_CANCELLED = 499;
    
    
    public const ERROR_INTERNAL_ERROR = Response::HTTP_INTERNAL_SERVER_ERROR;
    public const ERROR_UNAVAILABLE = Response::HTTP_SERVICE_UNAVAILABLE;
    public const ERROR_DEADLINE_EXCEEDED = Response::HTTP_GATEWAY_TIMEOUT;
    
    
    
    
    private string $projectId;
    
    
    
    
    private string $regionName;
    
    
    
    
    private string $modelName;
    
    
    
    
    private VertexAiClientAuthentication $authentication;
    
    
    
    
    private ClientInterface $client;
    
    
    
    
    
    
    
    
    
    public function __construct(VertexAiClientAuthentication $_961ccc1b377e30c70011809b405b9c07, array $config, LoggerInterface $logger = null, ClientInterface $_2f664bcc4a0a32ffda2885fb12940265 = null)
    {
        $this->projectId = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_db618ca8" . "e79f97b4d" . "ff753ec83" . "7942cf"]];
        $this->regionName = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_67a3498b1e8fe53ddf39e400a5" . "9bc91f"]];
        $this->authentication = $_961ccc1b377e30c70011809b405b9c07;
        $this->logger = $logger ?? new NullLogger();
        $this->client = $_2f664bcc4a0a32ffda2885fb12940265 ?? new Client();
    }
    
    
    
    
    
    
    
    
    
    
    public function handleGenerateTextRequest(VertexAiTextRequest $request, callable $_5c51b0e4b7267b43adabf8015a8e1cf8 = null)
    {
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        if ($request->isStreaming()) {
            $this->generateTextStream($_f4bd77b9d7574792bd46db73586ce19d, $_5c51b0e4b7267b43adabf8015a8e1cf8);
            return;
        }
        return $this->generateText($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    
    
    public function handleGenerateImageRequest(VertexAiImageRequest $request)
    {
        
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        return $this->generateImages($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    private function generateText(array $data) : VertexAiGenerateTextResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_7215c118ad86983602db0b43" . "1cb9a1e9"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateTextResponse::fromArray($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_7681c2a2b7e1bdf69c23c6cd" . "64114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true), $this->modelName);
    }
    
    
    
    
    
    
    
    private function generateImages(array $data) : VertexAiGenerateImageResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_b673c9549489ba1916c266f6" . "0dc846a8"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateImageResponse::fromArray($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_7681c2a2b7e1bdf69c23" . "c6cd64114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true));
    }
    
    
    
    
    
    
    
    public function buildURL(string $_3bf6f785d3520dfd17a871d18d745880) : string
    {
        return $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_86e718deaf" . "c5b7c86aa63" . "799a9e024d0"] . $this->regionName . $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_38021ae38952751baca9f63ac2bf72" . "3b"] . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_043583fc6e4063be6ec4a31bf9516" . "16c"] . $this->projectId . $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_e2cad529b5b2" . "b661032342010" . "c496554"] . $this->regionName . $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_7c819f403b315" . "25f384e33c0142" . "be9f4"] . $this->modelName . ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_29225c3f" . "2cb4b5bb8" . "cdfecad11" . "c6f491"] . $_3bf6f785d3520dfd17a871d18d745880);
    }
    
    
    
    
    
    
    
    
    
    
    
    private function send(string $_c927258f5322288a992c77be40ae0b53, array $data, bool $_1cc5aa2f679b575f82786a73f0da28f8 = false)
    {
        $_fd5a3a643834299cbdadfc3540ba0bcb = $this->client->request($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_8ec8f26c742278f90615f50d6" . "82eea79"], $_c927258f5322288a992c77be40ae0b53, [RequestOptions::JSON => $data, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_1cc5aa2f679b575f82786a73f0da28" . "f8"] => $_1cc5aa2f679b575f82786a73f0da28f8, $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_bef1236f88" . "db6b34bcb87" . "8fe48142cb6"] => false, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_3e258c4e6163007" . "d8094c39647602e7" . "a"] => [$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_e9181de682eebf636bae0512695b2a" . "95"] => $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_f24852a7b2e8c180d1f7" . "ab216c8e8222"] . $this->authentication->getAccessToken()]]);
        $this->checkResponse($_fd5a3a643834299cbdadfc3540ba0bcb);
        return $_fd5a3a643834299cbdadfc3540ba0bcb->getBody();
    }
    
    
    
    
    
    
    
    
    private function generateTextStream(array $data, callable $_5c51b0e4b7267b43adabf8015a8e1cf8) : void
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_63a6ec2f20440285232b" . "ed955be33266"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        $_1cc5aa2f679b575f82786a73f0da28f8 = $this->send($_c927258f5322288a992c77be40ae0b53, $data, true);
        $_c37f5d387ecde7a206c24852e173b2fe = new JsonParser(function (array $_fd62bc4eaaf7d58dea9bada3e30443b9) use($_5c51b0e4b7267b43adabf8015a8e1cf8) {
            $_5c51b0e4b7267b43adabf8015a8e1cf8(VertexAiGenerateTextResponse::fromArray($_fd62bc4eaaf7d58dea9bada3e30443b9, $this->modelName));
        });
        while (!$_1cc5aa2f679b575f82786a73f0da28f8->eof()) {
            $_c37f5d387ecde7a206c24852e173b2fe->consume($_1cc5aa2f679b575f82786a73f0da28f8->Read(1024));
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    private function checkResponse(\Psr\Http\Message\ResponseInterface $_fd5a3a643834299cbdadfc3540ba0bcb)
    {
        switch ($_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode()) {
            
            
            
            case self::ERROR_UNAUTHENTICATED:
            case self::ERROR_PERMISSION_DENIED:
                throw AiException::invalidCredentials();
            case self::ERROR_INVALID_ARGUMENT:
                throw new AiInvalidRequestException();
            case self::ERROR_NOT_FOUND:
            case self::ERROR_RESOURCE_EXHAUSTED:
            case self::ERROR_CANCELLED:
            case self::ERROR_DEADLINE_EXCEEDED:
            case self::ERROR_INTERNAL_ERROR:
            case self::ERROR_UNAVAILABLE:
                $this->logger->error($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_47ee521cf79c60b97cda9ecd9c5" . "95c95"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode() . $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_0cb031e3cd6ff0" . "075d3bccfcfdb99" . "9a6"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getBody());
                throw new AiServerResponseException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_6ee75f9f4" . "4b14f240fc" . "54f3e19e70" . "84a"], $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode());
        }
    }
}