<?php
namespace Claromentis\Design\Facade;

$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"] ?: array()) + array();
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Core\DAL;
use Claromentis\Design\Model\Theme;
use Claromentis\Design\Repository\GlobalStyleStorage;
use Claromentis\Design\Repository\ThemeRepository;
use Claromentis\Design\Style\StyleOptions;
use Claromentis\Design\ThemeStyleInterface;
use Symfony\Component\HttpFoundation\Session\SessionInterface;





class ActiveTheme
{
    public const SESSION_VI_KEY = 'SESSION_skin';
    public const SESSION_THEME_KEY = 'SESSION_theme';
    protected SessionInterface $session;
    protected DAL\Interfaces\DbInterface $database;
    protected GlobalStyleStorage $global_style_storage;
    protected ThemeRepository $theme_repo;
    protected ThemeStyleInterface $theme_style;
    protected UserThemes $user_themes;
    protected SecurityContext $context;
    protected $local_theme;
    protected $local_vi;
    protected string $guest_theme;
    public function __construct(SessionInterface $session, DAL\Interfaces\DbInterface $_4504853ce5094b088c8bdc3d570a0a5d, GlobalStyleStorage $_1f1784b27681b09fb71a52c7625d43f2, ThemeRepository $theme_repo, ThemeStyleInterface $theme_style, UserThemes $_7ad944ee40f562f9cbc02d0f665d0fd5, SecurityContext $context, string $_792c8af5d2613494a683b28207c00b5b)
    {
        $this->session = $session;
        $this->database = $_4504853ce5094b088c8bdc3d570a0a5d;
        $this->global_style_storage = $_1f1784b27681b09fb71a52c7625d43f2;
        $this->theme_repo = $theme_repo;
        $this->theme_style = $theme_style;
        $this->user_themes = $_7ad944ee40f562f9cbc02d0f665d0fd5;
        $this->context = $context;
        $this->guest_theme = $_792c8af5d2613494a683b28207c00b5b;
    }
    public function SetTheme(Theme $theme)
    {
        $this->local_theme = null;
        $this->local_vi = null;
        $this->session->set(self::SESSION_VI_KEY, $theme->base_vi);
        $this->session->set(self::SESSION_THEME_KEY, $theme->GetCode());
    }
    
    
    
    
    
    
    public function SetLocalTheme(Theme $theme)
    {
        $this->local_vi = $theme->base_vi;
        $this->local_theme = $theme->GetCode();
    }
    
    
    
    
    
    
    public function SetLocalThemeByCode(string $theme_code)
    {
        try {
            $theme = $this->theme_repo->GetByCode($theme_code);
            $this->SetLocalTheme($theme);
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            
            
        }
    }
    public function SetThemeByCode($theme_code)
    {
        try {
            $theme = $this->theme_repo->GetByCode($theme_code);
            $this->SetTheme($theme);
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            
            
        }
    }
    public function GetThemeCode()
    {
        $_7ad944ee40f562f9cbc02d0f665d0fd5 = $this->user_themes;
        
        
        if ($this->local_theme) {
            return $this->local_theme;
        }
        $_24e0e36600d6af77406a44bb618a6253 = $this->context->GetUser(true);
        if ((int) $_24e0e36600d6af77406a44bb618a6253->id === 0) {
            
            
            $theme_code = null;
        } else {
            $theme_code = $this->session->get(self::SESSION_THEME_KEY);
            $_1094e676b181787efca3ba094a0adade = $_24e0e36600d6af77406a44bb618a6253->GetSkin();
            
            
            
            if (!$_7ad944ee40f562f9cbc02d0f665d0fd5->IsAllowed($this->context, $theme_code) || $theme_code !== $_1094e676b181787efca3ba094a0adade) {
                
                
                
                if (!$_7ad944ee40f562f9cbc02d0f665d0fd5->IsAllowed($this->context, $_1094e676b181787efca3ba094a0adade)) {
                    
                    
                    
                    $_f91b96bed61702b3cebd0a9cbb2104cf = $_7ad944ee40f562f9cbc02d0f665d0fd5->GetPreferred($this->context);
                    $theme = $_7ad944ee40f562f9cbc02d0f665d0fd5->GetByCode($_f91b96bed61702b3cebd0a9cbb2104cf);
                } else {
                    
                    
                    $theme = $_7ad944ee40f562f9cbc02d0f665d0fd5->GetByCode($_1094e676b181787efca3ba094a0adade);
                }
                
                
                if ($theme) {
                    $theme_code = $theme->GetCode();
                    $this->database->DisableTokenCheck();
                    $_7ad944ee40f562f9cbc02d0f665d0fd5->SetForUser($theme_code, $_24e0e36600d6af77406a44bb618a6253);
                    $this->database->EnableTokenCheck();
                    $this->SetTheme($theme);
                }
            }
            $this->session->set(self::SESSION_THEME_KEY, $theme_code);
        }
        
        
        if ($theme_code === null) {
            $theme_code = $this->guest_theme;
            $theme = $_7ad944ee40f562f9cbc02d0f665d0fd5->GetByCode($theme_code);
            if ($theme) {
                $this->SetTheme($theme);
            }
        }
        return $theme_code;
    }
    public function GetVi()
    {
        return $this->local_vi ?? $this->session->get(self::SESSION_VI_KEY);
    }
    
    
    
    
    public function GetThemeStyle() : StyleOptions
    {
        try {
            $_edeeab025de2d468f501823d795c6a7a = $this->theme_repo->GetByCode($this->GetThemeCode());
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $_edeeab025de2d468f501823d795c6a7a = $this->global_style_storage;
        }
        return $this->theme_style->GetStyle($_edeeab025de2d468f501823d795c6a7a);
    }
}