<?php
////////////////////////////////////////////////////////////////////////////////
// WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!!
//
// This file should NOT be changed. If you want to change any of the values
// defined here, copy them into config.php. Values defined in config.php
// override ones specified in this file
//
// If you do any changes in this file they will be lost during the next upgrade

// This file contains the following sections below:
//   Database and core configuration
//   Users login and accounts control
//   Documents application configuration
//   Publish configuration
//   Users list and fields configuration
//   Instant Messages configuration
//   Forum configuration
//   Webmail configuration
//   News configuration
//   Blog configuration
//   Calendar/planning configuration
//   Other non-specific visual configurations
//   Infocapture configuration
//   Charts/Dashboard configuration
//   Image Gallery configuration
//   Holidays planner configuration
//   Charsets and localization settings
//   Survey and polls configuration
//   CDN configuration
//   Telemetry configuration

// detect base location of Claromenits installation
$BASE_LOCATION = realpath(__DIR__."/../../").'/';
$INTRANET = $BASE_LOCATION."intranet";
$BASE_HOST = isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : 'localhost';

// binaries dir (where Zip is located)
$binDir = $BASE_LOCATION.'../bin/';
$binDir = str_replace('\\\\', '\\', $binDir); // fix for WIN32 platform


// Database type - 'mysql' or 'mssql'
$cfg_db_type = 'mysql';

// Database credentials
$cfg_db_name = "claromentis";
$cfg_db_user = "claromentis";
$cfg_db_pass = "";
$cfg_db_host = "localhost";

// Enable persistent connections to the database
$cfg_db_pconnect = true;

// Additional options for the database connection
$cfg_db_extra_options = [
//	'mysql_charset' => 'utf8mb4',
//	'mysql_collation' => 'utf8mb4_unicode_ci',
//	'mssql_charset' => 'UTF-8',
//	'mssql_application_intent' => 'ReadWrite'
//	'mssql_multi_subnet_failover' => 'Yes',
//	'mssql_transparent_ip_resolution' => 'Enabled'
];

// PDF conversion daemon connection info
$cfg_converter_host = 'localhost';
$cfg_converter_port = 3100;
$cfg_converter_timeout = 120;

// Elasticsearch index name. Multiple instances of Claromentis can share the same ElasticSearch service
// providing they use different index name.
$cfg_search_index_name = 'claromentis';

// Additional parameters for constructing ElasticSearch client object. List of options can be found here:
//  http://www.elasticsearch.org/guide/en/elasticsearch/client/php-api/current/_configuration.html
// but the most likely, only "hosts" property may be needed
$cfg_search_es_options = array(
	//'hosts' => array('localhost' /*can include several elements */),
	//'logging' => true,
);

// Elasticsearch Version. Possible values are "1.x" or "7.x"
$cfg_search_es_version = "7.x";

// location of wkhtmltopdf binary
$cfg_wkhtmltopdf_bin = $WIN32 ? "C:\\Program Files\\wkhtmltopdf\\bin\\wkhtmltopdf.exe" : '/usr/local/bin/wkhtmltopdf';

// Method of images resizing for creating thumbnails
//  'IM'           - ImageMagick
//  'GD' or 'GD2'  - PHP GDlib v2
//
// Warning! Not all versions of GD support GIF format
$image_resize_method = 'GD';

// location of imageMagick binary (if $image_resize_method is 'IM')
$imageMagickBin = "/usr/bin/convert";

// location of pdf2swf binary
$cfg_pdf2swf_bin = $WIN32 ? "C:\\Program Files\\SWFTools\\pdf2swf.exe" : '/usr/local/bin/pdf2swf';

// a name for "From" field for outgoing emails
$systemName = "Claromentis Digital Workplace";

// an email for "From" field for outgoing emails
$systemEmail = "noreply@claromentis.com";

// Canonical system base URL, used when sending emails with links to Claromentis pages. Useful for intranet systems
// sometimes accessed by IP address or with reverse proxy configuration.
// If empty, the system uses the URL by which it is accessed.
// Example values:
//   'http://system.myintranet.com', 'https://intranet.company.com', 'http://intranet.company.com:8080'
// Do not include trailing slash at the end of the URL
// See also $cfg_system_url_enforce
$cfg_system_url = '';

// If the canonical URL specified ($cfg_system_url), the system ensures that it's accessed only via that URL and
// redirects to it, if detects a different one. But in certain configurations, usually behind a reverse proxy or
// load balancer, this redirect is not needed, while $cfg_system_url still needs to be specified.
// This option can be used to disable forced redirection to canonical URL.
$cfg_system_url_enforce = true;

// DATE FORMAT OPTIONS:
//
// j   = 1 or 2-digit Day
// d   = 2-digit Day
// n   = 1 or 2-digit Month
// m   = 2-digit Month
// y   = 2-digit Year
// Y   = 4-digit Year

// F   = Long month name in letters
// f   = Long month name in genitive case (in letters)
// M   = 3-letter month abbreviation
// l   = weekday name in initial caps
// D   = 3-letter weekday abbreviation in initial caps

// H    = Hours with leading zeros, 24-h format
// h    = Hours with leading zeros, 12-h format
// g    = Hours without leading zeros, 12-h format
// i    = Minutes with leading zeros
// a    = am/pm indicator for time
$cfg_date_format = [
	'time' => 'H:i',  // time
	'brief_date' => 'j M',     // very short date without year
	'short_date' => 'd-m-Y',   // compact full date, used in date picker
	'long_date' => 'j f Y',    // long date, most commonly used
	'full_date' => 'l, j f Y', // widest date format, with weekday name
	//'datetime' => 'd-m-Y H:i', // optional format of date with time. If unset, combination of 'short_date' and 'time' is used
];


// Force default timezone for the system. If not set, it'll be determined automatically basing on server timezone settings.
//$cfg_date_timezone_default = 'Europe/London';

// Error reporting config
$cfg_error_reporting_url = 'https://bugtracker.claromentis.net/report_error.php';

// Enabled claromentis plugins
$cfg_cla_plugins = array(
//    "PmPlugin",
);

// Memory/disk caching engine order. They are tried in order of appearance in this array. Set to empty array to disable caching.
// Make sure to set up isolated caches if multiple instances of Claromentis are running on the same server.
$cfg_cache_engines = array(
	'zend_shm',
	'zend_disk',
//	'memcache',
);

// Options for Memcache. Again, make sure to set up isolated caches if multiple instances of Claromentis are running on the same server.
// To connect using UNIX socket, specify something like "unix:///path/to/memcached.sock" for host name and 0 for port number.
$cfg_memcache_options = array(
	'host' => 'localhost',
	'port' => 11211,
	'use_persistent' => false,
	'skip_errors' => false,
);

// Custom REST handlers. This is an associative array where key is application code and value is a class name.
// Class should be located in a folder where it can be found by autoloader.
// Example: $cfg_rest_applications['bespoke'] = 'BespokeClassName';
$cfg_rest_applications = array();

// Array of PHP classes names to start on every page load. More details here - http://dev.claromentis.com/wiki/claromentis:development:page_load_hooks
$cfg_page_load_hooks = array();


// Archivers configuration. 'php_zip' and 'php_rar' are boolean values meaning Claromentis will
// try to use corresponding PHP extensions, if available, to create and unpack archives.
// Paths to binary files can be empty - in this case, bundled versions will be used (from web/bin/ folder)
$cfg_archive_options = array(
	'php_zip' => true, // use ZipArchive PHP extension if available
	'php_rar' => true, // use RarArchive PHP extension if available
	'bin_zip' => $WIN32 ? '' : '/usr/bin/zip',   // path to zip binary (not used on Windows)
	'bin_7zip' => $WIN32 ? '' : '/usr/bin/7za',  // path to 7z.exe or 7za, used to extract archives (and create them on Windows)
	'bin_unrar' => '', // path to unrar binary
);


// Logging configuration. Possible log levels are (by decreasing verbosity):
//   'debug', 'info', 'notice', 'warning', 'error', 'critical', 'alert', 'emergency'
$cfg_log_level = array();
$cfg_log_level['_default'] = 'warning';
$cfg_log_level['background'] = 'info';
$cfg_log_level['system'] = 'warning';

// Can be either 'quiet' or 'standard'. Quiet mode will not report PHP notices (E_NOTICE) and deprecation issues (E_DEPRECATED).
// "standard" mode will cause these errors to be reported if $cfg_developer_mode is non-zero.
$cfg_error_reporting = 'standard'; // 'quiet'

// Log notices and warnings into the log file even if they are not shown according to $cfg_error_reporting and $cfg_developer_mode
// Note, this may affect performance, but helps troubleshoting without disrupting users' experience
$cfg_error_log_warnings = false;

//====================================================================================================================================
// Users login and accounts control
//====================================================================================================================================

// Flag, enable/disable autocomplete for username and password fields in the login form
$cfg_login_autocomplete = true; // Set to "false" to disable autocomplete

// Flag, showing if guest access is enabled
$cfg_enable_guest_access = false; // Set to "true" to enable guest access

// Lock user session to IP address. So when IP address changes the user will have to log on again
$cfg_bind_session_to_ip = false;

// Pasword policy default values
$password_policy_min_length = 8;
$password_policy_change_next_time = 0;	// force change password next time user login
$password_policy_request_strong = 0;	// request strong password
$password_policy_force_change = 0;		// force changing after each n days
$password_policy_password_change_period = 30;	// seting n for force changing :)
$password_policy_password_block_period = 15;	// block account if user inactive m days after he must to change password

// period in days of how long the password recovery link is valid
$cfg_password_recovery_link_TTL = 3;

// Password hashing algorythm. Possible values are 'md5', 'sha1', 'bcrypt'.
// It's allowed to change this on runtime - the passwords will be re-hashed when users log in or change passwords.
// Claromentis prior to 7.2 was using md5. 'bcrypt' is now strongly recommended.
$cfg_password_hash_type = 'bcrypt';

// Complexity factor for 'bcrypt' hash. Value 10 results in about 0.1 second for generating the hash on a fast computer.
// Increasing this by 1 doubles the calculation time. Valid values are from 4 to 31 (but keep in mind the exponential growth of complexity)
$cfg_bcrypt_iterations = 10;

// External users directories. These are either arrays of configurations or names of services that
// implement UsersDirectoryAccessor interface
$cfg_users_directories = array();
$cfg_users_directories[] = 'user.directory.ldap_directory';


// NTLM autologon mode
//  NTLM_NONE       - NTLM is off, no autologon
//  NTLM_IIS        - NTLM is on, integrated authentication in IIS
$NTLM_MODE = NTLM_NONE;

// Default login method.  Can be either 'auto' or 'form'.
// In 'auto' mode the system tries using NTLM if it is configured.
// In 'form' mode, the web form authentication is used.
$cfg_preferred_login_method = 'auto';

$cfg_custom_login_handlers = array();
// Custom login handlers can be defined here. This should be an array of classes names.
// Each class should be inherited from LoginHandler base class and located in folder where it can be found by autoloader
//$cfg_custom_login_handlers[] = 'LoginHandlerCustom';

//====================================================================================================================================
// Documents application configuration
//====================================================================================================================================

// EMRS features configuration contstants.
$cfg_docs_features[ERMS_CONFIG_RECORD] = false;
$cfg_docs_features[ERMS_CONFIG_MARKERS] = false;
$cfg_docs_features[ERMS_CONFIG_RECORD_TYPES] = true;
$cfg_docs_features[ERMS_CONFIG_MULTICOMPONENT_DOCUMENT] = false;
$cfg_docs_features[ERMS_CONFIG_SECURITY_LEVEL] = false;
$cfg_docs_features[ERMS_CONFIG_MD5_SIGNATURE] = true;
$cfg_docs_features[ERMS_CONFIG_EXPORT_IMPORT] = false;
$cfg_docs_features[ERMS_CONFIG_SCHEDULE] = false;
$cfg_docs_features[ERMS_CONFIG_GDOC_LINKS] = true;
$cfg_docs_features[ERMS_CONFIG_ONEDRIVE_LINKS] = true;

// Prefix for automatically generated marker title
// Marker title can be automatically generated as "prefix{doc_id}" where "{doc_id}" is unique number of new marker
$cfg_marker_auto_generation_prefix = "Marker_";

// If folder name should be unique within one level
$cfg_check_folder_name_unique = true;

// If document name should be unique within folder
$cfg_check_document_name_unique = true;

// Flag showing if version number in parenthesis should be added to document name when checking it out
$cfg_checkout_with_version_number = false;

// Array of file extensions disabled for uploading into DMS using web interface
$cfg_docs_forbidden_types = array("exe");

// Default columns to display in documents list in admin area. Possible options are:
//    'size', 'owner', 'date_last_modified', 'date_created', 'version_num', 'last_comment', 'link_to_pdf'
// Metadata fields should be marked with prefix '[m]' (e.g. '[m]description', '[m]comment').
// Note: title column is always displayed.
$cfg_docview_default = array(
	"size",
	"owner",
	"date_last_modified",
	"[m]description",
);

// Page size for displaying documents list. But pages navigation doesn't appear until there is at least $cfg_docview_no_paging_until items
$cfg_docview_page_size = 20;
$cfg_docview_no_paging_until = 40;

// Metadata field that's counted as "review date" metadata for documents and publish pages
$cfg_review_date_metadata = 'doc_review_date';

// Whether to allow documents admin to view and download documents.
// If set to false admin will be able to browse all documents and view their metadata, but not actual documents files.
$cfg_docs_admin_can_view = false;

// Whether to open document details (with preview) or the document itself when user clicks document name
// If set to false, clicking document title in the documents list will open the actual document (download)
$cfg_docs_list_opens_details = true;

// Default view type for the documents list. Note, this works only until a user changes the view the very first time
// after which the setting is stored in the user's profile.
// Possible values are: 'list', 'min-list', 'icons'
$cfg_docs_list_default_view = 'list';

// If preview with google viewer is enabled
$cfg_google_viewer_enabled = true;

// If people wth only view rights can see permissions
$cfg_docs_viewers_see_perms = true;

// Internet-facing Claromentis host specification to use with Google viewer. Should be set if Claromentis is installed
// in the intranet and can be accessed using internal IP address or name.
// If unset or empty, the URL by which Claromentis is accessed will be sent to Google.
$cfg_public_host = ''; // 'http://claromentis.company.com:81/' or 'https://ext.company.com/'

// Show the recent views of a document in the details tab
$cfg_docs_recent_views_enabled = true;

// file types that should never be open directly in browser window, but prompted to
// download and viewed with local application
$neverInlineFileTypes = array
(
	'.xls',
	'.xlsx',
//	'.doc',
);

// Enable interface debug mode. Leave false always
$interfaceDebug = false;

// Client ID and secret from Google API web application credentials (OAuth 2.0)
// Used for indexing content of Google documents links
$cfg_docs_google_auth = array(
	'client_id' => '',
	'client_secret' => ''
);

// Age at which FUU files should be cleaned up
// should be in the form <number> <unit>, where <number> is a string of digits,
// and <unit> is some unit of time; month, year, fortnight, etc.
$cfg_fuu_cleanup_time = '1 month';

//====================================================================================================================================
// Publish configuration
//====================================================================================================================================

// Maximum depth for including files in 'publish' area
$cfg_max_publish_nesting_depth = 4;

// Publish framing templates
$PUB_TEMPLATE_FRAMING[1] = array("category" => "Home",		"path" => "main/pub_main.html");
$PUB_TEMPLATE_FRAMING[11] = array("category" => "Intranet",		"path" => "main/pub_main_noright.html", "default" => true);
//$PUB_TEMPLATE_FRAMING[2] = array("category" => "Calendar",	"path" => "calendar/pub_calendar.html");
//$PUB_TEMPLATE_FRAMING[3] = array("category" => "Mail",		"path" => "mail/pub_mail.html");
//$PUB_TEMPLATE_FRAMING[4] = array("category" => "Documents",	"path" => "documents/pub_documents.html");
//$PUB_TEMPLATE_FRAMING[5] = array("category" => "People",	"path" => "people/pub_people.html");
//$PUB_TEMPLATE_FRAMING[6] = array("category" => "Publish",	"path" => "publish/pub_publish.html");
//$PUB_TEMPLATE_FRAMING[7] = array("category" => "Forum",		"path" => "forum/pub_forum.html");
//$PUB_TEMPLATE_FRAMING[8] = array("category" => "Communication","path" => "communication/pub_communication.html");
//$PUB_TEMPLATE_FRAMING[9] = array("category" => "Admin",		"path" => "admin/pub_admin.html");
//$PUB_TEMPLATE_FRAMING[10] = array("category" => "Help",		"path" => "help/pub_help.html");

// Flag showing if we allow inserting PHP code in publish fields
// But even if it's allowed, it'll work only on external pages unless $cfg_execute_PHP_in_publish is set to true
$cfg_allow_PHP_in_publish = false;

// Flag showing if we allow executing PHP code in publish fields when showing
// page in Claromentis (not external)
$cfg_execute_PHP_in_publish = false;

// Whether to use "start publish" and "end publish" dates in Publish application
$cfg_publish_use_publication_dates = true;

//====================================================================================================================================
// Users list and fields configuration
//====================================================================================================================================

// Allow guest access to People API v2 (/api/people/v2), requires $cfg_enable_guest_access = true
$cfg_people_api_guest_access = false;

// Size of userpic used for displaying in MyProfile and Admin > EditUser pages
$cfg_user_profile_image_width = 160;
$cfg_user_profile_image_height = 160;

// Size of userpic displayed in user profile when the smaller icon is clicked
$cfg_user_profile_image_large_width = 800;
$cfg_user_profile_image_large_height = 800;

// Size of metadata images on a user profile, setting height to zero makes aspect ratio free
$cfg_meta_image_width = 200;
$cfg_meta_image_height = 200;

// Set whether metadata images display in the sidebar
$cfg_user_profile_meta_image_in_sidebar = false;

// Search people by name only (in contrast to searching by all metadata as well)
$cfg_people_search_by_full_name_only = false;

// Metadata fields that should be used in people search. Reducing the number of searchable metadata can greatly improve
// the search speed in people application. Possible values are:
//   null - all metadata fields are used (assuming $cfg_people_search_by_full_name_only is not true)
//   array() - no metadata fields are used at all
//   array('usr_city', 'work_location', ....) - list of metadata fields keys
// Note, only simple text metadata fields are actually used in search. Incorrect or not searchable metadata keys are just ignored.
$cfg_people_metadata_search_fields = null;

// Max number of groups to show in the users list without switching to "+ N more"
//   0 means unlimited
$cfg_people_max_groups_in_list = 5;

// Max number of roles to show in the users list without switching to "+ N more"
//   0 means unlimited
$cfg_people_max_roles_in_list = 5;

// If the user has no profile image uploaded, what should we show?
// 'default' is the normal Claromentis blank user silhouette, also supported are various gravatar types such as
// 'identicon' and 'retro'.
$cfg_missing_user_avatar = 'default';

// Show and edit this fields on "My settings" page:
// $cfg_mysettings_fields must be array of fields
// Default fields are listed below:
$cfg_mysettings_fields = array(
		"whats_new_list",
		"notification_method",
		"notify_on_checkin",
		"language",
		"skin",
//		"codepage_settings",
	);

// Show this fields in listcontacts.php:
// $cfg_contact_list_default_fields must be array of fields, order matters
// Available fields:
//	"title",				//Title
//	"firstname",			//Firstname
//	"surname",				//Surname
//	"role",					//Job Title
//	"company",				//Company
//	"work_location",		//Office Location
//	"city",					//City
//	"landline",				//Land line
//	"emailad",				//E-Mail
//	"mobile",				//Mobile
//	"pref_contact",			//Preferred contact method
//	"usercomments",			//Comments
//	"owner",				//Owner (with link)
//	"date1",				//Creation date
//	"contact_type",			//Contact Type
//	"date_last_review",		//Last Review Date
// Metadata fields should be specified with prefix [m] (i.e. "[m]usr_rank")
// Additional fields from assigned to user CRM Company should be specified with prefix [cc] Available fields:
//	"[cc]name",				//CRM Company name (with link)
//	"[cc]description",		//Description of the company
//	"[cc]fax",				//Fax of the company
//	"[cc]country",			//Country of the company
//	"[cc]region",			//Region of the company
//	"[cc]city",				//Description of the company
//	"[cc]address",			//Address of the company
//	"[cc]zipcode",			//ZipCode of the company
// Available action fields for each contact:
//	"view_item",			//Icon to view full contact info
//	"copy_item",			//Icon to copy contact info to the clipboard
//	"edit_item",			//Icon with text to edit contact info
//	"delete_item",			//Icon with text to delete contact

$cfg_contact_list_default_fields = array(
	"view_item",			//Icon to view full contact info
	"title",				//Title
	"firstname",			//Firstname
	"surname",				//Surname
	"role",					//Job Title
//	"[cc]name",				//CRM Company name (with link)
//	"[cc]fax",				//Fax of the company
//	"[cc]country",			//Country of the company
//	"[cc]region",			//Region of the company
//	"[cc]city",				//Description of the company
//	"[cc]address",			//Address of the company
	"company",				//Company
	"landline",				//Land line
	"emailad",				//E-Mail
	"mobile",				//Mobile
	"contact_type",			//Contact Type
//	"edit_item",			//Icon with text to edit contact info
//	"delete_item",			//Icon with text to delete contact
	"manage_item",			//Pair of icons to edit and delete contact in the same table column
);

// "Contact type" values for contacts
$cfg_contact_types = array(
	1 => "Client",
	0 => "Personal acquaintance",
	2 => "Supplier",
	3 => "Partner"
);

// Notification about user profile expiration.
// To notify users when they don't update their profile for a long time, specify user metadata field here. This field will contain the date
// when profile was updated the last time. Leave unset to not to use this function.
//
// If its needed to dispay this field on people profile page or make editable in admin area, need to add description
// of that field in Metadata admin panel.
//   Key: pick key other than "usr_profile_last_updated" and set $cfg_profile_last_updated_field = this key
//   Title: pick title (i.e. "Profile Last Updated")
//   Type: "datetime"
//you can't create metadata field with key "usr_profile_last_updated", it is system metadata
//
// (note that field type must be "datetime")
$cfg_profile_last_updated_field = ""; // "usr_profile_last_updated";

// after this period of time user profile become outdated (days)
$cfg_profile_default_notification_period = 30;

// after user profile became outdated and has not been updated by user, send notification again every ... days
$cfg_profile_default_notification_interval = 2;

// Format for displaying user/contact name in system. Possible values are '{fname} {sname}', '{sname} {fname}' or '{sname}, {fname}'
$cfg_name_format = '{fname} {sname}';

// Whether to display job title along with name in permissions dialog
$cfg_perms_show_user_title = false;

// Require entering username when recovering lost password. If set to false, only email address is required.
$cfg_recover_require_username = false;

// Make "social profile" elements visible on "view profile" page
// These are feeds from innovate, twitter, linkedin etc.
//  Uses metadata fields "usr_linkedin" and "usr_twitter"
$cfg_profile_social_visible = false;

// Default tab to show on "view profile" page - either 'profile' or 'activity'
$cfg_profile_default_tab = 'profile';

// Default value for objects types to display in "what's new" for new users.
// Comma-separated list of objects types. Supported types:
//    document, pub_page, folder, forum_message, kb_article
$cfg_default_whats_new_list = 'pub_page,document,forum_message';

// twitter authentication details
// https://dev.twitter.com/
// create a new application in order to generate credentials
$cfg_twitter_consumer_key =     "";
$cfg_twitter_consumer_secret =  "";
$cfg_twitter_access_token =     "";
$cfg_twitter_token_secret =     "";

// Max number of users to display in multi-user picker in admin area when editing a group or role
// If number of users in a group/role exceeds this value, the membership can be changed from the user profile page
$cfg_people_max_per_group_admin = 100;

// whether to show the "manager" and "direct reports" sections
$cfg_people_profile_show_manager = 1;
$cfg_people_profile_show_reports = 1;

//====================================================================================================================================
// Instant Messages configuration
//====================================================================================================================================

// Background IMs check mode.
//  0 - do not check for new IMs in background at all
//  1, 2 or 3 - check for new IMs in background and if new one found, change the number of new messages shown at the top
$cfg_allow_background_IM_check = 3;

// I-Messages background check period, in seconds
$cfg_IM_check_period = 30;

// $cfg_default_notification_method specifies default notification method for user
// This value is used only when a new user is being created
// This is a bitmask
// 1  - push
// 2  - IM
// 4  - email
// 8  - daily digest
// 16 - weekly digest
// 32 - monthly digest
$cfg_default_notification_method = 2;

// Default length of storing read notifications (instant messages) in users' inboxes, in days
// Acceptable values are -1, 7, 30, 92, 184, 356. -1 means notifications are never deleted automatically
$cfg_IM_default_lifetime = 92;

// When to disclose sender's email in 'Reply-to' field when Instant Message is sent by email
//
// Possible values are:
//   IM_REPLY_ALWAYS - always shows reply to field
//   IM_REPLY_SAME_AREA - shows reply to only if message sent inside one area
//   IM_REPLY_PRIMARY_AREA - shows reply to only if sender or recepient or both are from primary extranet area
//   IM_REPLY_NEVER - never shows reply to field
$cfg_im_email_disclose = IM_REPLY_ALWAYS;

// Time digest notifications are processed
$cfg_notification_digest_time = '07:00';

//====================================================================================================================================
// Forum configuration
//====================================================================================================================================

// How many topics per page to show in forum
$cfg_forum_page_size = 30;

// Default forum mode, one of
//   FORUM_MODE_FLAT - display forum in flat mode
//   FORUM_MODE_TREE - display forum in tree mode
$cfg_forum_mode = FORUM_MODE_FLAT;

// Specifies whether to include or not forum post content into IM notification body
$cfg_forum_notification_resp = true;

//Phrases to show in title for rating in forum
// Elements of this array can be simple string or
// strings in format %localized.message.code where
// localized.message.code is the name localization string
$cfg_forum_rating_phrases = array (
	"%forum.rating.phrase_0",
	"%forum.rating.phrase_1",
	"%forum.rating.phrase_2",
	"%forum.rating.phrase_3",
	"%forum.rating.phrase_4"
);

//Subject template is a string with placeholders for various details about forum post.
//1.	#board# - forum board name
//2.	#category# - forum category name
//3.	#subject# - new message subject
//4.	#topic_subject# - original topic subject
//5.	#replies_num# - number of replies in the topic
//6.	#action# - what has triggered the notification. Replaced with "New topic" or "Reply�
//7.	#author# - message author
//8.	#topic_author# - author of original topic
$cfg_forum_notification_subject = "Forum - #board# (#category#) #subject# (#replies_num#): #action# by #author# -- #topic_subject# #topic_author#";

// Default settings for "Get notification on message replies" when creating a new forum post
$cfg_forum_notify_on_replies = 0;

// Default settings for "Get notification on all new messages in topic" when creating a new forum post
$cfg_forum_notify_on_topic = 1;

//====================================================================================================================================
// Webmail configuration
//====================================================================================================================================

// $cfg_mail_send_driver might be one of the following: "mail", "sendmail", "smtp", "file"
//   mail     - send using PHP built-in function mail(), which uses smtp on Windows and local mail agent on Linux
//   sendmail - send using command line Linux program "sendmail"
//   smtp     - directly connect to the specified SMTP server and send emails. Can be slow!
//   file     - do not actually send anything, but dump all emails as files to the specified folder (mainly for debug)
$cfg_mail_send_driver = "mail";

// Mail Queue: How many mails could we send each time the background script is called
$cfg_mail_queue_max_mails = 1000;

// $cfg_mail_send_params is an assotiative array
//	depending on the value of $cfg_mail_send_driver
//
// sendmail
//      $cfg_mail_send_params["sendmail_path"] - The location of the sendmail program on the filesystem. Default is /usr/bin/sendmail
//      $cfg_mail_send_params["sendmail_args"] - Additional parameters to pass to the sendmail. Default is -i
// smtp
//      $cfg_mail_send_params["host"] - The server to connect. Default is localhost
//      $cfg_mail_send_params["port"] - The port to connect. Default is 25
//      $cfg_mail_send_params["auth"] - Whether or not to use SMTP authentication. Default is FALSE
//      $cfg_mail_send_params["username"] - The username to use for SMTP authentication. (seems to only work with TLS authentication)
//      $cfg_mail_send_params["password"] - The password to use for SMTP authentication.
//      $cfg_mail_send_params["localhost"] - The value to give when sending EHLO or HELO. Default is localhost
//      $cfg_mail_send_params["timeout"] - The SMTP connection timeout. Default is NULL (no timeout)
//      $cfg_mail_send_params["verp"] - Whether to use VERP or not. Default is FALSE
//      $cfg_mail_send_params["debug"] - Whether to enable SMTP debug mode or not. Default is FALSE
//      $cfg_mail_send_params["persist"] - Indicates whether or not the SMTP connection should persist over multiple calls to the send() method.
// file
//      $cfg_mail_send_params["path"] - folder where to put the email messages, without trailing slash
$cfg_mail_send_params = array();


//====================================================================================================================================
// News configuration
//====================================================================================================================================

// News image dimensions. Uploaded image will be resized by specified dimensions only
// so if only height is specified, resiged image will have this height and width will
// be chosen to keep aspect ratio.
// Note, if both dimensions are specified, image will be resized to this size and might
// be distorted.
// Zero value means the same as not specified at all.
$cfg_headline_news_image_width = 320;
$cfg_headline_news_image_height = 240;
$cfg_headline_news_image_width_big = 700;
$cfg_headline_news_image_height_big = 0;

// Default number of news items displayed on intranet home page
$cfg_headline_news_number = 5;

// Number of symbols to truncate news text abstract displayed on intranet home page
$cfg_headline_news_text_truncate = 180;

// Number of items displayed per page. Note: first news page will have an extra item added to this number.
$cfg_headline_news_items_per_page = 9;

// Options for sanitizing user-supplied HTML in "full news text" to prevent XSS
// Possible values: 'none', 'default', 'strict' or array of options.
// Note, 'strict' doesn't allow iframes and custom styles
$cfg_news_sanitize_options = 'default';

// Default to showing comments by default
$cfg_news_show_comments = true;

// RSS - Include news article content in the RSS feed
$cfg_news_rss_article_content = false;

//====================================================================================================================================
// Blogs configuration
//====================================================================================================================================

// Blog image dimensions. Uploaded image will be resized by specified dimensions only
// so if only height is specified, resiged image will have this height and width will
// be chosen to keep aspect ratio.
// Note, if both dimensions are specified, image will be resized to this size and might
// be distorted.
// Zero value means the same as not specified at all.
$cfg_blog_image_width = 320;
$cfg_blog_image_height = 240;
$cfg_blog_image_width_big = 640;
$cfg_blog_image_height_big = 0;

// Options for sanitizing user-supplied HTML in "full blog text" to prevent XSS
// Possible values: 'none', 'default', 'strict' or array of options.
// Note, 'strict' doesn't allow iframes and custom styles
$cfg_blog_sanitize_options = 'default';

//====================================================================================================================================
// Calendar/planning configuration
//====================================================================================================================================

// System calendars providers. Deprecated - applications should extend service 'calendar.providers' instead
$cfg_cln_system_calendars = [];

// URL for MS Exchange Web Access. If not set, web access won't be available.
$cfg_exchange_web_access_url = '';

// Default period length for room booking diagram (0 - week, 1 - BiWeek, 2 - day)
$cfg_default_room_booking_view = 0;

// Default calendar view mode. Can be one of "month", "biweek", "week", "day", "agenda"
// Applied only for new users, after which user's preferences are persisted between sessions
$cfg_calendar_default_view_mode = "month";

// Date range for iCal calendar export (standart strtotime format: +\- N month\week\days, where N -- integer: 1,2,3...). May be empty
$cfg_calendar_export_ical_from = "-1 month";
$cfg_calendar_export_ical_to = "";

//default value for first day of the week in calendar/min-calendar/my holidays  (Sunday=0, Monday=1, Tuesday=2, etc.)
$cfg_calendar_first_day = 1;

// The number of hours between each synchronization, default value is 24
$cfg_calendar_hours_between_sync = 24;

//====================================================================================================================================
// Other non-specific visual configurations
//====================================================================================================================================

// Intranet entry page - the one where users redirected after log in
$cfg_intranet_entry_page = "/main/";

// Allow guests to see intranet/main/index.php page
$cfg_main_index_page_allow_guest = true;

// Maximum age (in days) for items to show in "what's new".
// 0 means no age limit. WARNING! This may cause what's new to work slowly
$cfg_whats_new_max_age = 0;

// Default type of "owners" shown in perms dialog in popup
// Possible values are: 'special', 'exarea', 'role', 'group', 'grouptree', 'individual'
$cfg_perms_dialog_default_oclass = 'grouptree';

// VI for guests
$cfg_guest_vi = "guest_default";

// VI used for displaying login and password recovery pages
$cfg_login_vi = "default";

// Number of new entries to show in metadata dialog for repeatable elements
$cfg_meta_new_repeatable_count = 5;

// equivalence between file extensions and mime types
$arExtensions = array
(
	'.htm' => "text/html",
	'.html' => "text/html",
	'.shtml' => "text/html",
	'.txt' => "text/plain",
	'.xml' => "application/xml",
	'.js' => "text/javascript",
	'.json' => "application/json",
	'.css' => "text/css",
	'.csv' => "text/csv",
	'.ics' => "text/calendar",
	'.pdf' => "application/pdf",
	'.zip' => "application/zip",
	'.bz' => "application/bzip",
	'.bz2' => "application/bzip2",
	'.7z' => "application/7z",
	'.gz' => "application/gzip",
	'.rtf' => "application/rtf",

	'.doc' =>	"application/msword",
	'.docx' =>	"application/vnd.openxmlformats-officedocument.wordprocessingml.document",
	'.docm' =>	"application/msword",
	'.dot'	=>	"application/msword",
	'.dotx' =>	"application/vnd.openxmlformats-officedocument.wordprocessingml.template",
	'.dotm' =>	"application/msword",
	'.odp' => "application/vnd.oasis.opendocument.presentation",
	'.ods' => "application/vnd.oasis.opendocument.spreadsheet",
	'.odt' => "application/vnd.oasis.opendocument.text",
	'.pages' => "application/vnd.apple.pages",


	'.xls' => "application/ms-excel",
	'.xlsx' => "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
	'.xltx' => "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
	'.xltm' => "application/ms-excel",
	'.xlsb' => "application/ms-excel",
	'.xlam' => "application/ms-excel",
	'.numbers' => "application/vnd.apple.numbers",

	'.ppt' => "application/ms-powerpoint",
	'.pptx' => "application/vnd.openxmlformats-officedocument.presentationml.presentation",
	'.pptm' => "application/ms-powerpoint",
	'.potx' => "application/vnd.openxmlformats-officedocument.presentationml.template",
	'.potm' => "application/ms-powerpoint",
	'.ppam' => "application/ms-powerpoint",
	'.ppsx' => "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
	'.ppsm' => "application/ms-powerpoint",
	'.keynote' => "application/vnd.apple.keynote",

	'.msg' => 'application/vnd.ms-outlook',
	'.eml' => 'application/octet-stream',
	'.emlx' => 'message/x-emlx',
	'.oft' => 'application/vnd.ms-outlook',
	'.ost' => 'application/vnd.ms-outlook',
	'.pst' => 'application/vnd.ms-outlook',
	'.vcf' => 'text/plain',

	'.vsd' => "application/visio",
	'.gif' => "image/gif",
	'.tif' => "image/tiff",
	'.tiff' => "image/tiff",
	'.jpg' => "image/jpeg",
	'.jpeg' => "image/jpeg",
	'.png' => "image/png",
	'.bmp' => "image/bmp",
	'.svg' => "image/svg+xml",
	'.heic' => "image/heic",
	'.webp' => "image/webp",
	'.dng' => "image/x-adobe-dng",
	'.eps' => "application/postscript",
	'.ai' => "application/illustrator",
	'.sketch' => "application/zip",
	'.psd' => "image/vnd.adobe.photoshop",

	'.avi' => 'video/x-msvideo',
	'.mpeg' => 'video/mpeg',
	'.mp4' => 'video/mp4',
	'.webm' => 'video/webm',
	'.ogv' => 'video/ogg',

	'.aac' => 'audio/aac',
	'.mp3' => 'audio/mpeg',
	'.ogg' => 'audio/ogg',
	'.oga' => 'audio/ogg',
	'.wav' => 'audio/wav',
	'.weba' =>'audio/webm'
);

/**
 * Used when uploading files in comments to only allow specific file types.
 */
$cfg_allowed_file_upload_types = [
	'htm' => "text/html",
	'html' => "text/html",
	'shtml' => "text/html",
	'txt' => "text/plain",
	'xml' => "application/xml",
	'js' => "text/javascript",
	'json' => "application/json",
	'css' => "text/css",
	'csv' => "text/csv",
	'ics' => "text/calendar",
	'pdf' => "application/pdf",
	'zip' => "application/zip",
	'bz' => "application/bzip",
	'bz2' => "application/bzip2",
	'7z' => "application/7z",
	'gz' => "application/gzip",
	'rtf' => "application/rtf",

	'doc' =>	"application/msword",
	'docx' =>	"application/vnd.openxmlformats-officedocument.wordprocessingml.document",
	'docm' =>	"application/msword",
	'dot'	=>	"application/msword",
	'dotx' =>	"application/vnd.openxmlformats-officedocument.wordprocessingml.template",
	'dotm' =>	"application/msword",
	'odp' => "application/vnd.oasis.opendocument.presentation",
	'ods' => "application/vnd.oasis.opendocument.spreadsheet",
	'odt' => "application/vnd.oasis.opendocument.text",
	'pages' => "application/vnd.apple.pages",


	'xls' => "application/ms-excel",
	'xlsx' => "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
	'xltx' => "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
	'xltm' => "application/ms-excel",
	'xlsb' => "application/ms-excel",
	'xlam' => "application/ms-excel",
	'numbers' => "application/vnd.apple.numbers",

	'ppt' => "application/ms-powerpoint",
	'pptx' => "application/vnd.openxmlformats-officedocument.presentationml.presentation",
	'pptm' => "application/ms-powerpoint",
	'potx' => "application/vnd.openxmlformats-officedocument.presentationml.template",
	'potm' => "application/ms-powerpoint",
	'ppam' => "application/ms-powerpoint",
	'ppsx' => "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
	'ppsm' => "application/ms-powerpoint",
	'keynote' => "application/vnd.apple.keynote",

	'msg' => 'application/vnd.ms-outlook',
	'eml' => 'application/octet-stream',
	'emlx' => 'message/x-emlx',
	'oft' => 'application/vnd.ms-outlook',
	'ost' => 'application/vnd.ms-outlook',
	'pst' => 'application/vnd.ms-outlook',
	'vcf' => 'text/plain',

	'vsd' => "application/visio",
	'gif' => "image/gif",
	'tif' => "image/tiff",
	'tiff' => "image/tiff",
	'jpg' => "image/jpeg",
	'jpeg' => "image/jpeg",
	'png' => "image/png",
	'bmp' => "image/bmp",
	'svg' => "image/svg+xml",
	'heic' => "image/heic",
	'webp' => "image/webp",
	'dng' => "image/x-adobe-dng",
	'eps' => "application/postscript",
	'ai' => "application/illustrator",
	'sketch' => "application/zip",
	'psd' => "image/vnd.adobe.photoshop",

	'avi' => 'video/x-msvideo',
	'mpeg' => 'video/mpeg',
	'mp4' => 'video/mp4',
	'webm' => 'video/webm',
	'ogv' => 'video/ogg',

	'aac' => 'audio/aac',
	'mp3' => 'audio/mpeg',
	'ogg' => 'audio/ogg',
	'oga' => 'audio/ogg',
	'wav' => 'audio/wav',
	'weba' =>'audio/webm'
];

// Whether to remove quotes around HTML attributes if the value is simple
// This slightly reduces the output html size
$cfg_tmpl_strip_quotes = true;

// Templater cache options:
//    'cache_localization' - create cache with localization messages preprocessed, works faster, but still experimental
//    'revalidate_freq' - how frequently the compiled templates should be verified, in seconds. 0 means never, -1 means every time
$cfg_tmpl_cache_options = array(
	'cache_localization' => true,
	'revalidate_freq' => -1,
);

// Crop tool and image processing options

// If set to false, processed GIFs will not be animated
$cfg_image_allow_animated_gif = true;

// Maximum filesize in bytes to allow for animated GIF uploads
// Images exceeding this file size will not be animated when processed
// Defaults to 6MB
$cfg_image_animated_gif_max_size = 6*1024*1024;

// Maximum input width or height to allow for animated gif resizing and cropping
// Images exceeding this resolution will not be animated when processed
// Defaults to 1280 (1280x1280)
$cfg_image_animated_gif_max_input_dimensions = 1280;

// Maximum output width or height to allow for any GIF resizing and cropping
// Resize operations targeting resolutions larger than this will not be animated when processed
// Defaults to 1280 (1280x1280)
$cfg_image_animated_gif_max_output_dimensions = 1280;

//====================================================================================================================================
// Infocapture configuration
//====================================================================================================================================

// When checked on this flag allows to download issues in PDF format
$cfg_ic_allow_save_as_pdf = false;

// "From" address for InfoCapture notification emails
$cfg_ic_notification_from = "infocapture@".$BASE_HOST; // bim_notification_from

// Attachment file size limit. Note, actual size can be also limited by PHP configuration
$cfg_ic_attach_size_limit = 15*1024*1024; // 15 megabytes

// Specifies the maximum size below which an image attachment is previewed in the issue view page.  To disable this feature, set max size to 0.
$cfg_ic_attach_preview_max_size = 30000;

// issue number zero-padding - how many digits should have each issue ID
$cfg_ic_issue_pad = 6;

// issue number zero-padding - how many digits should have each issue ID for project with issue prefix
$cfg_ic_issue_prefix_pad = 4;

// Managed how status colour is used in table based information - either as a label (default) or as the row background colour.
$cfg_ic_status_color_highlighting = 0;

//====================================================================================================================================
// Charts/Dashboard configuration
//====================================================================================================================================

// List of Data Providers for Diagrams
$cfg_diagram_data_providers = array(
	1	=> 'LoginsDP',
);

// List of Diagrams
$cfg_diagrams = array(
	'cfg_0' => array("class_name" => "LoginsDiagram"),
);

//====================================================================================================================================
// Image Gallery configuration
//====================================================================================================================================

// Thumbnail size in images list
$cfg_gallery_thumb_width = 400;
$cfg_gallery_thumb_height = 250;

// Default resolution in "download/add to lightbox" selector on image details page
// Possible values are: 'native', 'large', 'medium', 'small'
$cfg_gallery_default_resolution = 'small';


//====================================================================================================================================
// Holidays planner configuration
//====================================================================================================================================

// Send holidays notification as an email with attached ical
$cfg_holidays_ical_notification = false;

// filter 'my team' holiday planner by group rather then by manager
$cfg_holidays_team_by_group = false;

// Whether to allow team members to view each others' holidays details
$cfg_holidays_view_team_details = false;

// Display calendar days along with effective days when applicable
$cfg_holidays_show_calendar_days = false;

// Reports page size
$cfg_holidays_report_pagesize_group = 20;

//====================================================================================================================================
// Charsets and localization settings
//====================================================================================================================================

// Default system language
$cfg_default_language = 'en';

// List of codepages supported by the system
$iconv_CP_list = array(
	"US-ASCII" => "American Standard Code for Information Interchange",
	"ISO-8859-1" => "ISO 8859-1, Latin alphabet No. 1",
	"ISO-8859-2" => "ISO 8859-2, Latin alphabet No. 2",
	"ISO-8859-3" => "ISO 8859-3, Latin alphabet No. 3",
	"ISO-8859-4" => "ISO 8859-4, Latin alphabet No. 4",
	"ISO-8859-5" => "ISO 8859-5, Latin/Cyrillic alphabet",
	"ISO-8859-6" => "ISO 8859-6, Latin/Arabic alphabet",
	"ISO-8859-7" => "ISO 8859-7, Latin/Greek alphabet",
	"ISO-8859-8" => "ISO 8859-8, Latin/Hebrew alphabet",
	"ISO-8859-9" => "ISO 8859-9, Latin alphabet No. 5",
	"ISO-8859-13" => "ISO 8859-13, Latin alphabet No. 7",
	"ISO-8859-15" => "ISO 8859-15, Latin alphabet No. 9",
	"KOI8-R" => "KOI8-R, Russian",
	"KOI8-U" => "KOI8-R, Ukrainian",
	"CP1250" => "Windows Eastern European",
	"CP1251" => "Windows Cyrillic",
	"CP1252" => "Windows Latin-1",
	"CP1253" => "Windows Greek",
	"CP1254" => "Windows Turkish",
	"CP1255" => "Windows Hebrew",
	"CP1256" => "Windows Arabic",
	"CP1257" => "Windows Baltic",
	"CP1258" => "Windows Vietnamese",
	"CP850" => "MS-DOS Latin-1",
	"CP862" => "PC Hebrew",
	"CP866" => "MS-DOS Russian",
	"MacRoman" => "Macintosh Roman",
	"MacCentralEurope" => "Macintosh Latin-2",
	"MacIceland" => "Macintosh Iceland",
	"MacCroatian" => "Macintosh Croatian",
	"MacRomania" => "Macintosh Romania",
	"MacCyrillic" => "Macintosh Cyrillic",
	"MacUkraine" => "Macintosh Ukraine",
	"MacGreek" => "Macintosh Greek",
	"MacTurkish" => "Macintosh Turkish",
	"MacHebrew" => "Macintosh Hebrew",
	"MacArabic" => "Macintosh Arabic",
	"MacThai" => "Macintosh Thai",
	"TIS-620" => "TIS620, Thai",
	"CP874" => "IBM Thai",
	"JIS_C6220-1969-RO" => "",
	"JIS_X0201" => "JIS X 0201, Japanese",
	"JIS_X0208" => "JIS X 0208, Japanese",
	"JIS_X0212" => "JIS X 0212, Japanese",
	"EUC-JP" => "JIS X 0201, 0208, 0212, EUC encoding, Japanese",
	"SHIFT_JIS" => "Shift-JIS, Japanese",
	"EUC-CN" => "GB2312, EUC encoding, Simplified Chinese",
	"GBK" => "GBK, Simplified Chinese",
	"EUC-TW" => "CNS11643 (Plane 1-3), EUC encoding, Traditional Chinese",
	"BIG5" => "Big5, Traditional Chinese",
	"CP950" => "PC Chinese (Hong Kong, Taiwan)",
	"EUC-KR" => "KS C 5601, EUC encoding, Korean",
	"CP949" => "PC Korean",
	"JOHAB" => "Johab, Korean",
	"UCS-2" => "16-bit Unicode Transformation Format",
//	"UCS-2BE" => "16-bit Unicode Transformation Format, big-endian",
//	"UCS-2LE" => "16-bit Unicode Transformation Format, little-endian",
	"UCS-4" => "",
//	"UCS-4BE" => "",
//	"UCS-4LE" => "",
	"UTF-8" => "8-bit Unicode Transformation Format",
	"UTF-16" => "16-bit Unicode Transformation Format", //, byte order specified by a mandatory initial byte-order mark
//	"UTF-16BE" => "",
//	"UTF-16LE" => "",
	"UTF-32" => "32-bit Unicode Transformation Format",
//	"UTF-32BE" => "",
//	"UTF-32LE" => "",
	"UTF-7" => "7-bit Unicode Transformation Format",
);

// Codepages aliases. Add new entries only if having problems with some codepage
// names not recognized. This is an addition to built-in aliases list, and has
// higher priority than default. Use all capitals in source codepage name
$iconv_CP_aliases = array(
//	"WINDOWS-1251" => "CP1251",
);


// Default code pages
$DEFAULT_CP_FILESYSTEM     = "UTF-8";
$DEFAULT_CP_VCF            = "UTF-8"; // contacts import
$DEFAULT_CP_INCOMING_MAIL  = "UTF-8";
$DEFAULT_CP_OUTGOING_MAIL  = "UTF-8";
$DEFAULT_CP_SYSTEM_MAIL    = "UTF-8"; // CP for outgoing system emails

// Standard charset used by executables to output information to STDOUT
$cfg_exec_charset = 'UTF-8';

// Charset for all IO operations with server filesystem
$cfg_server_fs_charset = 'UTF-8';

// Do not change this
$cfg_disable_token_check = false;

//====================================================================================================================================
// Survey and polls configuration
//====================================================================================================================================
$cfg_survey_image_width = 200;
$cfg_survey_image_height = 200;

//====================================================================================================================================
// CDN configuration
//====================================================================================================================================

// The CDN type can be any of the following values:
//   local     - Local CDN storage that defaults to the $APPDATA directory
//   amazon    - Amazon Web Services Simple Storage Service (AWS S3)
//   google    - Google Cloud Storage
$cfg_cdn_type = 'local';

// $cfg_cdn_options is an associative array and its required key/value pairs are
// dependent on the value of $cfg_cdn_type
//
// local:
//   $cfg_cdn_options['local_path'] - [optional] Defaults to $APPDATA. The local path for storing content. This can be a shared network drive.
//   $cfg_cdn_options['base_url']   - [optional] Defaults to "/appdata". The base URL from which content can be requested.
//
// amazon:
//   $cfg_cdn_options['aws_key']    - AWS Access Key ID
//   $cfg_cdn_options['aws_secret'] - AWS Secret Access Key
//   $cfg_cdn_options['bucket']     - AWS S3 bucket name
//   $cfg_cdn_options['region']     - AWS S3 bucket's region
//   $cfg_cdn_options['version']    - [optional] AWS API Version. Defaults to 'latest'.
//   $cfg_cdn_options['signature']  - [optional] Signature version used to sign AWS requests. Defaults to 'v4'.
//
// google:
//   $cfg_cdn_options['bucket']     - Google Cloud Storage bucket name
//   $cfg_cdn_options['json']       - Google API Service Account Credentials
//
//   Notes:
//     If the local CDN interface has no $cfg_cdn_options they default to the following:
//       $cfg_cdn_options['local_path'] = $APPDATA;
//       $cfg_cdn_options['base_url']   = "/appdata";
//
//     When using a shared drive on a local network for load balancing, use the
//     local CDN interface. Set 'local_path' to the shared drive's path and
//     'base_url' to the address of the web server corresponding to the shared drive.
//
//     Any non-local CDN configuration uses the "$DATA_DIR/cdn_mirror" directory to store CDN content.
//     This is used by some parts of Claromentis that need to read files directly.
//
//     Google API Service Account Credentials JSON
//     This will be different for every client, as they will need their own
//     service accounts for their systems.
//     The credentials JSON file can be generated here:
//       https://console.cloud.google.com/apis/credentials
//     Create credentials > Service account key
$cfg_cdn_options  = array();

// How frequently, in minutes, to check the integrity of the CDN database cache
// URLs against actual objects stored in CDN.
// Requires Claromentis\Admin\Utility\CdnChecker\Plugin to be registered as a
// plugin.
$cfg_cdn_check_interval = 60;

// Whether to log CDN checker logs to the cdn_utility_logs table
$cfg_cdn_check_database_log = false;

//====================================================================================================================================
// Staging server configuration
//====================================================================================================================================
// Message this is staging server will be displayed on every page if set to true
$cfg_is_staging = false;

//====================================================================================================================================
// Telemetry Configuration
//====================================================================================================================================
// This is the URI where telemetry payloads are sent.
$cfg_telemetry_endpoint = 'https://telemetry.claromentis.net/v1/';

//====================================================================================================================================
// Orgchart config
//=============================================================================================================================
$cfg_orgchart_image_width = 240;
$cfg_orgchart_image_height = 150;

//Number of days to keep objects in trash
$cfg_empty_trash_days = 30;

//=================
// Redis config
//=================

$CLARO_SESSION_HANDLER = 'FILE';
$CLARO_REDIS_MODE = 'NONE'; //Set to "MASTER" to enable redis
$CLARO_REDIS_SERVERS = 'tcp://localhost:6379?alias=master';

//==================================================================
// ".well_known" app endpoint configs for generic Claromentis apps
//==================================================================
$cfg_well_known_ios = [
	[
		'appId' => '4ZP5CF7YYH.com.claromentis.ios',
		'paths' => [
			"*"
		]
	]
];

$cfg_well_known_android = [
	[
		'relation' => [
			"delegate_permission/common.handle_all_urls"
		],
		'target' => [
			'namespace' => 'android_app',
			'package_name' => 'com.claromentis.app',
			'sha256_cert_fingerprints' => [
				"DA:17:8C:FF:DE:AE:C7:D0:3A:DE:B8:69:5D:A5:EA:9C:94:3B:7B:F7:B1:A9:33:4D:26:32:8E:D5:E8:47:64:EB"
			]
		]
	]
];
