<?php
namespace Claromentis\Core\Filesystem;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"] ?: array()) + array("_a606a2dcd" . "236a549db0" . "574a9c1675" . "927" => base64_decode("c" . "g" . "=" . "="), "typ" . "e" => base64_decode("dHl" . "wZQ" . "=="), "_87daa84e34" . "6f6420a3f34" . "26e05d16a7b" => base64_decode("Lw" . "=="), "s" . "i" . "z" . "e" => base64_decode("c2l6ZQ=" . "="), "_c91b0ff" . "19f81a88" . "73a4593a" . "23719472" . "c" => base64_decode("cnRyaW0" . "="), "_8aa39710a39f226efce" . "78e97c7bcd786" => base64_decode("XC8" . "="), "_18c93a3" . "2ba5faf9" . "509389a9" . "4787e679" . "8" => base64_decode("bW9kaWZpZW" . "Q="), "_32b8fa1ca330a0685321a379e5b9" . "687d" => base64_decode("YmFzZW5hb" . "WU="), "_9905761f" . "4393d105c" . "adfe7282a" . "8c518d" => base64_decode("bWltZXR5" . "cGU="), "_6ae3783b" . "9ad544a6c" . "31a979683" . "fed870" => base64_decode("ZmlsZQ" . "=="), "_1cc5aa2f679b575f82786a73f0da2" . "8f8" => base64_decode("c3Ry" . "ZWFt"), "_554a916913" . "8240019acbd" . "1502642f16a" => base64_decode("ZGlybmFtZ" . "Q=="), "_c4f3321d131869e" . "51a8844b6bcd8fb8" . "6" => base64_decode("ZG" . "ly"), "_5febae03aa5407c291" . "b5c61a872cc1fd" => base64_decode("aXNfcmVzb3V" . "yY2U="), "_e46a1b6a2f" . "d927d616377" . "ae17620d766" => base64_decode("dmlzaWJpbGl0eQ=" . "="), "_f2646618c9dcad156a41241eacc4c3f" . "7" => base64_decode("Z2V0X3Jlc" . "291cmNlX3" . "R5cGU="), "_01713acbc1c314b61bfbd8d" . "c10a810bd" => base64_decode("RXJyb3Igd3J" . "pdGluZyBmaW" . "xl"), "pa" . "th" => base64_decode("cGF0aA=" . "="), "_563b15b" . "92a77c86" . "9e85edf9" . "569b4d02" . "5" => base64_decode("Zm" . "Ns" . "b3" . "Nl"), "_6108a04" . "b8350bfd" . "2b7f2b23" . "65703eae" . "c" => base64_decode("Zm9wZW" . "4="));
use BadMethodCallException;
use Claromentis\Core\Filesystem\Exception\FileExistsException;
use Claromentis\Core\Filesystem\Exception\FileNotFoundException;
use Claromentis\Core\Filesystem\Exception\FilesystemException;
use League\Flysystem\FilesystemInterface as FlysystemInterface;
use League\Flysystem\PluginInterface;
use League\Flysystem\RootViolationException;




class Filesystem implements FilesystemInterface
{
    
    
    
    
    protected $flysystem;
    
    
    
    
    protected $fs_charset;
    
    
    
    
    
    
    
    public function __construct(FlysystemInterface $_7e8610c412db0fdb44a0dd5327c3669d, string $_2252415b6aaa32a148c100fb8df23132 = 'ISO-8859-1')
    {
        $this->flysystem = $_7e8610c412db0fdb44a0dd5327c3669d;
        $this->fs_charset = $_2252415b6aaa32a148c100fb8df23132;
    }
    
    
    
    
    public function Read(string $path) : string
    {
        try {
            return $this->flysystem->read($path);
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetStream(string $path)
    {
        try {
            $_1cc5aa2f679b575f82786a73f0da28f8 = $this->flysystem->readStream($path);
            return $_1cc5aa2f679b575f82786a73f0da28f8;
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function WriteFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_6108a04b8350bfd2b7f2b2365" . "703eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_a606a2dcd236a549db0574a9c1675" . "927"]);
        try {
            $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function WriteFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_5febae03aa5407c291" . "b5c61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new \InvalidArgumentException();
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->writeStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (\League\Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_01713acbc1c314b61bfbd8dc" . "10a810bd"]);
        }
    }
    
    
    
    
    public function Write(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->write($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (\League\Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_01713acbc1c314b61bfbd8dc10a8" . "10bd"]);
        }
    }
    
    
    
    
    public function UpdateFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_6108a04b835" . "0bfd2b7f2b23" . "65703eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_a606a2dcd236a549db05" . "74a9c1675927"]);
        try {
            $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function UpdateFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_5febae03aa5407c291b5" . "c61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new \InvalidArgumentException();
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->updateStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException();
        }
    }
    
    
    
    
    public function Update(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->update($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException();
        }
    }
    
    
    
    
    public function PutFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            } else {
                $this->WriteFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            }
        } catch (\Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function PutFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            } else {
                $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            }
        } catch (\Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    public function Put(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->put($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException();
        }
    }
    
    
    
    
    public function Copy(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->copy($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (\League\Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (\Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function Rename(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        if ($this->IsDir($path)) {
            $this->RenameDir($path, $_d074d7b344040d95fcad55b4694d9fec);
        } else {
            $this->RenameFile($path, $_d074d7b344040d95fcad55b4694d9fec);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    public function RenameFile(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->rename($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (\League\Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (\Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function RenameDir(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        $path = $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_c91b0ff19f81a88" . "73a4593a23719472" . "c"]($path, $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_8aa39710a" . "39f226efce" . "78e97c7bcd" . "786"]);
        $_d074d7b344040d95fcad55b4694d9fec = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_c91b0ff19f81a8873a4593a23" . "719472c"]($_d074d7b344040d95fcad55b4694d9fec, $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_8aa39710a39f226efce78" . "e97c7bcd786"]);
        $_414bd78c344503f4d9a81c17a1e0b473 = $this->ListDirs($path);
        $_00f2055c7cbd408ef56949f35c62b721 = $this->ListFiles($path);
        foreach ($_414bd78c344503f4d9a81c17a1e0b473 as $_c4f3321d131869e51a8844b6bcd8fb86) {
            $this->RenameDir($path . $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_87daa84e346f6420a3" . "f3426e05d16a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_87daa84e346f6" . "420a3f3426e05d" . "16a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86);
        }
        foreach ($_00f2055c7cbd408ef56949f35c62b721 as $_6ae3783b9ad544a6c31a979683fed870) {
            $this->RenameFile($path . $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_87daa84" . "e346f642" . "0a3f3426" . "e05d16a7" . "b"] . $_6ae3783b9ad544a6c31a979683fed870, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_87daa84e346f6420a3f3426e05d1" . "6a7b"] . $_6ae3783b9ad544a6c31a979683fed870);
        }
        
        
        $this->Delete($path);
    }
    
    
    
    
    public function Delete(string $path) : void
    {
        try {
            $_fd5a3a643834299cbdadfc3540ba0bcb = true;
            if ($this->IsDir($path)) {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->deleteDir($path);
            } else {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->delete($path);
            }
        } catch (\League\Flysystem\FileNotFoundException|RootViolationException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            
            
            
        }
        if ($_fd5a3a643834299cbdadfc3540ba0bcb === false) {
            throw new FilesystemException();
        }
    }
    
    
    
    
    
    
    
    
    protected function ListContentsOfType(string $type, string $path)
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            if ($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["typ" . "e"]] === $type) {
                $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_32b8fa1ca330a0685321" . "a379e5b9687d"]];
            }
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    
    
    
    
    public function ListContents(string $path) : array
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_32b8fa1ca" . "330a068532" . "1a379e5b96" . "87d"]];
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    public function ListContentsInfo(string $path) : array
    {
        $_6aead4bff5639b251aebcf8a630e43a7 = $this->flysystem->listContents($path, false);
        foreach ($_6aead4bff5639b251aebcf8a630e43a7 as &$_8043af106ba13a0ca9b53aa5c2df0e85) {
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_554a9169138240019acbd15026" . "42f16a"]]);
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["pa" . "th"]]);
        }
        return $_6aead4bff5639b251aebcf8a630e43a7;
    }
    
    
    
    
    public function ListContentsRecursive(string $path) : array
    {
        return $this->flysystem->listContents($path, true);
    }
    
    
    
    
    public function ListFiles(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_6ae3783b9ad544a6c31" . "a979683fed870"], $path);
    }
    
    
    
    
    public function ListDirs(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_c4f3321d131869e51a" . "8844b6bcd8fb86"], $path);
    }
    
    
    
    
    public function GetMetadata(string $path) : array
    {
        try {
            $_97ea09a7faf27c52c6eff69773df1d8a = $this->flysystem->getTimestamp($path);
            $size = $this->flysystem->getSize($path);
            $_9905761f4393d105cadfe7282a8c518d = $this->flysystem->getMimetype($path);
            $_e46a1b6a2fd927d616377ae17620d766 = $this->flysystem->getVisibility($path);
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        return [$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["si" . "ze"] => $size, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_9905761f4393d105cadfe72" . "82a8c518d"] => $_9905761f4393d105cadfe7282a8c518d, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_18c93a32ba5faf" . "9509389a94787e6" . "798"] => $_97ea09a7faf27c52c6eff69773df1d8a, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_e46a1b6a" . "2fd927d61" . "6377ae176" . "20d766"] => $_e46a1b6a2fd927d616377ae17620d766];
    }
    
    
    
    
    public function Exists(string $path) : bool
    {
        return $this->flysystem->has($path) && !$this->IsDir($path);
    }
    
    
    
    
    public function IsDir(string $path) : bool
    {
        try {
            $_b255ebafd5b8bb45110cd2db0604fa44 = $this->flysystem->getMetadata($path);
            return $_b255ebafd5b8bb45110cd2db0604fa44[$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["typ" . "e"]] === $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_c4f3321d131869e51a8844b6bc" . "d8fb86"];
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            return true;
        }
    }
    
    
    
    
    public function GetLocalPath(string $path) : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getLocalPath($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUrl(string $path) : ?string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUrl($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUsedSpace() : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUsedSpace();
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    public function addPlugin(PluginInterface $_38198dbb7190fed0f875632ecef1ac6f)
    {
        $this->flysystem->addPlugin($_38198dbb7190fed0f875632ecef1ac6f);
    }
    
    
    
    
    public function RegisterProtocol(string $_21f5dd11309da4af2e51660e6f110a91) : void
    {
        StreamWrapper::register($_21f5dd11309da4af2e51660e6f110a91, $this->flysystem);
    }
    
    
    
    
    public function SetVisibility(string $path, string $_e46a1b6a2fd927d616377ae17620d766) : void
    {
        try {
            $this->flysystem->setVisibility($path, $_e46a1b6a2fd927d616377ae17620d766);
        } catch (\League\Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    protected function CloseStream($_1cc5aa2f679b575f82786a73f0da28f8) : void
    {
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_5febae03aa5407c291b5c" . "61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8) && $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_f2646618" . "c9dcad156" . "a41241eac" . "c4c3f7"]($_1cc5aa2f679b575f82786a73f0da28f8) === $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_1cc5aa2f679b575f82" . "786a73f0da28f8"]) {
            $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_563b15b92a77c869e85edf" . "9569b4d025"]($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
}