<?php
namespace Claromentis\Core\Localization;

$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"] = (@$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"] ?: array()) + array("_7d9ddc77b5329ea478ce5d4" . "3e4615f53" => base64_decode("JyBkb" . "2Vzbi" . "d0IGV" . "4aXN0"), "_53d43bf1f48959b27c566" . "cc3f5b06681" => base64_decode("UGhy" . "YXNl" . "ICc="));
use Claromentis\Core\Localization\Exception\MissingPhraseException;








class MemoryProvider implements LocalizationProviderInterface
{
    
    
    
    
    protected $files_reader;
    
    
    
    
    protected $app_code;
    
    
    
    
    protected $lm = array();
    
    
    
    
    protected $lt_parsed = array();
    
    
    
    
    
    
    
    public function __construct($_d901b83ea3a884001dad5ede20f9b05e, Files $_00f2055c7cbd408ef56949f35c62b721)
    {
        $this->app_code = $_d901b83ea3a884001dad5ede20f9b05e;
        $this->files_reader = $_00f2055c7cbd408ef56949f35c62b721;
    }
    
    
    
    
    
    
    
    
    
    
    public function GetPhrase($key, $language)
    {
        $this->CheckLoadMessages($language);
        if (!isset($this->lm[$language][$key])) {
            throw new MissingPhraseException($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_53d43bf1f4895" . "9b27c566cc3f5b" . "06681"] . $key . $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_7d9ddc77b5329ea478ce5d43e461" . "5f53"]);
        }
        return $this->lm[$language][$key];
    }
    
    
    
    
    
    
    
    public function GetTemplaterPhrases($language)
    {
        $this->CheckLoadTemplaterMessages($language);
        return $this->lt_parsed[$language];
    }
    
    
    
    
    
    
    public function CheckLoadMessages($language)
    {
        if (isset($this->lm[$language])) {
            return;
        }
        $this->lm[$language] = [];
        $this->files_reader->ReadLM($this->lm[$language], $this->app_code, $language);
    }
    
    
    
    
    
    
    protected function CheckLoadTemplaterMessages($language)
    {
        if (isset($this->lt_parsed[$language])) {
            return;
        }
        $this->lt_parsed[$language] = array();
        $this->CheckLoadMessages($language);
        $this->files_reader->ReadLT($this->lm[$language], $this->lt_parsed[$language], $this->app_code, $language);
    }
    
    
    
    
    
    
    
    
    public function KeyExist($key, $language)
    {
        $this->CheckLoadMessages($language);
        return isset($this->lm[$language][$key]);
    }
    
    
    
    
    
    
    
    public function GetDataHash($language)
    {
        return $this->files_reader->GetDataHash($this->app_code, $language);
    }
}