define([], function () {

date_picker_get_date = function ($dp_element) {
	var dp = $dp_element.data("DateTimePicker");
	if (dp)
		return dp.date();
	else
		return null;
};

date_picker_set_date = function ($dp_element, date_obj) {
	var dp = $dp_element.data("DateTimePicker");
	if (dp)
		return dp.date(date_obj);
	else
		return null;
};

date_picker_init = function ($input_element) {
	$input_element.datetimepicker({'format': cla_locale.date_format, useCurrent: false}).on('dp.change', function (e) { jQuery(this).trigger('change'); });
};

parse_date_to_object = function (inDate, inTime)
{
	var day, month, year;
	var i;
	var regexp, year_2Kmode, year_index, month_index, day_index;

	var str = String(inDate);
	if (str == '')
	{
		return new Date();
	}

	regexp = /\\(.)/g;
	//new RegExp(v);

	var format = cla_locale.php_date_format.replace(regexp, function (str,ch) {return ("@" + String.fromCharCode(ch.charCodeAt(0)+128));} );

	var re = new RegExp("jS|j|d|n|m|y|Y|F|f|M", "g");
	var date_pattern = format;
	var date_keywords = date_pattern.match(re);
	var patternArr = ["d",          "n",        "jS",                        "j",          "m",        "y",        "Y",        "F",      "f",      "M"];//
	var replaceArr = ["(\\d{1,2})", "(\\d{1,2})", "(\\d{1,2})(?:st|nd|rd|th)", "(\\d{1,2})", "(\\d{2})", "(\\d{2})", "(\\d{4})", "(\\w+)", "(\\w+)", "(\\w{3})"];
	for (i = 0; i < patternArr.length; i++)
	{
		date_pattern = date_pattern.replace(new RegExp(patternArr[i]), replaceArr[i]);
	}
	regexp = /@(.)/g;

	date_pattern = date_pattern.replace(regexp, function (str,ch) {return ("" + String.fromCharCode(ch.charCodeAt(0)-128));} );

	var date_values = [];
	date_values = str.match(new RegExp(date_pattern));

	if (date_values)
	{
		year_2Kmode = 0;

		//year search
		for (i = 0; i < date_keywords.length; i++)
		{
			if (date_keywords[i] == "Y")
			{
				year_index = i;
				break;
			}
			if (date_keywords[i] == "y")
			{
				year_index = i;
				year_2Kmode = 1;
				break;
			}
		}
		year = parseInt(date_values[year_index+1], 10);

		if (year_2Kmode)
		{if (year < 70)
		{year += 2000;
		} else if (year < 100)
		{year += 1900;
		}
		}


		month_index = -1;
		//month search
		for (i = 0; i < date_keywords.length; i++)
		{
			if ((date_keywords[i] == "n") || (date_keywords[i] == "m"))
			{
				month_index = i;
				break;
			}
		}
		month = date_values[month_index+1];

		if (month_index == -1)
		{
			for (i = 0; i < date_keywords.length; i++)
			{
				if ((date_keywords[i] == "F") || (date_keywords[i] == "M") || (date_keywords[i] == "f"))
				{
					month_index = i;
					break;
				}
			}
			var dateObj = new Date(date_values[month_index+1] + " 9, 1995");
			month = dateObj.getMonth() + 1;
		}

		//day search
		for (i = 0; i < date_keywords.length; i++)
		{
			if ((date_keywords[i] == "j") || (date_keywords[i] == "jS") || (date_keywords[i] == "d"))
			{
				day_index = i;
				break;
			}
		}
		day = date_values[day_index+1];
	}

	var result;
	if(typeof day == 'undefined'){
		result = new Date();
	}else{
		result = new Date(year, month-1, day);
	}

	if (typeof inTime == 'undefined'){
		return result;
	}


	var time_arr = parse_time_to_array(inTime);

	result.setHours(time_arr[0]);
	result.setMinutes(time_arr[1]);

	return result;
};

// returns time as array of two elements [0] is hours in 24h format, [1] is minutes
// if time is not valid, returns value depending on value of second paramater - "default_option"
//   -1 - returns null instead of array
//    0 or not defined - returns zeros (default)
//    1 - return current time
parse_time_to_array = function (time_str, default_option)
{
	time_str = time_str + ''; // make sure it's string
	var matches = time_str.match(/^(\d{1,2}?)[^\d]?(\d\d)\s*(am|pm|AM|PM)?/);

	var hour, min, am_pm, need_default;
	need_default = 0;

	if (matches == null)
	{
		need_default = 1;
	} else
	{
		hour = parseInt(matches[1], 10);
		min = parseInt(matches[2], 10);
		am_pm = (matches[3]+'').toLowerCase();
		if (am_pm == 'pm' && hour < 12)
			hour += 12;
		else if (am_pm == 'am' && hour == 12)
			hour = 0;

		if (hour > 24 || min >= 60 || hour < 0 || min < 0)
			need_default = 1;
	}

	if (need_default)
	{
		if (default_option == -1)
			return null;
		if (default_option == 0 || default_option == null)
			hour = min = 0;
		if (default_option == 1)
		{
			var now = new Date();
			hour = now.getHours();
			min = now.getMinutes();
		}

	}

	return [hour, min];
};

return null;
});
