function loadImage(image_id)
{
	if (!(image_id > 0))
		return;

	// jQuery('#main_image').attr('src', '../gallery/thumbnail.php?id='+image_id+'&prefix=medium');

	//show the spinner
	var spinner = jQuery('#spinner');
	spinner.css('display', 'block');
	spinner.css("top", (jQuery(window).height() - spinner.height())/2 + jQuery(window).scrollTop() + "px");
	spinner.css("left", (jQuery(window).width() - spinner.width())/2 + jQuery(window).scrollLeft() + "px");

	$.ajax({
		url: 'details.php?mode=bare&id='+image_id,
		beforeSend: function() {
			jQuery('#spinner').css('display', 'none');
		}
	}).done(function(data) {
		var title = $(data).find('#imageName').text();
		$('#imageNameBread').text(title);
		$('#image_details_block').html(data);
	});

	// jQuery('#image_details_block').load('details.php?mode=bare&id='+image_id, null, function () {
	// 	jQuery('#spinner').css('display', 'none');
	// });
	return false;
}

jQuery.ajaxSetup({cache: true});

jQuery(function(){

if (Modernizr.history)
{
	jQuery('#image_details_block').on('click', 'a[class=gallery_prev_next_link]', function (event){
		var image_id = jQuery(event.currentTarget).data('id');

		if (image_id)
		{
			event.preventDefault();
			window.history.pushState(image_id, null, event.currentTarget.href);
			loadImage(image_id);
		}
	});

	window.addEventListener("popstate", function(event) {
		loadImage(event.state.id);
	}, false);

	if (window.location.hash.substr(1) > 0)
	{
		var image_id = window.location.hash.substr(1);
		window.history.replaceState(image_id, null, 'details.php?id=' + image_id);
		loadImage(image_id);
	}
} else
{
	var MainRouter = Backbone.Router.extend({
		routes: {
			":image_id": "details"
		},

		details: function (image_id) {
			if (! (image_id > 0))
				return;
			loadImage(image_id);
		}

	});

	jQuery('#image_details_block').on('click', 'a[class=gallery_prev_next_link]', function (event){
		var image_id = jQuery(event.currentTarget).data('id');

		if (image_id)
		{
			event.preventDefault();
			window.location.href = 'details.php#' + image_id;
		}
	});

	var main_router = new MainRouter();
	Backbone.history.start();
}
// end of DOMready
});