<?php
$_db_migration_to = '39.23'; // 8.13.22
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('02_reindex_infocapture_issues.php', <<<'DB_UPDATE_FILE'
<?php

use Claromentis\Core\Services;
use Claromentis\Search;
use Claromentis\Setup\SetupFacade;

/**
 * BT-3867 Prevent archived InfoCapture issues from being indexed for Global Search
 *
 * This reindex migration simply queues all InfoCapture issues for reindexing to ensure that archived issues are
 * excluded from the index.
 *
 * @var SetupFacade $migrations
 */
$logger = $migrations->getLogger();
$logger->notice('Queueing InfoCapture issues for reindexing');

try {
	/**
	 * @var Search\Indexing\Reindexer $reindexer
	 */
	$reindexer = Services::I()->{'search.reindexer'};
	$reindexer->Reindex(Search\ItemType\Indexing\ICIssue::TYPE_NAME);

	$logger->notice('Reindexing queued successfully');
} catch (Throwable $exception) {
	$logger->error("Error queueing reindexing for InfoCapture issues: {$exception->getMessage()}");
	$logger->error($exception);
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('39.23');
