define(['jquery'], function (jQuery) {
    function FolderPicker(element_id, extra_query) {
        this.element_id = element_id;
        this.extra_query = extra_query;

        this.init();
        //this.$el.data('folder-picker', this);
    }

    FolderPicker.prototype.init = function () {
        this.$el = jq_$(this.element_id);
        this.$container = this.$el.closest('.js-folder-picker-wrapper');

        var self = this;

        this.$container.find('.js-select-button').on('click', function () {
            self.call_popup();
        });

        this.$container.find('.js-unset-button').on('click', function () {
            self.unset();
        });

        this.$el.on('blur', function () {
            self.set_active();
        });
    };

    // Opens folder select popup window
    // called from parent window
    FolderPicker.prototype.call_popup = function()
    {
        var cur_folder_id = this.get_value();

        window.open('/intranet/documents/pick_folder_popup.php?category='+cur_folder_id+'&selector_id='+this.selector_id + '&' + this.extra_query,
            'folder_picker_tree',
            'dependent=yes,width=350,height=430,titlebar=yes,scrollbars=yes,status=yes,resizable=yes');
        window.folder_picker_obj = this;
        return false;
    };

    // Sets folder picker component enabled or disabled
    FolderPicker.prototype.set_enabled = function(enabled)
    {
        this.$el.prop('disabled', !enabled);
        this.$container.find('.js-select-button, .js-unset-button').prop('disabled', !enabled);
    };


    // Returns currently selected folder id
    // Can be called only from the parent window (the one that contains the component)
    FolderPicker.prototype.get_value = function()
    {
        var folder_id = this.$el.val();
        if (!folder_id)
            folder_id = 0;
        return folder_id;
    };

    // sets multiselect option as selected in folder picker target element so it's
    // sent to server when form is submitted
    // Can be called only from parent window (the one that contains the component)
    FolderPicker.prototype.set_active = function()
    {
        this.$el.find('option').prop('selected', true);
    };

    // removes selected folder from this element
    // Can be called only from parent window (the one that contains the component)
    FolderPicker.prototype.unset = function()
    {
        this.$el.find('option').detach();
        this.$el.trigger('change');
    };


    // Process "OK" button in folder selector. Gets currently highlighted option from tree
    // and calls folder_picker_set_value() to return that value to calling window
    //  "tree" parameter is an instance of dhtmlXTreeObject
    // Called from popup window
    FolderPicker.prototype.do_select = function(tree)
    {
        //alert(tree.getSelectedItemId() + ' ' + tree.getSelectedItemText());
        var object_id = tree.getSelectedItemId();
        var object_name = tree.getSelectedItemText();

        this.set_value(object_id, object_name);
    };

    // Returns value into calling window
    // Called from popup window
    FolderPicker.prototype.set_value = function(folder_id, folder_name)
    {
        this.$el.html('<option value="' + folder_id + '" selected="selected">'+folder_name+'</option>');
        // note, folder_name comes with all html entities escaped, so it's safe to use it this way

        this.$el.trigger('change');
    };

    return FolderPicker;
});