<?php
namespace Claromentis\Console\Util;

$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"] = (@$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"] ?: array()) + array("_5bcefc1e" . "ff68a2aa6" . "ab8f35699" . "a56d08" => base64_decode("RGF0YWJhc2UgaXMg" . "bm90IGF2YWlsYWJs" . "ZTog"), "_7b2ca9a105acfcc088d2c" . "15bfe6458b6" => base64_decode("Q29yZSBpcyBub3Qg" . "aW5zdGFsbGVk"), "_1094b976516d8df54067d448e66e029" . "7" => base64_decode("RGF0YWJhc2Ug" . "aXMgYXZhaWxh" . "Ymxl"), "_3e09962b663b985bf8c260ac2e9" . "5edc0" => base64_decode("Y29yZQ" . "=="), "_a70083b91f8d3b023" . "7061e06826958e8" => base64_decode("Q2hlY2tpbmcgZG" . "F0YWJhc2UgYXZh" . "aWxhYmlsaXR5Li" . "4u"), "_77713ce" . "23683636" . "d0573408" . "c9a0d0dd" . "b" => base64_decode("RGF0YWJhc2UgcGVybWlzc2lvbnM" . "gYXJlIGFkZXF1YXRl"), "_4c93d4c40f7ab1a4" . "88c387f7f91a6496" => base64_decode("Q2hlY2tpbmcgaW5zdGF" . "sbGF0aW9uLi4u"), "_9636e445fb" . "eaa4bbfe569" . "4ed532de0b1" => base64_decode("RGF0YWJhc2UgcGVybWlzc2lvbnMgaW5zdWZmaWNpZW5" . "0"), "_9810a2810274128200cb24" . "f15909a3f2" => base64_decode("Q2hlY2tpbmcgZGF" . "0YWJhc2UgcGVybW" . "lzc2lvbnMuLi4="));
use Claromentis\Core\Config\Config;
use Claromentis\Core\DAL\DbFactory;
use Claromentis\Core\Module;
use Claromentis\Setup\Exception\NotInstalledException;
use Claromentis\Setup\Task\DatabaseCheck;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use RuntimeException;




class InstallationChecker implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    protected Config $config;
    protected DbFactory $factory;
    protected Locator $locator;
    protected Module\Api $modules;
    
    
    
    
    
    
    
    
    
    public function __construct(Config $_fd33b1a14db9a1eccfaaa3cb67b5336e, DbFactory $_c8ef295ed962a46e6246480731bf7b99, Locator $_958a49c0e9814c5c29eb8698e3fb6de2, Module\Api $_59eea0afb98cc6c83c49d730362a45fd)
    {
        $this->config = $_fd33b1a14db9a1eccfaaa3cb67b5336e;
        $this->factory = $_c8ef295ed962a46e6246480731bf7b99;
        $this->locator = $_958a49c0e9814c5c29eb8698e3fb6de2;
        $this->modules = $_59eea0afb98cc6c83c49d730362a45fd;
        $this->setLogger(new NullLogger());
    }
    
    
    
    
    
    
    public function isInstalled()
    {
        try {
            $this->logger->info($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_4c93d4c4" . "0f7ab1a48" . "8c387f7f9" . "1a6496"]);
            $this->verifyInstalled();
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    public function checkDatabaseConnection()
    {
        try {
            $this->logger->info($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_a70083b91f8d3b0237061e" . "06826958e8"]);
            $this->verifyDatabaseConnection();
            $this->logger->debug($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_1094b976516d8d" . "f54067d448e66e0" . "297"]);
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            
            
            
            $this->logger->info($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_5bcefc1eff" . "68a2aa6ab8f" . "35699a56d08"] . $_c35473364fa7a050299058f332ec29c1->getMessage());
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    public function checkDatabasePermissions()
    {
        try {
            $this->logger->info($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_9810a28102741" . "28200cb24f1590" . "9a3f2"]);
            $this->verifyDatabasePermissions();
            $this->logger->debug($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_77713ce23683636d05" . "73408c9a0d0ddb"]);
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            
            
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    
    public function verifyInstalled()
    {
        $this->verifyDatabaseConnection();
        $this->verifyDatabasePermissions();
        if (!$this->modules->isInstalled($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_3e09962b663b985bf8c26" . "0ac2e95edc0"])) {
            throw new NotInstalledException($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_7b2ca9a105acfcc" . "088d2c15bfe6458b" . "6"]);
        }
    }
    
    
    
    
    
    
    
    public function verifyDatabaseConnection()
    {
        
        
        $_4504853ce5094b088c8bdc3d570a0a5d = $this->getDatabase();
        
        
        $this->modules->setDatabase($_4504853ce5094b088c8bdc3d570a0a5d);
    }
    
    
    
    
    
    
    
    public function verifyDatabasePermissions()
    {
        $_4504853ce5094b088c8bdc3d570a0a5d = $this->getDatabase();
        $_58bc0ced402c33be307fe4d3d5433ed1 = new DatabaseCheck($this->config, $_4504853ce5094b088c8bdc3d570a0a5d);
        $_58bc0ced402c33be307fe4d3d5433ed1->setLogger($this->logger);
        if (!$_58bc0ced402c33be307fe4d3d5433ed1->Check()) {
            foreach ($_58bc0ced402c33be307fe4d3d5433ed1->GetErrors() as $_ba3845cb79c005cf3269af8c83ddbe5e) {
                $this->logger->error($_ba3845cb79c005cf3269af8c83ddbe5e);
            }
            throw new RuntimeException($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_9636e445f" . "beaa4bbfe5" . "694ed532de" . "0b1"]);
        }
    }
    
    
    
    
    
    
    
    protected function getDatabase()
    {
        return $this->factory->GetInstanceFromConfig($this->config);
    }
}