/**
 * Base class
 */
var DetailsViewBase = Backbone.View.extend({
	setVisible : function(visible) {
		if(visible)
			this.render();
		else
			this.hide();
	},
	hide : function() {
		this.$el.hide();
	},
	render : function() {
		$('#verify_doc').hide();
		this.$el.show();
	}
});
/**
 * View for Document Details > Preview
 */
var DetailsPreviewView = DetailsViewBase.extend({
	el : '#preview_frame',
	// statusMessage : lmsg('documents.docs_details_views.preview'),

	render : function() {
		$('#verify_doc').show();
		this.$el.show();
	}
});

/**
 * View for Document Details > Preview > Component
 */
var DetailsComponentView = DetailsViewBase.extend({
	el : '#component_frames',
	statusMessage : lmsg('documents.docs_details_views.preview'),

	render : function() {
		$('#verify_doc').show();
		this.$el.show();
	}
});

/**
 * View for Document Details > Permission
 */
var DetailsPermissionsView = DetailsViewBase.extend({
	el : '#edit_permissions',
	statusMessage : lmsg('documents.docs_details_views.permission')
});

/**
 * View for Document Details > Edit document details
 */
var DetailsEditView = DetailsViewBase.extend({
	el : '#edit_details',
	statusMessage : lmsg('documents.docs_details_views:document_details')
});

/**
 * View for Document Details > Audit
 */
var DetailsAuditView = DetailsViewBase.extend({
	el : '#audit_log',
	statusMessage : lmsg('documents.docs_details_views.audit')
});


/**
 * View for Document Details > Review History
 */
var DetailsReviewHistoryView = DetailsViewBase.extend({
	el : '#review_history',
	statusMessage : lmsg("documents.details.reviews_history")
});

/**
 * View for Document Details > Version History
 */
var DetailsVersionView = DetailsViewBase.extend({
	el : '#version_log',
	statusMessage : lmsg('documents.docs_details_views.version_history')
});

/**
 * View for Document Details > Edit schedule
 */
var DetailsEditSchedule = DetailsViewBase.extend({
	el : '#schedules',
	statusMessage : "View/Edit schedule"
});

/**
 * View for Document Details > Set Reminder
 */
var DetailsSetReminderView = DetailsViewBase.extend({
	el : '#setReminder',
	statusMessage : "Set Reminder"
});

/**
 * View for Document Details > Workflow
 */
var DetailsWorkflowView = DetailsViewBase.extend({
	el : '#workflow',
	statusMessage : lmsg('documents.docs_details_views.document_workflow')
});