define(['cla_angular'], function(angular)
{
	var app = angular.module("clientsListApp", ['ui.bootstrap', 'ngResource', 'server-data-module']);

	app.controller("clientsListCtrl", clientsListCtrl);
	app.controller('editModalCtrl', editModalCtrl);
	app.controller('createModalCtrl', createModalCtrl);

	clientsListCtrl.$inject = ['$modal', '$resource', 'clientsList'];
	function clientsListCtrl($modal, $resource, clientsList) {
		var ClientsResource = $resource('/oauth2/admin/client/:id', {'id': '@id'}, {
			'save': { method: 'PUT'},
			'delete': { method: 'DELETE' },
			'reset_secret': { method: 'POST', params: {'reset_secret': 1} },
			'save_new': { method: 'POST' }
		});

		var _this = this;

		this.clients = [];
		for (var i=0; i<clientsList.length; i++) {
			this.clients.push(new ClientsResource(clientsList[i]));
		}

		this.showEditDialog = function (client) {
			var modalInstance = $modal.open({
				templateUrl: 'editDialog.html',
				controller: 'editModalCtrl as dialog',
				resolve: {
					item: function () {
						return client;
					}
				}
			});

			modalInstance.result.then(function (uris) {
				client.redirect_uris = uris;
				client.$save().then(function () {
					cla.showMessage(lmsg('oauth2.admin.client.saved'), lmsg('oauth2.admin.client.settings_updated'));
				}, _this.onError);
			});
		};

		this.resetSecret = function (client) {
			if (confirm(lmsg('oauth2.admin.reset_secret.confirmation'))) {
				client.$reset_secret().then(function () {
					cla.showMessage(lmsg('oauth2.admin.client.saved'), lmsg('oauth2.admin.client.secret_reset'));
				}, _this.onError);
			}
		};

		this.deleteClient = function (client) {
			if (confirm(lmsg('common.areyousure'))) {
				var index = _this.clients.indexOf(client);
				client.$delete().then(function () {
					cla.showMessage(lmsg('oauth2.admin.client.deleted'), lmsg('oauth2.admin.client.deleted'));
					_this.clients.splice(index, 1);
				}, _this.onError);
			}
		};

		this.createClient = function () {
			var modalInstance = $modal.open({
				templateUrl: 'createDialog.html',
				controller: 'createModalCtrl as dialog'
			});

			modalInstance.result.then(function (client_info) {
				var client = new ClientsResource(client_info);
				client.$save_new().then(function () {
					_this.clients.push(client);
					cla.showMessage(lmsg('oauth2.admin.client.saved'), lmsg('oauth2.admin.client.created'));
				});
			}, _this.onError);
		};

		this.onError = function (result) {
			if (typeof result !== 'undefined')
				cla.showMessage(lmsg('oauth2.admin.client.server_error') + ' - ' + result.status, result.data, true);
			else
				cla.showMessage(lmsg('oauth2.admin.client.server_error'));
		};
	}

	editModalCtrl.$inject = ['$modalInstance', 'item'];
	function editModalCtrl($modalInstance, item) {
		this.uris_str = item.redirect_uris.join("\n");

		var _this = this;

		this.ok = function () {
			var uris_arr = _this.uris_str.length > 0 ? _this.uris_str.split("\n") : [];
			$modalInstance.close(uris_arr);
		};

		this.cancel = function () {
			$modalInstance.dismiss();
		};
	}

	createModalCtrl.$inject = ['$modalInstance'];
	function createModalCtrl($modalInstance) {
		this.client = {
			name: '',
			uris_str: ''
		};

		var _this = this;

		this.ok = function () {
			var uris_arr = _this.client.uris_str.length > 0 ? _this.client.uris_str.split("\n") : [];
			var response = {
				name: _this.client.name,
				redirect_uris: uris_arr
			};
			$modalInstance.close(response);
		};

		this.cancel = function () {
			$modalInstance.dismiss();
		};
	}

	return null;
});