InfoCapture Dashboard
=====================

Installation
------------
1. Download ZIP file from GIT from appropriate branch (Recommended: Master)
2. Extract the ZIP file and upload content of this component into "/intranet/icdashboard/" in Claromentis
3. SSH to the web server navigate to the root web folder then Run PHING -

```shell
phing -Dapp=icdashboard install
```
for a new icdashboard install, or 
```shell
phing -Dapp=icdashboard upgrade
```
for an existing one









OpenItems homepage component
----------------------------

**Note**.
OpenItems will only show issues that are in a status group with an 'in progress' type. This gives more flexibility for having multiple 'in progress' statuses and is not subject to stop working if the status name is changed.

**Note 2**.
Unless project id(s) is given, OpenItems only shows results from projects with 'Active' status, not 'Testing' or 'Blocked'. If project id is specified, it can be a project in "Testing" state and issues from it will be shown.

To embed within a publish page, use:
```javascript
	<script type="text/javascript">
	<!--
		var smart_openitems_component = {}
		smart_openitems_component.name="openitems"
		smart_openitems_component.width="100%"
		smart_openitems_component.height=600
		smart_openitems_component.projects='1,2,3,4'
		smart_openitems_component.columns='id,project_title,primary_field,created,modified'
		smart_openitems_component.maxitems=10
		smart_openitems_component.issue_type="my_issues"
		smart_openitems_component.use_iframe="true"
		//-->
	</script>
	<script type="text/javascript" src="/intranet/icdashboard/assets/js/smart_openitems_component.js">
	</script>
```

For home page component:
```html
	<component class="\Claromentis\ICDashboard\UI\ICOpenItems" projects="1,2,3,4" columns="id,project_title,primary_field,created,modified" maxitems="10" issue_type="my_issues">
```
Attributes
* projects - Infocapture project IDs, comma separated
* columns - Which columns to show on the table. The allowed columns are - "id", "project_title", "primary_field", "created", "modified" and "status".
* maxitems - How many rows to display
* issue_type - Which type of issues to show: 'my_issues', 'assigned_to_me', 'reported_by_me', 'all'. Defaults to 'my_issues'.
* template - Use a custom template. Defaults to "icdashboard/UI/ICOpenItems.html".
* cache_ttl - How long to cache this component for in seconds. Defaults to 900 (15 minutes).
* name - (smart object only) - A name for the component that must be unique on this page. Must be used where mutiple smart objects of the same type are used. Defaults to 'openitems_smart_component'.
* use_iframe - (smart object only) - Should this component load in an iframe or not. Defaults to 'true'.
* width - (smart object and iframe only) Width of the iframe.
* height - (smart object and iframe only) Height of the iframe.

OpenItems full smart object (adds filters + multiple pages)
-----------------------------------------------------------
To embed within a publish page, use:
```javascript
	<script type="text/javascript">
	<!--
		var smart_openitems = {}
		smart_openitems.name="openitems"
		smart_openitems.width="100%"
		smart_openitems.height=600
		smart_openitems.projects='1,2,3,4'
		smart_openitems.columns='id,project_title,primary_field,created,modified'
		smart_openitems.maxitems=10
		smart_openitems.hide_filters="false"
		smart_openitems.issue_type="my_issues"
		//-->
	</script>
	<script type="text/javascript" src="/intranet/icdashboard/assets/js/smart_openitems.js">
	</script>
```
Attributes
* projects - Infocapture project IDs to show by default
* columns - Which columns to show on the table. The allowed columns are - "id", "project_title", "primary_field", "created", "modified" and "status".
* maxitems - How many rows to display
* issue_type - Which type of issues to show by default: 'my_issues', 'assigned_to_me', 'reported_by_me', 'all'. Defaults to 'my_issues'.
* hide_filters - Do not show the projects/issue type filters.
* template - Use a custom template. Defaults to "icdashboard/smart_openitems.html".
* width - (smart object and iframe only) Width of the iframe.
* height - (smart object and iframe only) Height of the iframe.

Dashboard homepage component
----------------------------
To embed within a publish page, use:
```javascript
	<script type="text/javascript">
		<!--
		var smart_dashboard_component = {}
		smart_dashboard_component.width="100%"
		smart_dashboard_component.height=1000
		smart_dashboard_component.project='4'
		smart_dashboard_component.chart='pie'
		smart_dashboard_component.show='title,description,chart,stage'
		smart_dashboard_component.statusdisplay='closed,in progress,new'
		smart_dashboard_component.statusgroupdisplay='1,2'
		smart_dashboard_component.statusgroupcolours='#8080cc,#ffe680'
		smart_dashboard_component.use_iframe='true'
		//-->
	</script>
	<script type="text/javascript"
		src="/intranet/icdashboard/assets/js/smart_dashboard_component.js">
	</script>
```

For home page component:
```html
	<component class="\Claromentis\ICDashboard\UI\ICDashboard" project="1" chart="bar" show="title,description,chart,stage" statusdisplay="closed,in progress,new" statusgroupdisplay="1,2" statusgroupcolours="#8080cc,#ffe680">
```

Attributes
* project - ID of project in InfoCapture
* chart - 'bar' or 'pie'
* show - Any combination of 'title', 'description', 'chart' or 'stage'
* statusdisplay - List of statuses to show 
* statusgroupdisplay - List of status group ids to show
* statusgroupcolours - Colours to use for status groups
* template - Use a custom template. Defaults to "icdashboard/UI/ICDashboard.html".
* cache_ttl - How long to cache this component for in seconds. Defaults to 900 (15 minutes).
* use_iframe - (smart object only) - Should this component load in an iframe or not. Defaults to 'true'.
* width - (smart object and iframe only) Width of the iframe.
* height - (smart object and iframe only) Height of the iframe.

SLA breach homepage component
----------------------------
To embed within a publish page, use:
```javascript
	<script type="text/javascript">
		<!--
		var smart_sla_breach_component = {}
		smart_sla_breach_component.name="test_dashboard"
		smart_sla_breach_component.width="100%"
		smart_sla_breach_component.height=282
		smart_sla_breach_component.project=2
		smart_sla_breach_component.sla='overdue'
		smart_sla_breach_component.style='wide'
		smart_sla_breach_component.text='issues breach SLA'
		smart_sla_breach_component.icon='ok-circle'
		smart_sla_breach_component.use_iframe='true'
		//-->
	</script>
	<script type="text/javascript"
		src="/intranet/icdashboard/assets/js/smart_sla_breach_component.js">
	</script>
```

For home page component:
```html
	<component class="\Claromentis\ICDashboard\UI\ICSLA" project="1" sla="overdue" style="wide" text="issues breach SLA" icon="ok-circle">
```
Attributes
* project -InfoCapture project ID
* sla - Name of IC project SLA to display stats for
* style - Either 'wide', 'mini' or 'square'
* text - Text to show below SLA count (shown as popup text for style='mini' when not on a phone)
* icon - Glyphicon name to use. Defaults to 'circle-exclamation-mark'
* template - Use a custom template. Defaults to "icdashboard/UI/ICSLA.html".
* cache_ttl - How long to cache this component for in seconds. Defaults to 900 (15 minutes).
* name - (smart object only) - A name for the component that must be unique on this page. Must be used where mutiple smart objects of the same type are used. Defaults to 'sla_breach_smart_component'.
* use_iframe - (smart object only) - Should this component load in an iframe or not. Defaults to 'true'.
* width - (smart object and iframe only) Width of the iframe.
* height - (smart object and iframe only) Height of the iframe.

Submissions homepage component
----------------------------
To embed within a publish page, use:
```javascript
	<script type="text/javascript">
		<!--
		var smart_submissions_component = {}
		smart_submissions_component.name="test_submissions"
		smart_submissions_component.width="100%"
		smart_submissions_component.height=1000
		smart_submissions_component.projects='1,2,3,4,5,6,7,8'
		smart_submissions_component.type='monthly'
		smart_submissions_component.year='2014'
		smart_submissions_component.month='1'
		smart_submissions_component.title='Example title'
		smart_submissions_component.use_iframe='true'
		//-->
	</script>
	<script type="text/javascript"
		src="/intranet/icdashboard/assets/js/smart_submissions_component.js">
	</script>
```

For home page component:
```html
	<component class="\Claromentis\ICDashboard\UI\ICSubmission" projects="1,2,3,4" type="monthly" year="current" month="1" title="Example title">
```

Attributes
* projects - Infocapture project IDs
* title - Text to show above chart and before date. This will have the year, month&year or week number displayed after it.
* type - 'yearly', 'monthly' or 'weekly'
* year - Which year to show, 'current' for now or negative number for relative years (-1 is last year). Applies to 'yearly' and 'monthly' types only. Defaults to 'current'
* month - Which month to show as a number, 'current' for now or negative number for relative years (-1 is last month). Applies to 'monthly' type only. Defaults to 'current'
* week - Which week to show. Either 'current' for this week, or a negative number for relative weeks (-1 is last week). Applies to 'weekly' type only. Default to 'current'
* template - Use a custom template. Defaults to "icdashboard/UI/ICSubmissions.html".
* cache_ttl - How long to cache this component for in seconds. Defaults to 900 (15 minutes).
* name - (smart object only) - A name for the component that must be unique on this page. Must be used where mutiple smart objects of the same type are used. Defaults to 'submissions_smart_component'.
* use_iframe - (smart object only) - Should this component load in an iframe or not. Defaults to 'true'.
* width - (smart object and iframe only) Width of the iframe.
* height - (smart object and iframe only) Height of the iframe.

Handlers homepage component
----------------------------
To embed within a publish page, use:
```javascript
	<script type="text/javascript">
		<!--
		var smart_handlers_component = {}
		smart_handlers_component.name="test_handlers"
		smart_handlers_component.width="100%"
		smart_handlers_component.height=1000
		smart_handlers_component.project=1
		smart_handlers_component.chart='pie'
		smart_handlers_component.showtophandlers=3
		smart_handlers_component.showunassigned='true'
		smart_handlers_component.show='title,description,chart,handlers'
		smart_handlers_component.statusdisplay='new,in progress'
		smart_handlers_component.statusgroupdisplay='1,2'
		smart_handlers_component.colours='#8080cc,#ffe680'
		smart_handlers_component.use_iframe='true'
		//-->
	</script><script type="text/javascript"
		src="/intranet/icdashboard/assets/js/smart_handlers_component.js">
	</script>
```

For home page component:
```html
	<component class="\Claromentis\ICDashboard\UI\ICHandler" project="1" chart="pie" showtophandlers="3" showunassigned="true" show="title,description,chart,handlers" statusgroupdisplay="1,2">
```
Attributes
* project - Infocapture project ID
* chart - Type of chart. Choose between 'bar' and 'pie'
* showtophandlers - How many individual users to show before merging results into 'others' or 'unassigned'.
* showunassigned - Should the 'unassigned' row be shown?
* show - Any combination of 'title', 'description', 'chart' or 'handlers'
* statusdisplay - List of statuses to show 
* statusgroupdisplay - List of status group ids to show
* colours - Colours to use for each section of the chart and/or row
* template - Use a custom template. Defaults to "icdashboard/UI/ICHandler.html".
* cache_ttl - How long to cache this component for in seconds. Defaults to 900 (15 minutes).
* name - (smart object only) - A name for the component that must be unique on this page. Must be used where mutiple smart objects of the same type are used. Defaults to 'handlers_smart_component'.
* use_iframe - (smart object only) - Should this component load in an iframe or not. Defaults to 'true'.
* width - (smart object and iframe only) Width of the iframe.
* height - (smart object and iframe only) Height of the iframe.

Project list homepage component
----------------------------
To embed within a publish page, use:
```javascript
	<script type="text/javascript">
		<!--
		var smart_project_list_component = {}
		smart_project_list_component.name="test_project_list"
		smart_project_list_component.width="100%"
		smart_project_list_component.height=350
		smart_project_list_component.projects='1,2,3,4,5,6,7,8'
		smart_project_list_component.tagged="tag1,tag2"
		smart_project_list_component.showheader=true
		smart_project_list_component.style='grid'
		smart_project_list_component.max_projects=3
		smart_project_list_component.use_iframe='true'
		//-->
	</script><script type="text/javascript"
		src="/intranet/icdashboard/assets/js/smart_project_list_component.js">
	</script>
```

For home page component:
```html
	<component class="\Claromentis\ICDashboard\UI\ICProjectList" projects="1,2,3,4,5,6,7,8" tagged="tag1,tag2" showheader="true" style="grid" max_projects="3" />
```
Attributes
* projects - Infocapture project IDs. Project IDs will override any 'tagged' attribute
* tagged - Alternative to project IDs. Will match any projects that match a tag from the supplied list
* showheader - Show the search bar and icon/list view buttons
* style - 'grid' or 'list'. If the header is hidden this is to set the style to whichever you want. If the header is visible this style will always be shown on a page reload regardless of which view buttons are pressed. If no style is set the page will remember what was used last time on this computer.
* max_projects - How many projects to display in the component. If there are more, a 'show all' link will appear that will link to a page with all projects that the attributes will allow.
* template - Use a custom template. Defaults to "icdashboard/UI/ICProjectList.html".
* cache_ttl - How long to cache this component for in seconds. Defaults to 900 (15 minutes).
* name - (smart object only) - A name for the component that must be unique on this page. Must be used where mutiple smart objects of the same type are used. Defaults to 'project_list_smart_component'.
* use_iframe - (smart object only) - Should this component load in an iframe or not. Defaults to 'true'.
* width - (smart object and iframe only) Width of the iframe.
* height - (smart object and iframe only) Height of the iframe.

## Change log
