define(['jquery', 'cla_highcharts'], function($, Highcharts)
{
	var ICDashboardSubmissions = function(target, categories, chartType, series)
	{
		this.target = target;
		this.categories = categories;
		this.chartType = chartType;
		this.series = series;
	};

	ICDashboardSubmissions.prototype.Show = function(animate)
	{
		var chart = new Highcharts.Chart({
			chart: {
				renderTo: this.target,
				type: this.chartType
			},
			title: {
				text: ""
			},
			plotOptions: {
				column: {
					pointPadding: 0.0,
					borderWidth: 0
				},
				series: {
					shadow: false,
					animation: animate
				}
			},
			yAxis: {
				minTickInterval: 1,
				min: 0,
				title: {
					text: null
				}
			},
			xAxis: {
				categories: this.categories
			},
			series: this.series,
			tooltip: {
				formatter: function ()
				{
					return this.series.name + ': ' + this.point.y;
				}
			}
		});
	};

	ICDashboardSubmissions.prototype.Init = function()
	{
		var target = $('#' + this.target);

		var isPages = $('.grid-stack').length > 0;

		var self = this;
		setTimeout(function()
		{
			if (isPages)
				self.AdjustSubmissionsSize(target[0]);

			self.Show(true);
		}, 300);

		if (isPages)
		{
			var tile = target.closest('.js-tile');
			tile.off('pages-tile-resize pages-tile-add');
			tile.on('pages-tile-resize pages-tile-add', function(event, element)
			{
				// The size of the container will not be fixed for a while while it snaps to the grid
				// so delay the layout
				setTimeout(function()
				{
					self.AdjustSubmissionsSize(event.target);

					self.Show(false);
				}, 300);
			});
		}
	};

	ICDashboardSubmissions.prototype.AdjustSubmissionsSize = function(element)
	{
        var container = $(element).find('.js-tile-body-container');
		if (container.length === 0)
			container = $(element).closest('.js-tile-body-container');
		if (container.length > 0)
		{
			var height = container.height();
			container.find('.chart-container').height(height - 30);
		}
	};

	return ICDashboardSubmissions;
});
