define(['jquery', 'cla_highcharts'], function($, Highcharts)
{
	var ICDashboardHandler = function(target, categories, chartType, data, showDataLabels)
	{
		this.target = target;
		this.categories = categories;
		this.chartType = chartType;
		this.data = data;
		this.showDataLabels = showDataLabels;
	};

	ICDashboardHandler.prototype.Show = function(animate)
	{
		// Check if the chart is supposed to be drawn and bail early if not
		$target = $('#' + this.target);
		if ($target.length === 0)
			return;

		var chart = new Highcharts.Chart(
		{
			chart: {
				renderTo: this.target
			},
			title: {
				text: ""
			},
			plotOptions: {
				column: {
					colorByPoint: true
				},
				series: {
					animation: animate,
					point: {
						events: {
							click: function (point) {
								if (point.point.options.link !== '')
									window.open(point.point.options.link, '_blank');
							}
						}
					}
				}
			},
			yAxis: {
				minTickInterval: 1,
				title: {
					text: null
				}
			},
			xAxis: {
				labels: {
					enabled: false
				},
				categories: this.categories
			},
			series: [{
				type: this.chartType,
				data: this.data,
				showInLegend: false,
				dataLabels: {
					enabled: this.showDataLabels
				}
			}],
			tooltip: {
				formatter: function ()
				{
					if (this.point.name.length > 0)
						return this.point.name + ': ' + this.point.y;
					else
						return 'No data';
				}
			}
		});
	};

	ICDashboardHandler.prototype.Init = function()
	{
		var target = $('#' + this.target);

		var isPages = $('.grid-stack').length > 0;

		var self = this;
		setTimeout(function()
		{
			if (isPages)
				self.AdjustHandlerSize(target[0]);

			self.Show(true);
		}, 300);

		if (isPages)
		{
			var tile = target.closest('.js-tile');
			tile.off('pages-tile-resize pages-tile-add');
			tile.on('pages-tile-resize pages-tile-add', function(event, element)
			{
				// The size of the container will not be fixed for a while while it snaps to the grid
				// so delay the layout
				setTimeout(function()
				{
					self.AdjustHandlerSize(event.target);

					self.Show(false);
				}, 300);
			});
		}
	};

	ICDashboardHandler.prototype.AdjustHandlerSize = function(element)
	{
        var container = $(element).find('.js-tile-body-container');
		if (container.length === 0)
			container = $(element).closest('.js-tile-body-container');

		if (container.length > 0)
		{
			var height = container.height();
			var descHeight = container.find('.js-description-container').height();
			var tableHeight = container.find('.chart-table').height();

			if (descHeight > 0)
				descHeight += 10;

			var chartHeight = height - 30 - descHeight - tableHeight - 1;
			container.find('.chart-container').height(chartHeight);
			if (chartHeight < 50)
				container.find('.chart-container').hide();
			else
				container.find('.chart-container').show();
		}
	};

	return ICDashboardHandler;
});
